//  Supers.java -- operations involving superclasses

package toba.translator;

import toba.classfile.*;
import java.io.*;
import java.util.*;


class Supers {


private static ClassData previous;	// last class loaded

//  load(k) -- load and link superclasses of ClassData k
//
//  sets k.superclass, and all method tables (and those of all ancestors)
//
//  It is assumed that previously seen classes can be reused,
//  allowing caching.

static void load(ClassData k)
    throws ClassNotFoundException, IOException
{
    ClassData kp;
    String sname;

    sname = k.supername;		// name of superclass

    if (k.superclass == null && sname != null) {

    	// there is a superclass and it has not been linked in

	for (kp = previous; kp != null; kp = kp.superclass)
	    if (kp.name.equals(sname))
		break;

	if (kp != null)
	    k.superclass = kp;		// found in existing chain
	else {
	    // not found; find and load superclass from file
	    k.superclass = ClassData.forStream (ClassFile.find (sname), false);
            /* Resulting class has to have the right name. */
            if (! sname.equals (k.superclass.name)) {
                throw new ClassNotFoundException (sname);
            }
	    load(k.superclass);		// load superclass's superclasses
	}
    }

    k.state = ClassData.RES_SUPERCLASSES;

    k.buildTables();			// fill in method table
    IHash.mark(k);			// mark interfaces
    previous = k;			// remember class just loaded
}
    




} // class Supers
