/*
 *	sccsid:	@(#)Toolkit.h	1.46	2/26/87
 */

/*
 * Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its 
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in 
 * supporting documentation, and that the name of Digital Equipment
 * Corporation not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

#ifndef _Toolkit_h_
#define _Toolkit_h_



/****************************************************************
 ****************************************************************
 ***                                                          ***
 ***                                                          ***
 ***                   X Toolkit Intrisics                    ***
 ***                                                          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************/





/****************************************************************
 *
 * Miscellaneous definitions
 *
 ****************************************************************/

#include	<sys/types.h>

#ifndef NULL
#define NULL 0
#endif

#define FALSE 0
#define TRUE 1


/****************************************************************
 *
 * Error codes
 *
 ****************************************************************/

typedef	int XtStatus;

#define XtSUCCESS 0	/* No error. */

extern int (*XtErrorFunction)();
extern int XtreferenceCount;

/* Associative lookup table error codes */

#define XtNOMEM   1    /* Out of memory */
#define XtNOENT   2    /* No entry in table */
#define XtFOPEN   3    /* fopen failed. */

/* Other errors. */

#define XtNOTWINDOW 3	/* Given window id is invalid. */

/* Atom Errors */
#define XtATOMCOLLISION 4

/****************************************************************
 *
 * Memory Allocation
 *
 ****************************************************************/

extern void XtInitToolkit();

/****************************************************************
 *
 * Memory Allocation
 *
 ****************************************************************/

#ifndef _Alloc_c_

extern char *XtMalloc(); /* num */
    /* unsigned num; */

extern char *XtCalloc(); /* num, size */
    /* unsigned num, size; */

extern char *XtRealloc(); /* ptr, num */
    /* char *ptr; */
    /* unsigned num; */

extern void XtFree(); /* ptr */
    /* char *ptr; */

#endif




/****************************************************************
 *
 * Atom Management
 *
 ****************************************************************/

#define NULLATOM 0
typedef char *AtomName;
typedef AtomName *Atom;

typedef Atom *AtomList;

typedef struct _AtomDescRec {
    Atom	*atom;
    char	*name;
} AtomDescRec, *AtomDesc;

typedef struct _DefineAtomDescRec {
    Atom	atom;
    char	*name;
} DefineAtomDescRec, *DefineAtomDesc;

/* find atom for name, create new atom if none already exists */
extern Atom XtMakeAtom(); /* name */
    /* char *name; */

/* create a new atom, of name name. If one already exists, make sure the */
/* names don't collide. Does not copy the name string chars, */
/* instead it just saves the char * */
extern void XtDefineAtom(); /* atom, name */
   /* Atom	atom; */
   /* AtomName	name; */

/* find atom for name, return null if none exists */
extern Atom XtFindAtom(); /* name */
    /* AtomName name; */

extern Atom XtUniqueAtom();

extern void XtMakeAtomBatch(); /* desc */
    /* AtomDesc	desc; */

extern void XtDefineAtomBatch(); /* desc */
    /* DefineAtomDesc	desc; */

extern char *XtNameForAtom(); /* atom */
    /* Atom atom; */

extern void XtInitAtoms(); /* must be called before any exported atoms */
			   /* names are used */




/****************************************************************
 *
 * Atom Lists
 *
 ****************************************************************/

extern AtomList XtNewAtomList();

extern AtomList XtFreeAtomList(); /* list */
    /* AtomList	list; */

extern int XtAtomListLength();

extern AtomList XtCopyAtomList(); /* list */ /* list is NOT freed */
    /* AtomList	list; */

extern AtomList XtPrependAtomList(); /* list, atom */ /* list IS FREED */
    /* AtomList	list; */
    /* Atom	atom; */

extern AtomList XtAppendAtomList(); /* list, atom */ /* list IS FREED */
    /* AtomList	list; */
    /* Atom	atom; */




/****************************************************************
 *
 * Arg lists
 *
 ****************************************************************/

typedef struct _Arg {
    Atom	name;
    caddr_t	value;
} Arg, *ArgList;

#define XtSetArg(arg, n, d) \
       ( (arg).name = (n), \
       (arg).value = (caddr_t)(d) )




/****************************************************************
 *
 * Context Management
 *
 ****************************************************************/

extern XtStatus XtSaveEntry(); /* window, type, data */
    /* Window	window; */
    /* Atom	type; */
    /* caddr_t	data; */

extern XtStatus XtFindEntry(); /* window, type, data */
    /* Window	window; */
    /* Atom	type; */
    /* caddr_t	*data; */

extern XtStatus XtDeleteEntry(); /* window, type */
    /* Window	window; */
    /* Atom	type; */




/****************************************************************
 *
 * Event Management
 *
 ****************************************************************/

typedef struct _XtToolkitEvent {
    unsigned long type;
    Window window;
    Atom msg;	/* msgs should be able to go across address spaces */
		/* so they shouldn't be (client) atoms... */
    Arg *arglist;
    Window subwindow;
    long unused;
} XtToolkitEvent;

#define ResizeWindow 0x0081 /* Faked XEvent code for windows changing size */
#define MessageEvent 0x0082  /* Faked XEvent code for messages to widgets */
#define DestroyWindow 0x0083 /* Faked XEvent code for destroying a window */

/* Messages */
/* currently messages must not be sent across address spaces! */
extern AtomName	XtNgetvalue, XtNsetvalue;
#define XtAgetvalue	&XtNgetvalue
#define XtAsetvalue	&XtNsetvalue

typedef enum _XtEventReturnCode {
    processed,          /* Event dispatched and handled */
    nothandled,         /* Event not handled by event proc */
    noentry             /* Entry not found. */
} XtEventReturnCode;

typedef XtEventReturnCode (*XtEventProc)(); /* event, data */
    /* XEvent *event; */
    /* caddr_t data; */

extern void XtSetXEventDispatch(); /* w, proc, eventmask, data */
    /* Window w; */
    /* XtEventProc proc; */
    /* int eventmask; */
    /* caddr_t data; */

extern void XtDeleteXEventDispatch(); /* w, proc */
    /* Window w; */
    /* XtEventProc proc; */

extern XtEventReturnCode XtDispatchXEvent(); /* event */
    /* XEvent	*event; */

extern void XtSetNotify(); /* proc, mask, data */
    /* XtEventProc proc; */
    /* int mask; */
    /* caddr_t data; */

extern void XtDisableAutoGrab(); /* w */
    /* Window w; */

extern void XtEnableAutoGrab(); /* w */
    /* Window w; */

extern void XtDestroyWindow(); /* window */
    /* Window window; */

extern void XtGrabMouse(); /* w, cursor, mask */
    /* Window w; */
    /* Cursor cursor; */
    /* int mask; */

extern void XtUngrabMouse();

extern XtEventReturnCode XtSendExposeWindow(); /* w */
    /* Window w; */



/****************************************************************
 *
 * Geometry Management
 *
 ****************************************************************/

typedef enum _XtGeometryReturnCode {
    requestYes,         /* Request accepted. */
    requestNo,          /* Request denied. */
    requestAlmost,      /* Request denied. */
    requestNoEntry      /* Request denied: couldn't find geo manager */
} XtGeometryReturnCode;

typedef struct _WindowBox {
    int x, y, width, height, bdrwidth;
} WindowBox, *WindowBoxPtr;

typedef struct _WindowLug {
    Window w;
    WindowBox wb;
} WindowLug, *WindowLugPtr;

typedef XtGeometryReturnCode (*XtGeometryHandlerProc)();
    /* w, request, requestBox, replyBox */
    /* Window w; */
    /* Atom   request; */
    /* WindowBox *requestBox; */
    /* WindowBox *replyBox; /* RETURN */

extern AtomName XtNmove, XtNresize, XtNtop, XtNbottom, XtNgetwindowbox;
#define XtAmove	&XtNmove
#define XtAresize	&XtNresize
#define XtAtop	&XtNtop
#define XtAbottom	&XtNbottom
#define XtAgetwindowbox	&XtNgetwindowbox

extern XtStatus XtSetGeometryRequest();  /* w, proc */
    /* Window w; */
    /* XtGeometryHandlerProc proc; */

extern XtStatus XtGetGeometryRequest(); /* w, proc */
    /* Window w; */
    /* XtGeometryReturnCode (**proc)(); */

extern XtStatus XtClearGeometryRequest();  /* w */
    /* Window w; */

extern XtGeometryReturnCode XtMakeGeometryRequest();
    /* w, request, requestBox, replyBox */
    /* Window w; */
    /* Atom request; */ /* XtAmove, XtAresize, XtAtop, XtAbottom */
    /* WindowBox *requestBox; */
    /* WindowBox *replyBox; /* RETURN */




/****************************************************************
 *
 * Messages
 *
 ****************************************************************/

extern XtEventReturnCode XtSendEvent(); /* w, type */
    /* Window w; */
    /* unsigned long type; */

extern XtEventReturnCode XtSendDestroyMessage(); /* w */
    /* Window w; */

extern XtEventReturnCode XtSendMessage(); /* w, type, arglist */
    /* Window w; */
    /* Atom type; */
    /* ArgList arglist; */

extern XtStatus XtGetWindowSize(); /* window, width, height, bdrwidth */
    /* Window window; */
    /* int *width, *height, *bdrwidth; */


/****************************************************************
 *
 * Resource Lists
 *
 ****************************************************************/

typedef struct _Resource {
    Atom		name;
    Atom		class;
    Atom		type;
    unsigned int	size;
    caddr_t		addr;
    caddr_t		defaultaddr;
    int			found;
} Resource, *ResourceList;

extern void XtGetResources();
    /* resourcelist, arglist, parent, defaultName, defaultClass, name, class */
    /* ResourceList		resourcelist; */
    /* ArgList			arglist; */
    /* Window			parent; */
    /* Atom			defaultName, defaultClass */
    /* AtomList			*name, *class; /* RETURN */

extern void XtSetNameAndClass(); /* w, name, class */
    /* Window	w; */
    /* AtomList name, class; */

extern void XtGetNameAndClass(); /* w, name, class */
    /* Window	w; */
    /* AtomList *name, *class; /* RETURN */

extern void XtGetValue(); /* resourcelist, arglist */
    /* ResourceList	resourcelist; */
    /* ArgList			arglist; */

extern void XtSetValue(); /* resourcelist, arglist */
    /* ResourceList	resourcelist; */
    /* ArgList			arglist; */

extern int XtDefaultFGPixel, XtDefaultBGPixel;
extern Pixmap XtDefaultFGPixmap, XtDefaultBGPixmap;


/****************************************************************
 *
 * Resource Types and Conversions
 *
 ****************************************************************/

typedef struct _XrmValue {
    unsigned int	size;
    caddr_t		addr;
} XrmValue, *XrmValuePtr;

typedef struct _XrmTypedValue {
    Atom	type;
    XrmValue	value;
} XrmTypedValue, *XrmTypedValuePtr;

typedef	 void (*ConvertTypeProc)();
    /* from, toType, to */
    /* XrmTypedValue from; */
    /* Atom toType; */
    /* XrmValue *to; */

extern AtomName	XtNName, XtNReverseVideo;

#define XtAName &XtNName
#define XtAReverseVideo &XtNReverseVideo

/* predefined resource Names */

extern AtomName	XtNAtom, XtNBackground, XtNBodyFont, XtNBorder, XtNBorderWidth,
		XtNFile, XtNFont, XtNForeground, XtNFunction, XtNHeight,
		XtNIndex, XtNInternalHeight, XtNInternalWidth, XtNJustify, 
		XtNLabel, XtNLength, XtNNotify, XtNOrientation, XtNParameter,
		XtNString, XtNValue, XtNWidth, XtNWindow;

#define XtAAtom	&XtNAtom
#define XtABackground	&XtNBackground
#define XtABodyFont	&XtNBodyFont
#define XtABorder	&XtNBorder
#define XtABorderWidth	&XtNBorderWidth
#define XtAFile	&XtNFile
#define XtAFont	&XtNFont
#define XtAForeground	&XtNForeground
#define XtAFunction	&XtNFunction
#define XtAHeight	&XtNHeight
#define XtAIndex	&XtNIndex
#define XtAInternalHeight	&XtNInternalHeight
#define XtAInternalWidth	&XtNInternalWidth
#define XtAJustify      &XtNJustify
#define XtALabel	&XtNLabel
#define XtALength	&XtNLength
#define XtANotify	&XtNNotify
#define XtAOrientation	&XtNOrientation
#define XtAParameter	&XtNParameter
#define XtAString	&XtNString
#define XtAValue	&XtNValue
#define XtAWidth	&XtNWidth
#define XtAWindow	&XtNWindow

/* predefined resource types */

extern AtomName	XtNatom, XtNbitmap, XtNboolean, XtNbrush, XtNchar, XtNcolor,
		XtNcursor, XtNdims, XtNdisplay, XtNdnaddr, 
		XtNenum, XtNeventbindings, XtNeventtype,
		XtNfalse, XtNfile, XtNfont, XtNfontinfo, XtNgeometry,
		XtNgfunc, XtNheight, XtNinaddr, XtNint, XtNjustify, XtNkey, 
		XtNno, XtNoff, XtNon, XtNpixel, XtNpixmap,
		XtNpointer, XtNpos, XtNstring,
		XtNtile, XtNtrue, XtNwidgetclass, XtNwidgetname, XtNwidth,
		XtNwindow, XtNwindowinfo, XtNxpos, XtNyes, XtNypos;

#define XtAatom	&XtNatom
#define XtAbitmap	&XtNbitmap
#define XtAboolean	&XtNboolean
#define XtAbrush	&XtNbrush
#define XtAchar	&XtNchar
#define XtAcolor	&XtNcolor
#define XtAcursor	&XtNcursor
#define XtAdims	&XtNdims
#define XtAdisplay	&XtNdisplay
#define XtAdnaddr	&XtNdnaddr
#define XtAenum	&XtNenum
#define XtAeventbindings	&XtNeventbindings
#define XtAeventtype	&XtNeventtype
#define XtAfalse	&XtNfalse
#define XtAfile	&XtNfile
#define XtAfont	&XtNfont
#define XtAfontinfo	&XtNfontinfo
#define XtAgeometry	&XtNgeometry
#define XtAgfunc	&XtNgfunc
#define XtAheight	&XtNheight
#define XtAinaddr	&XtNinaddr
#define XtAint	&XtNint
#define XtAjustify      &XtNjustify
#define XtAkey	&XtNkey
#define XtAno	&XtNno
#define XtAoff	&XtNoff
#define XtAon	&XtNon
#define XtApixel	&XtNpixel
#define XtApixmap	&XtNpixmap
#define XtApointer	&XtNpointer
#define XtApos	&XtNpos
#define XtAstring	&XtNstring
#define XtAtile	&XtNtile
#define XtAtrue	&XtNtrue
#define XtAwidgetclass	&XtNwidgetclass
#define XtAwidgetname	&XtNwidgetname
#define XtAwidth	&XtNwidth
#define XtAwindow	&XtNwindow
#define XtAwindowinfo	&XtNwindowinfo
#define XtAxpos	&XtNxpos
#define XtAyes	&XtNyes
#define XtAypos	&XtNypos

extern void XtRegisterTypeConverter(/*fromType, toType, convertProc*/);
    /* Atom fromType, toType; */
    /* ConvertTypeProc convertProc; */

extern void XtConvert(/* from, toType, to*/);
    /* XrmTypedValue from; */
    /* Atom toType; */
    /* XrmValue *to; */

/****************************************************************
 *
 * Resource Database Management
 *
 ****************************************************************/

typedef struct		ResourceDataBaseStruct *ResourceDataBase;
typedef int		unspecified;

extern void XtSetCurrentDataBase(/*db*/);
    /* ResourceDataBase db; */

extern void XtGetCurrentDataBase(/*db*/);
    /* ResourceDataBase *db; */

extern void XtGetDataBase(/*magicCookie, db*/);
    /* unspecified magicCookie; /* file */
    /* ResourceDataBase *db; */

extern void XtPutDataBase(/*magicCookie, db*/);
    /* unspecified magicCookie; /* file */
    /* ResourceDataBase db; */

extern void XtMerge(/*new, into*/);
    /* ResourceDataBase new, *into; */




/****************************************************************
 *
 * Command line option mapping to resource entries
 *
 ****************************************************************/

/* Don't blame me for the names below.  I tried to make this match the rest of
   the Toolkit, only to find completely inconsistent naming conventions. */

typedef enum _OptionKind {
    noarg,      /* Value is specified in OptionDescRec.value		    */
    isarg,      /* Value is the option string itself			    */
    stickyarg,  /* Value is characters immediately following option	    */
    separg,     /* Value is next argument in argv			    */
    skiparg,    /* Ignore this option and the next argument in argv	    */
    skipline    /* Ignore this option and the rest of argv		    */
} OptionKind;

typedef struct _OptionDescRec {
    char	*option;	/* Option abbreviation in argv		    */
    char	*resource_name; /* Resource name (sans application name)    */
    OptionKind  argkind;	/* Which style of option it is		    */
    caddr_t     value;		/* Value to provide if stickyarg	    */
} OptionDescRec, *OptionDescPtr;

typedef struct _CompiledOptionRec {
    char	*option;
    AtomList    resource_name;
    OptionKind  argkind;
    caddr_t     value;
} CompiledOptionRec, *CompiledOptionPtr;


extern CompiledOptionPtr XtCompileOptions(); /* table, prependName      */
    /* OptionDescPtr    table;						*/
    /* Atom		prependName; (NULLATOM means don't prepend)     */

extern void XtParseCommand(); /* table, argc, argv */
    /* CompiledOptionPtr table;  */
    /* int		 *argc;  */
    /* char		 **argv; */



/****************************************************************
 *
 * Translation Management
 *
 ****************************************************************/

typedef caddr_t XtEventsPtr;

typedef struct _XtActionsRec {
    char *string;
    caddr_t value;
} XtActionsRec, *XtActionsPtr;

/* Different classes of action tokens */

typedef enum _TokenType {TTchar, TTstring, TTatom} TokenType;

/* List of tokens. */

typedef struct _XtActionTokenRec {
    TokenType type;
    union {
	char c;
	char *str;
	Atom atom;
    } value;
    struct _XtActionTokenRec *next;
} XtActionTokenRec, *XtActionTokenPtr;

extern XtEventsPtr XtSetActionBindings(); /* eventTable, actionTable, default */
  /*  XtEventsPtr eventTable; */
  /*  XtActionsPtr actionTable; */
  /*  caddr_t default; */

extern XtEventsPtr XtParseEventBindings(); /* stringTable */
  /* char **stringTable */

extern caddr_t XtInterpretAction();


/****************************************************************
 ****************************************************************
 ***                                                          ***
 ***                                                          ***
 ***                   X Toolkit Widgets                      ***
 ***                                                          ***
 ***                                                          ***
 ****************************************************************
 ****************************************************************/




/***********************************************************************
 *
 * Command Button Widget
 *
 ***********************************************************************/

extern AtomName	XtNfunction, XtNparameter;

#define XtAfunction	&XtNfunction
#define XtAparameter	&XtNparameter

typedef enum _XtEjustify {
    leftjustify,       /* justify text to left side of button */
    centerjustify,     /* justify text in center of button */
    rightjustify       /* justify text to right side of button */
} XtEjustify;


/*

 New parameter types
 ==================

 Name		Type		Comment
 ----		----		-------
 function	void (*)()	procedure returning status, takes caddr_t

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		create window
 BorderWidth	int		int		1
 Width		int		int		text width + 2*InternalWidth
 Height		int		int		font height + 2*InternalHeight
 InternalWidth	int		int		4
 InternalHeight	int		int		2
 Label		string		string		Dummy
 Foreground	color		pixel		BlackPixel
 Background	color		pixel		WhitePixel
 Border		color		pixmap		BlackPixmap
 Font		font		fontinfo	helv10b
 Justify        XtEjustify      XtEjustify      centerjustify
 Function	function	function	do nothing
 Parameter	pointer		pointer		NULL
 Highlight	int		int		EnterWindow
 Unhighlight	int		int		LeaveWindow
 Notify		int		int		ButtonReleased

*/

extern Window XtCreateCommand (); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Label Widget
 *
 ***********************************************************************/

/*
typedef enum _XtEjustify {
    leftjustify, 
    centerjustify,
    rightjustify  
} XtEjustify;
note: already defined in Command Button section 
*/


/*

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		create window
 BorderWidth	int		int		1
 Width		int		int		text width + 2*InternalWidth
 Height		int		int		font height + 2*InternalHeight
 InternalWidth	int		int		4
 InternalHeight	int		int		2
 Label		string		string		Dummy
 Foreground	color		pixel		BlackPixel
 Background	color		pixel		WhitePixel
 Border		color		pixmap		BlackPixmap
 Font		font		fontinfo	helv10b
 Justify        justify         atom            centerJustify

*/

extern AtomName XtNleftJustify, XtNcenterJustify, XtNrightJustify;

#define XtAleftJustify	&XtNleftJustify
#define XtAcenterJustify	&XtNcenterJustify
#define XtArightJustify	&XtNrightJustify
 
extern Window XtCreateLabel(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Boolean Button Widget
 *
 ***********************************************************************/

extern AtomName	XtNHighlight, XtNUnhighlight, XtNOn, XtNOff, XtNToggle;

#define XtAHighlight &XtNHighlight
#define XtAUnhighlight &XtNUnhighlight
#define XtAOn &XtNOn
#define XtAOff &XtNOff
#define XtAToggle &XtNToggle

/*

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Value		pointer		pointer		NONE, required parameter
 Window		window		window		create window
 BorderWidth	int		int		1
 Width		int		int		text width + 2*InternalWidth
 Height		int		int		font height + 2*InternalHeight
 InternalWidth	int		int		4
 InternalHeight	int		int		2
 Label		string		string		Dummy
 Foreground	color		pixel		BlackPixel
 Background	color		pixel		WhitePixel
 Border		color		pixmap		BlackPixmap
 Font		font		fontinfo	helv10b
 Highlight	int		int		EnterWindow
 Unhighlight	int		int		LeaveWindow
 On		int		int		NoEvent
 Off		int		int		NoEvent
 Toggle		int		int		ButtonPressed

*/

extern Window XtCreateBoolean(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* Arg * arglist; */




/***********************************************************************
 *
 * Button Box Widget
 *
 ***********************************************************************/

extern AtomName XtNHSpace, XtNVSpace, XtNButton;

#define XtAHSpace &XtNHSpace
#define XtAVSpace &XtNVSpace
#define XtAButton &XtNButton

/*

extern AtomName XtNButton;
#define XtAButton	&XtNButton;

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		create window
 Width		int		int		chosen arbitrarily
 Height		int		int		chosen arbitrarily
 BorderWidth	int		int		1
 Border		color		pixmap		BlackPixmap
 Background	color		pixmap		WhitePixmap
 HSpace		int		int		4
 VSpace		int		int		4
 Button		window		window		<none, optional, repeated>

*/

extern Window XtCreateButtonBox(); /* pw, arglist */
    /* Window pw;                      /* parent window */
    /* ArgList arglist; */

/*

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		NONE, required parameter
 Index		int		int		0

*/

extern XtStatus XtButtonBoxAddButton(); /* w, arglist */
    /* Window	w; */
    /* ArgList	arglist; */

/*

 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		computed from index (*)
 Index		int		int		computed from window (*)

* - one of Window or Index is required.

*/

extern XtStatus XtButtonBoxDeleteButton(); /* w, arglist */
    /* Window	w; */
    /* ArgList	arglist; */




/****************************************************************
 *
 * Form Widget
 *
 ****************************************************************/

#define NULLARRAY	1               /* NULL array passed. */
#define NOTAFORM	2               /* NULL array passed. */

extern AtomName XtNabsoluteX,       /* Offset from parent's origin       */
		XtNunchangedX,      /* Same as previous tool             */
		XtNrelativeX,       /* Offset from last tool's x-pos     */
		XtNcolumnAligned,   /* Tab to next column		 */
		XtNcenterX;         /* Center tool in parent window      */

extern AtomName	XtNabsoluteY,       /* Offset from parent's origin       */
		XtNunchangedY,      /* Same as previous tool             */
		XtNrelativeY,       /* Offset from last tool's x-pos     */
		XtNnewLine,         /* Left margin, then next y "line"   */
		XtNnewLinePlus,     /* Same as NewLine plus delta        */
		XtNcenterY;         /* Immediately under last tool       */

extern AtomName XtNabsoluteW,       /* Use specified width               */
		XtNuseWindowWidth,  /* Use width of widget window        */
		XtNunchangedW,      /* Same as previous tool             */
		XtNcurrentW,        /* Use current width of tool         */
		XtNparentW,         /* Extend full width of parent       */
		XtNparentRight;     /* Extend to right border of parent  */

extern AtomName XtNabsoluteH,       /* Use specified height              */
		XtNuseWindowHeigth, /* Use height of widget window       */
		XtNunchangedH,      /* Same as previous tool             */
		XtNcurrentH,        /* Use current height of tool        */
		XtNparentH,         /* Extend full height of parent      */
		XtNparentBottom;    /* Extend to bottom border of parent */

#define XtAabsoluteX	&XtNabsoluteX
#define XtAunchangedX	&XtNunchangedX
#define XtArelativeX	&XtNrelativeX
#define XtAcolumnAligned	&XtNcolumnAligned
#define XtAcenterX	&XtNcenterX
#define XtAabsoluteY	&XtNabsoluteY
#define XtAunchangedY	&XtNunchangedY
#define XtArelativeY	&XtNrelativeY
#define XtAnewLine	&XtNnewLine
#define XtAnewLinePlus	&XtNnewLinePlus
#define XtAcenterY	&XtNcenterY
#define XtAabsoluteW	&XtNabsoluteW
#define XtAuseWindowWidth	&XtNuseWindowWidth
#define XtAunchangedW	&XtNunchangedW
#define XtAcurrentW	&XtNcurrentW
#define XtAparentW	&XtNparentW
#define XtAparentRight	&XtNparentRight
#define XtAabsoluteH	&XtNabsoluteH
#define XtAuseWindowHeigth	&XtNuseWindowHeigth
#define XtAunchangedH	&XtNunchangedH
#define XtAcurrentH	&XtNcurrentH
#define XtAparentH	&XtNparentH
#define XtAparentBottom	&XtNparentBottom




/****************************************************************
 *
 * Scrollbar Widget
 *
 ****************************************************************/
typedef enum _Orient {Horizontal, Vertical} Orient;
/*** The above is obsolete ***/

extern AtomName XtNhorizontal, XtNvertical, XtNClientWindow, XtNThumb,
		XtNTopPercent, XtNpercent, XtNfloat, XtNShownPercent;

#define XtAhorizontal &XtNhorizontal
#define XtAvertical &XtNvertical
#define XtAClientWindow &XtNClientWindow
#define XtAThumb &XtNThumb
#define XtATopPercent &XtNTopPercent
#define XtApercent &XtNpercent
#define XtAfloat &XtNfloat
#define XtAShownPercent &XtNShownPercent

/* Parameters:

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		create window
 Orientation	orientation	atom		horizontal
 ClientWindow	window		window		parent window
 Width		width		int		1
 Height		height		int		1
 BorderWidth	borderwidth	int		1
 Border		color		pixel		Default foreground
 ScrollUpDownProc function	function	No-op
 ThumbProc	function	function	No-op
 Foreground	color		pixel		Default foreground
 Background	color		pixel		Default background
 Thumb		pixmap		pixmap		Grey
 TopPercent	percent		float		0.0
 ShownPercent	percent		float		0.0

*/

extern Window XtCreateScrollBar(); /*parent, arglist*/
/* Window parent; */
/* ArgList arglist; */

extern void XtDestroyScrollBar(); /* scrollbarWindow */
/* Window scrollbarWindow; */

extern void XtSetScrollBarPercentages(); /* scrollbarWindow, topPercent, 
					    shownPercent*/
/* Window scrollbarWindow; */
/* float topPercent, shownPercent; */


/****************************************************************
 *
 * Scrollbar Manager Widget
 *
 ****************************************************************/

extern AtomName XtNChildWindow, XtNThickness, XtNthickness;

#define XtAChildWindow &XtNChildWindow
#define XtAThickness &XtNThickness
#define XtAthickness &XtNthickness

/* Parameters:

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		<Created>
 ChildWindow	window		window		<Created>
 BorderWidth	borderwidth	int		1
 Border		pixmap		pixmap		Default Foreground
 Thickness	thickness	int		15
 Width		width		int		1
 Height		height		int		1
 X		x		int		0
 Y		y		int		0


Parameters for XtAddScrollBar():

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Lowerright	boolean		boolean		false
 Orientation	orientation	atom		vertical
*/


extern Window XtCreateWithScrollBars(); /* pw, arglist */
/* Window pw; */
/* ArgList arglist; */

extern Window XtScrollBarsGetChild(); /* pw */
/* Window pw; */

extern Window XtScrollBarsSetChild(); /* pw, child */
/* Window pw, child; */

extern XtUnarrangeWithScrollBars(); /* w */
/* Window w; */

extern XtSetScrollBarThickness(); /* w, thickness */
/* Window w; */
/* int thickness; */

extern int XtGetScrollBarThickness(); /* w */
/* Window w; */

extern Window XtAddScrollBar(); /* w, arglist */
/* Window w; */
/* ArgList arglist; */

extern XtRemoveScrollBar(); /* w, sbar */
/* Window w, sbar; */


/****************************************************************
 *
 * Scrolled Window Widget
 *
 ****************************************************************/

#define SWUseBottom	0x01	/* Use the bottom for horiz bars, not top */
#define SWUseRight	0x02	/* Use the right for vert bars, not left */
#define SWAllowHorizBar	0x04	/* Allow the window to become too wide */
#define SWAllowVertBar	0x08	/* Allow the window to become too high */
#define SWForceBars	0x10	/* Force the above bars to appear even if
				   the window is currently narrow enough. */
/**** The above is obsolete ****/
extern AtomName	XtNLowerright, XtNScrollUpDownProc, XtNThumbProc,
		XtNInnerwidth, XtNInnerheight, XtNInnerheight,
		XtNForcebars, XtNAllowhoriz, XtNAllowvert,
		XtNUsebottom, XtNUseright, XtNInnerwindow;

#define XtALowerright	&XtNLowerright
#define XtAScrollUpDownProc	&XtNScrollUpDownProc
#define XtAThumbProc	&XtNThumbProc
#define XtAInnerwidth	&XtNInnerwidth
#define XtAInnerheight	&XtNInnerheight
#define XtAInnerheight	&XtNInnerheight
#define XtAForcebars	&XtNForcebars
#define XtAAllowhoriz	&XtNAllowhoriz
#define XtAAllowvert	&XtNAllowvert
#define XtAUsebottom	&XtNUsebottom
#define XtAUseright	&XtNUseright
#define XtAInnerwindow	&XtNInnerwindow

/* Parameters:

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Innerwidth	width		int		1
 Innerheight	height		int		1
 Innerwindow	window		window		<Created>
 Forcebars	boolean		boolean		false
 Allowhoriz	boolean		boolean		false
 Allowvert	boolean		boolean		false
 Usebottom	boolean		boolean		false
 Useright	boolean		boolean		false
*/
extern Window XtCreateScrolledWindow(); /* parent, arglist */
/* Window parent; */
/* ArgList arglist; */

extern Window XtScrolledWindowGetChild(); /* outer */
/* Window outer; */

extern Window XtScrolledWindowSetChild(); /* pw, child */
/* Window pw, child; */

extern Window XtScrolledWindowGetFrame(); /* outer */
/* Window outer; */

extern Window XtUnmakeScrolledWindow(); /* outer */
/* Window outer; */


/****************************************************************
 *
 * Text widget
 *
 ****************************************************************/

extern AtomName	XtNEditType, XtNedittype, XtNDisplayPosition, 
		XtNtextposition, XtNTextPosition,
		XtNSelection, XtNtextselection, XtNTextSelection,
		XtNSelectionArray, XtNselectionarray,
		XtNTextSink, XtNtextsink, XtNTextSource, XtNtextsource,
		XtNEventBindings, XtNeventBindings,
		XtNsource, XtNsink, XtNTextOptions, XtNtextoptions,
		XtNLeftMargin, XtNInsertPosition;

#define XtAEditType &XtNEditType
#define XtAedittype &XtNedittype
#define XtADisplayPosition	&XtNDisplayPosition
#define XtAtextposition	&XtNtextposition
#define XtATextPosition	&XtNTextPosition
#define XtASelection	&XtNSelection
#define XtAtextselection	&XtNtextselection
#define XtATextSelection	&XtNTextSelection
#define XtASelectionArray	&XtNSelectionArray
#define XtAselectionarray	&XtNselectionarray
#define XtATextSink	&XtNTextSink
#define XtAtextsink	&XtNtextsink
#define XtATextSource	&XtNTextSource
#define XtAtextsource	&XtNtextsource
#define XtAEventBindings	&XtNEventBindings
#define XtAeventBindings	&XtNeventBindings
#define XtAsource	&XtNsource
#define XtAsink		&XtNsink
#define XtATextOptions		&XtNTextOptions
#define XtAtextoptions		&XtNtextoptions
#define XtALeftMargin		&XtNLeftMargin
#define XtAInsertPosition	&XtNInsertPosition

/* 

 Parameters
 ==========

 Name		 Class		 RepType	 Default Value
 ----		 -----		 -------	 -------------
 Window          window          Window          create window
 Foreground      color           Pixmap          BlackPixmap
 Background      color           Pixmap          WhitePixmap
 Border          pixmap          Pixmap          BlackPixmap
 BorderWidth     int             int             4
 DisplayPosition textposition    TTextPosition   0
 Selection       textselection   pointer         {0,0,posSelection}
 SelectionArray  selectionarray  pointer         {posSelection, wordSelection,
						 lineSelection, paraSelection,
						 allSelection, nullSelection}
 TextOptions     textoptions     int 		 0
 LeftMargin      int             int             2
 RightMargin     int             int             2
 InsertPosition  textpositon     TTextPosition   0
 Font            font            FontInfo        helv10b
 TextString      string          string          NULL
 TextLength      int             int             100
 TextFileName    string          string          tmname()

*/

extern Window XtCreateDiskText(); /* pw, arglist */
    /* Window pw;		  /* parent window */
    /* Arg * arglist; */

extern Window XtCreateStringText(); /* pw, arglist */
    /* Window pw;		  /* parent window */
    /* Arg * arglist; */

extern XtDestroyDiskText(); /* w */
    /* Window w; */

extern XtDestroyStringText(); /* w */
    /* Window w; */


typedef enum _XtEditType {textRead, textAppend, textEdit} XtEditType;
#define wordBreak		0x01
#define scrollVertical		0x02
#define scrollHorizontal	0x04
#define scrollOnOverflow	0x08
#define resizeWidth		0x10
#define resizeHeight		0x20
#define editable		0x40


/****************************************************************
 *
 * VPane
 *
 ****************************************************************/

extern AtomName	XtNX, XtNx, XtNY, XtNy, XtNborderwidth, XtNKnobwidth,
		XtNknobwidth, XtNKnobheight, XtNknobheight, XtNKnobindent,
		XtNknobindent, XtNKnobpixmap, XtNknobpixmap;

#define XtAX &XtNX
#define XtAx &XtNx
#define XtAY &XtNY
#define XtAy &XtNy
#define XtAborderwidth &XtNborderwidth
#define XtAKnobwidth &XtNKnobwidth
#define XtAknobwidth &XtNknobwidth
#define XtAKnobheight &XtNKnobheight
#define XtAknobheight &XtNknobheight
#define XtAKnobindent &XtNKnobindent
#define XtAknobindent &XtNknobindent
#define XtAKnobpixmap &XtNKnobpixmap
#define XtAknobpixmap &XtNknobpixmap

extern Window XtCreateVPanedWindow(); /* ourparent, arglist */
    /* Window ourparent; */
    /* ArgList arglist; */

extern void XtUnmakeVPanedWindow(); /* w */
    /* Window w; */

extern void XtAddToVPanedWindow();
		/* w, subwindow, position, min, max, autochange */
    /* Window w, subwindow; */
    /* int position, min, max, autochange; */

extern void XtVPanedSetMinMax(); /* w, subwindow, min, max */
    /* Window w, subwindow; */
    /* int min, max; */

extern void XtDeleteFromVPanedWindow(); /* w, subwindow */
    /* Window w, subwindow; */

extern void XtVPanedRefigureMode(); /* window, mode */
    /* Window window; */
    /* short mode; */


/****************************************************************
 *
 * Basic Menu Widget
 *
 ****************************************************************/

extern AtomName	XtNorientation, XtNinternalwidth, XtNinternalheight, XtNSpace,
		XtNspace, XtNMenuEntry, XtNmenuentry;

#define XtAorientation &XtNorientation
#define XtAinternalwidth &XtNinternalwidth
#define XtAinternalheight &XtNinternalheight
#define XtASpace &XtNSpace
#define XtAspace &XtNspace
#define XtAMenuEntry &XtNMenuEntry
#define XtAmenuentry &XtNmenuentry

/*
 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		Window		<Created>
 Width		int		int		1
 Height		int		int		1
 Orientation	orientation	Atom		vertical
 BorderWidth	int		int		1
 Border		color		Pixmap		BlackPixmap
 Background	color		Pixmap		WhitePixmap
 InternalWidth	int		int		2
 InternalHeight	int		int		2
 Space		space		int		1
 Function	function	function	<built-in debug function>
 Parameter	pointer		caddr_t		0
 Notify		int		int		0

 Parameters for XtAddMenuEntry():
 ================================

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 MenuEntry	menuentry	XtMenuEntry	<none>



The callback function should look like:

void function(tag)
caddr_t tag;
{
}

*/

typedef struct _XtMenuEntry {
    Window index;	/* insert w in front of this window; NULL=append*/
    Window w;		/* window id of entry to be added */
} XtMenuEntry, *XtMenuEntryPtr;

extern Window XtCreateMenu(); /* pw, arglist */
    /* Window pw; */	/* parent window */
    /* Arg *arglist; */	/* argument list */

extern XtStatus XtAddMenuEntry(); /* w, arglist */
    /* Window w; */	/* Menu window */
    /* Arg *arglist; */	/* argument list */

extern Window XtDeleteMenuEntry(); /* pw, arglist */
    /* Window pw; */	/* parent window */
    /* Arg *arglist; */	/* argument list */

/*
 * Note: The following default menu geometry manager is provided as an
 * aid to prototyping pop-up menus.  It says "requestYes" to everything.
 * Clients should replace this with their own geometry manager as
 * necessary.
 */
extern XtGeometryReturnCode XtMenuGeometryManager(); /* w,req,reqBox,repBox */
    /* Window w; */	/* window requesting geometry change */
    /* Atom req; */	/* ignored, but must be present */
    /* WindowBox *reqBox, *RepBox; */ /* size boxes for request */





/****************************************************************
 *
 * *Temporary* *implementation* of Dialog box widget
 *
 ****************************************************************/


extern AtomName XtNDialogButtons, XtNdialogbuttons, XtNDialogValue,
		XtNdialogvalue;

#define XtADialogButtons &XtNDialogButtons
#define XtAdialogbuttons &XtNdialogbuttons
#define XtADialogValue &XtNDialogValue
#define XtAdialogvalue &XtNdialogvalue

extern Window XtCreateDialog(); /* pw, arglist */
  /* Window pw; */
  /* ArgList arglist; */

extern void XtDestroyDialog(); /* w */
  /* Window w; */

extern char *XtDialogValue(); /* w */
  /* Window w; */

extern XtAlignWindow(); /* window, align, xres, yres */
  /* Window window, align; */
  /* int *xres, *yres; */


/****************************************************************
 *
 * Dialog Widget (a special kind of Form widget)
 *
 ****************************************************************/

/*
 Parameters
 ==========

 Name		Class		RepType		Default Value
 ----		-----		-------		-------------
 Window		window		window		create window
 BorderWidth	int		int		1
 Width		int		int		text width + 2*InternalWidth
 Height		int		int		font height + 2*InternalHeight
 InternalWidth	int		int		4
 InternalHeight	int		int		2
 Label		string		string		Dummy
 Foreground	color		pixel		BlackPixel
 Background     color           pixel           WhitePixel
 DialogButtons  dialogbuttons   caddr_t         NULL
 DialogValues	dialogvalues	caddr_t		NULL

*/

typedef struct _DialogButton {
    char	*name;
    int		(*funct)();
    caddr_t	param;
} DialogButton, *DialogButtons;

typedef struct _DialogValue {
    char	*tag;
    char	*string;
    int		length
} DialogValue, *DialogValues;

#endif
/* DON'T ADD STUFF AFTER THIS #endif */
