
/*
*	Set_Position:
*
*	The following functions are used to update the display of 
*       a package when it gets a request to move to a certain position.
*/

#include <structs.h>

#define OK_ON(i) ((i) >= (m)->dim_pos[i][InPoint]  &&  \
		  (i) <  (m)->dim_pos[i][OutPoint] )
static int
in_region(p,m)
  Package 	*p;
  Map		*m;
{
	int	i;
		for(i=0; i < p->ndims; ++i){
			if(!OK_ON(i)) return((int)NULL);
		 }
		return(1);
}

 
Map *
find_map(e)
  Element 	*e;
{
	Map *m = e->current ? e->current : e->maps;
	Map *l, *n;

		if(e->p->position[0] < m->dim_pos[0][InPoint]){
			for(l = m->prev; l; l = m->prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
			for(n = m->next; n; n = n->next){
				if( in_region(e->p, n)) return (Map *) n;
			 }
		 }
		else{
			for(n = m->next; n; n = n->next){
				if( in_region(e->p, n)) return (Map *) n;
			 }
			for(l = m->prev; l; l = m->prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
		 }
		if( in_region(e->p, m)) return (Map *) m;
		return (Map *) NULL;
}


update_element(e)
  Element 	*e;
{
	Map 	*m;

	if((m = find_map(e)) != NULL  &&  m != e->current){
		e->current = m;
		(*display_function[e->display_fn])(e);
	 }
}


update_package_display(p)
  Package 	*p;
{
	int 	i;

	for(e = p->elements; e; e = e->next;){
		update_element(e);
	 }
}


set_position(p,pos)
  Package  	*p;
  Position 	pos;
{
  	int	i;

	for(i=0; i<Dimensions; ++i){
		p->dimension[i]->current = pos[i];
		update_position_representations(p);
		update_package_display(p);
	 }
}


