#include <stdio.h>
#include <X10/Xlib.h>

#define SCOPE	extern
#include "XVideo.h"

#include "cvideo.h"

/*
 * Navigation chart, w/ insets
 */
#define STARTFRAME	35406
#define ROWS		10
#define COLUMNS		10
#define OFFSET		2
#define XOVERLAP	0.310
#define YOVERLAP	0.314
#define ORIENTATION	HORIZONTAL

void
main(argc, argv)
int	argc;
char	*argv[];
{
	char		*getenv();
	int		disc;
	OpaqueFrame	frame;
	Window		window;
	CVideo		*cvideo;
	XEvent		event;

	if (!XOpenDisplay(NULL)) {
		fprintf(stderr, "Cannot open display \"%s\".\n", XDisplayName(NULL));
		exit(1);
	}

	if (!XSetVideoDisplay()) {
		fprintf(stderr, "Not on a video display!\n");
		exit(2);
	}

	if (!(disc = sony_open(atoi(getenv("DISCBAUD")), getenv("DISCPORT")))) {
		fprintf(stderr, "Cannot open player!\n");
		exit(3);
	}

	frame.bdrwidth = 3;
	frame.border = frame.background = BlackPixmap;
	window = XCreateVideo("Complex Video Window", argv[0], NULL, "640x480", &frame, 16, 12);
	if (!(cvideo = InitCVideo(window, 640, 480, disc, STARTFRAME, ROWS,
	    COLUMNS, OFFSET, XOVERLAP, YOVERLAP, ORIENTATION))) {
		fprintf(stderr, "Could not init map.\n");
		exit(3);
	}

	for (;;) {
		XNextEvent(&event);
		CVideoProcess(cvideo, event);
	}
}

#if 0

/*
 * French disc; bus route map
 */
#define ORIENTATION	VERTICAL
#define STARTFRAME	51006
#define ROWS		9
#define COLUMNS		12
#define XOVERLAP	0.15
#define YOVERLAP	0.05

/*
 * Boston disc
 */
#define STARTFRAME	7322
#define ROWS		14
#define COLUMNS		9
#define XOVERLAP	0.23
#define YOVERLAP	0.23

/*
 * French disc; historic map
 */
#define ORIENTATION	VERTICAL
#define STARTFRAME	50873
#define ROWS		10
#define COLUMNS		14
#define XOVERLAP	0.15
#define YOVERLAP	0.05

/*
 * Navigation disc; North Haven
 */
#define STARTFRAME	37418
#define ROWS		5
#define COLUMNS		5
#define XOVERLAP	0.19
#define YOVERLAP	0.16

/*
 * Navigation chart, w/ rotations
 */
#define STARTFRAME	35820
#define ROWS		6
#define COLUMNS		4
#define OFFSET		37
#define XOVERLAP	0.345
#define YOVERLAP	0.335

/*
 * Very small overlap, for TV
 */
#define STARTFRAME	1
#define ROWS		10
#define COLUMNS		10
#define OFFSET		1
#define XOVERLAP	0.05
#define YOVERLAP	0.05
#define ORIENTATION	HORIZONTAL

#endif
