
#include <strings.h>

#include </mit/Xt/Xtlib.h> 



/* Private Definitions. */
typedef struct {
    Window mywin;		/* Form window. */
    int width, height;		/* Size of form window. */
    Window label;		/* Window containing description of dialog. */
    Window entry;                /* array window for entering user responses */
    char *labelstring;		/* String containing data in label. */
    char *entrystring;
  } BWidgetDataRec, *BWidgetData;

typedef struct {
    Window mywin;		/* Form window. */
    int width,height;		/* Size of form window. */
    Window label;		/* Window containing description of dialog. */
    BWidgetData form;         /* array window for entering user responses */
    int numforms;               /* How many entry windows exist */
    int numbuttons;		/* How many buttons currently in window. */
    Window *button;		/* Array of buttons. */
    char *labelstring;		/* String containing data in label. */
  } WidgetDataRec, *WidgetData;

static XtContext dialogContext = NULL;

static WidgetData DataFromWindow(window)
Window window;
{
    WidgetData result;
    if (XtFindContext(window, dialogContext, (caddr_t *)&result))
	return NULL;
    return result;
}


 static XtGeometryReturnCode DialogGeometryHandler(window, request,
						  reqBox, replBox)
Window window;
int request;
WindowBox *reqBox, *replBox;
{
    WidgetData data;
    data = DataFromWindow(window);
    if (data && request == geometryRESIZE) {
	data->width = reqBox->width;
	data->height = reqBox->height;
	XChangeWindow(window, reqBox->width, reqBox->height);
	
	return XtgeometryYes;
    }
    return XtgeometryNo;
} 
static XtEventReturnCode DialogEventHandler(event, data)
XEvent *event;
WidgetData data;
{
    if (event->type == DestroyWindow) {
	XtFree(data->labelstring);
	XtFree((char *)data->button);
	XtFree((char *)data);
	return XteventHandled;
    }
    return XteventNotHandled;
}


/* Public definitions. */

Window XtDialogCreate(parent, description, args, argCount)
Window parent;			/* Window to put the form in. */
char *description;		/* Title for this dialog box. */
ArgList args;			/* Args to pass on to form (if any). */
int argCount;
{
    WidgetData data;
    static char *textEvents[] = {
        "<Key>189:     do-nothing\n",
        NULL
    };
    static Arg arglist1[] = {
	{XtNlabel, (XtArgVal)NULL},
	{XtNborderWidth, (XtArgVal) 0}
    };
 
    if (dialogContext == NULL) dialogContext = XtUniqueContext();
    data = (WidgetData) XtMalloc(sizeof(WidgetDataRec));
    data->form = (BWidgetData) XtMalloc(sizeof(BWidgetDataRec)); 
    data->numforms = 0;
    data->form[data->numforms].mywin = NULL;
    data->numbuttons = 0;
    data->button = (Window *) XtMalloc(sizeof(Window));
    data->mywin = XtFormCreate(parent, args, argCount);
   XtSaveContext(data->mywin, dialogContext, (caddr_t) data);
    XtSetGeometryHandler(data->mywin, DialogGeometryHandler); 
    data->labelstring = XtMalloc(strlen(description) + 1);
    (void) strcpy(data->labelstring, description);
    arglist1[0].value = (XtArgVal) data->labelstring;
    data->label = XtLabelCreate(data->mywin, arglist1, XtNumber(arglist1));
    XtFormAddWidget(data->mywin, data->label, (ArgList) NULL, 0);
    XtSetEventHandler(data->mywin, DialogEventHandler,ExposeWindow, (caddr_t)data);
    return data->mywin;
}

/* default callbacks for buttons */
 
static void cancel(window)
caddr_t window;
{
	printf("Cancel Function Called\n");
	exit();
}

static void ok(window)
caddr_t window;
{
	WidgetData data;
	int counter;
	char *ValueString;
	data = DataFromWindow(window);
	for(counter = 1; counter <= data->numforms; counter++)
	{ 
	ValueString = XtDialogGetValueString(window, counter);
	printf("Value of String is %s\n", ValueString);
	}
}



void XtDialogAddButton(window, name, function, param)
Window window;
char *name;
void (*function)();
caddr_t param;
{
    WidgetData data;
    static Arg arglist1[] = {
	{XtNname, (XtArgVal) NULL},
	{XtNfunction, (XtArgVal) NULL},
	{XtNparameter, (XtArgVal) NULL}
    };
    static Arg arglist2[] = {
	{XtNfromHoriz, (XtArgVal) NULL},
	{XtNfromVert, (XtArgVal) NULL},
	{XtNleft, (XtArgVal) XtChainLeft},
	{XtNright, (XtArgVal) XtChainLeft},
	{XtNbottom, (XtArgVal) XtChainBottom}
    };
    int index;      /* indexing variable for value */
    data = DataFromWindow(window);
    if (data == NULL) return;
    if (data->numbuttons == 0)
	{
	    name = "OK" ;
	   function = ok;
	    param = (XtArgVal) data->mywin;
	}
    else if (data->numbuttons == 1)
	{
 	    name = "CANCEL";
	    function = cancel;
	    param;
	}
    arglist1[0].value = (XtArgVal) name;
    arglist1[1].value = (XtArgVal) function;
    arglist1[2].value = (XtArgVal) param;
    data->button = (Window *)
	XtRealloc((char *)data->button,
		  (unsigned) ++data->numbuttons * sizeof(Window));
    data->button[data->numbuttons - 1] =
	XtCommandCreate(window, arglist1, XtNumber(arglist1));
    if (data->numbuttons > 1)
	arglist2[0].value = (XtArgVal) data->button[data->numbuttons - 2];
    else
	arglist2[0].value = (XtArgVal) NULL;
    if (data->numforms >= 1)
	 index = (data->numforms - 1);
    else index = data->numforms;
    if (data->numforms >= 1)
	arglist2[1].value = (XtArgVal) data->form[data->numforms - 1].mywin; 
    else arglist2[1].value = (XtArgVal) data->label;
    XtFormAddWidget(data->mywin, data->button[data->numbuttons - 1],
		    arglist2, XtNumber(arglist2));
}


char *XtDialogGetValueString(window, index)
Window window;
int index;   /* index for which entryval func will return */
{
    WidgetData data;
    data = DataFromWindow(window);
    if (data) return data->form[index -1].entrystring;
    else return NULL;
}
#define formheight 26 /* heigth of form when helv10b is font of labels */
void XtDialogAddEntryWindow(window,label)
Window window;       /* window of dialog box to add entry to */
char *label;          /* label that goes beside this entry window */
{
 Window pw;          /* parent window for label and blank entry */
 WidgetData data;
 BWidgetData form;   /* struct to be used in entry form */
 char *tlabel;
 static char *textEvents[] = {
        "<Key>189:     do-nothing\n",
        NULL
    }; 
 static Arg arglistLabel[] = {
	{XtNlabel, (XtArgVal)NULL},
	{XtNborderWidth, (XtArgVal) 0},
	{XtNwidth, (XtArgVal)NULL},
	{XtNresizable, (XtArgVal)TRUE}
    };
 static Arg arglist2[] = {
	{XtNwidth, (XtArgVal)NULL}, 
	{XtNstring, (XtArgVal)NULL},
	{XtNlength, (XtArgVal)1000},
	{XtNtextOptions, (XtArgVal) (resizeWidth | resizeHeight)},
	{XtNeditType, (XtArgVal) XttextEdit}
    };
  
    static Arg arglist3[] = {
       	{XtNfromVert, (XtArgVal) NULL},
        {XtNresizable, (XtArgVal)TRUE}
    };
  static Arg arglist4[] = {
        {XtNeventBindings, (XtArgVal) NULL},
    };
  static Arg entrygeom[] = {
        {XtNfromHoriz, (XtArgVal) NULL},
     };
   int index, counter;    /* index var for data->value */
   int width, height;     /* used in label re-sizing */
   FontInfo *font = XOpenFont("helv10b"); 
   /* check to see if requested window exist */

   data = DataFromWindow(window);
   if (data == NULL) return;
   /* create form  */
  /* if(dialogContext == NULL) dialogContext = XtUniqueContext(); */
   data->form = (BWidgetData) 
     XtRealloc((char *)data->form,
	       (unsigned) ++data->numforms * sizeof(BWidgetDataRec));
   if (data->numforms >= 1) index = (data->numforms - 1);
      else index = data->numforms;
   data->form[index].mywin = XtFormCreate(data->mywin,NULL,NULL);
   XtSaveContext(data->form[index].mywin, dialogContext, (caddr_t) data); 
   XtSetGeometryHandler(data->form[index].mywin, DialogGeometryHandler); 
   tlabel = label; 

   /* this makes all labels take up same amount of space
   note: can't use Xchange on form itself  */

   for(counter = 0; counter < index; counter ++)
     {
     if (strlen(data->form[counter].labelstring) >(strlen(tlabel)))
     	tlabel = data->form[counter].labelstring;
     else 
       {
	width = XStringWidth(label,(XOpenFont("helv10b")), 0,0);
	height = font->height;
	XChangeWindow(data->form[counter].mywin,(2*width) + 16, formheight); 
      }
     }
   arglistLabel[2].value = (XtArgVal) XStringWidth(tlabel,(XOpenFont("helv10b")), 0,0);
   data->form[index].labelstring = XtMalloc(strlen(tlabel) + 1);
    (void) strcpy(data->form[index].labelstring, label);
    arglistLabel[0].value = (XtArgVal) data->form[index].labelstring; 
    data->form[index].label = XtLabelCreate(data->form[index].mywin, arglistLabel, XtNumber(arglistLabel));
    XtFormAddWidget(data->form[index].mywin, data->form[index].label, (ArgList) NULL, 0);
        /* make ** text widget ** */
        data->form[index].entrystring = XtMalloc(1010);
        (void) strcpy(data->form[index].entrystring,label);

       arglist2[0].value = (XtArgVal) data->width; 
	arglist2[1].value = (XtArgVal) data->form[index].entrystring;
        data->form[index].entry = XtTextStringCreate(data->form[index].mywin, arglist2, XtNumber(arglist2)); 
        XtTextGetValues(data->form[index].entry, arglist4, XtNumber(arglist4));
        XtMergeEventBindings(arglist4[0].value, textEvents); 
	entrygeom[0].value = (XtArgVal) data->form[index].label;
	XtFormAddWidget(data->form[index].mywin,data->form[index].entry,
			entrygeom, XtNumber(entrygeom));  


   /* add form to data with proper geometry */
   if (data->numforms > 1 ) arglist3[0].value = (XtArgVal) data->form[data->numforms - 2].mywin; 
    else arglist3[0].value = (XtArgVal) data->label; 
    XtFormAddWidget(data->mywin,data->form[index].mywin, 
		   arglist3, XtNumber(arglist3));
     }
     
     



