/*  Structs.h 			Matt Hodges   July, 1987  */
#include <sys/time.h>
#include "../cvid/cvideo.h"

typedef int  Position[MaxDims];

/*  Note the first five fields on the following map types are all the
*   same.  Don't add anything until after the Window.
*/
typedef struct _Simple{    
	  union _Map     	*prev, *next;
	  int		 	type;
	  int 		 	pos[2][MaxDims]; 
	  int 		 	selected;
	  Window	 	w;
	  int            	key_dimension;
 	  long 		 	in, out, icon;
	  char 		 	*text;
	  char           	*widget;
	  void			(*action)();
	  int			arg_type;
	  char			*arg;
	  struct _Package 	*package;       
} Simple;


typedef struct _Complex {    
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[2][MaxDims]; 
	  int 		  selected;
	  Window	  w;
	  int		  startframe, offset;
	  float		  xoverlap, yoverlap;
	  int		  rows, columns;
	  CVideo	  *cvideo;
} Complex;


typedef struct _Graphic {
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[2][MaxDims]; 
	  int 		  selected;
	  Window	  w;
	  union _Map	  *display_list;
	  int		  flags[4];
	  int		  value[4];
	  int		  (*fn[4])();
	  char		  *params[4];
	  int		  color;
	  int		  attributes;
          char            *fontname;
	  FontInfo	  *font;
	  char		  *label, *label_prm;
	  char            (*label_fn)();
	  int		  erase; 		/* ERASE or DRAW */
} Graphic;  	 


typedef union _Map {
		 	  	Simple	 simple;
	  		  	Complex	 complex; 
				Graphic	 graphic;
} Map;

typedef struct _Mapped_items {
  	   struct _Mapped_items	 *next, *prev;
	   Map		  		 *map;
}  Mapped_items;



/*   */


typedef struct _Screen{
	  int 		  type;
	  int 		  selected;
	  Window 	  w, parent;
	  int 		  x, y, width, height, borderwidth;
          int		  x_key, y_key;  /* key dimensions for virtual space*/
	  int 		  border, background;
	  Pixmap 	  border_pixmap, background_pixmap;
	  struct _Element *occupant;
	  char 		  name[Nchars], parentname[Nchars], nextname[Nchars];
	  struct _Screen  *prev, *next;
} Screen;

typedef struct _Screenlist{
          struct _Screenlist	*next, *prev;
	  Screen		*s;
	  char			*name;
}Screenlist;


typedef struct _Element{
	  int 		  type;
	  struct _Package *p;
	  Window 	  w;          
	  Screenlist	  *screen;        /* 2/23 */
	  Map  		  *map, *current;
	  Mapped_items   *mapped_widgets, *mapped_packages;
	  int 	 	  (*display_fn)();
	  int 		  active, init_active, selected;
	  char 		  *file, *display_function;
	  char            *scriptfile, *scriptname;
	  char		  *name, *screen_name, *nextname; 
	  struct _Element *prev, *next;
} Element;


typedef struct _Dim_Rep {
	struct _Package         *p;
	struct _Dimension	*d;
	Element			*e;
  	Map			*m;
	int			low, high, extent;
	int                     feature;    /* reps dim rate or position */
	int			(*update_fn)();
	struct _Dim_Rep		*prev, *next, *tmp; /* tmp chain is resolved */
	char                    *packname, *dimname;
} DimRep;


typedef struct _Dimension {
	  int 		 min, max, current, initial, range;           
	  int 		 boundary;              /* response to out of bnds */
	  int		 change;		/* enable position change */
	  int		 delta_sign;		/* +/- multiplier  */
	  int            rate, rate_setting, rate_default, rate_change;
	  int		 minrate,maxrate;
	  int            pace_step_size;
	  int		 start_point;  	/* used with timer pacing */
          struct timeval start_time;
	  void	         (*timer_fn)();
	  char	         *param;
	  int		 param_type;
	  int	         interval;
	  DimRep	 *rep;
	  char 		 name[Nchars];
 } Dimension;


typedef struct _Timer{
	  int		 min, max;
	  int            rate, rate_setting, rate_default, rate_change;
	  int            pace_step_size;
	  int		 start_point;  	/* used with timer pacing */
          struct timeval start_time;
	  void	         (*function)();
	  char	         *param;
	  int		 param_type;
	  int	         interval;
	  DimRep	 *rep;
	  char 		 name[Nchars];
	  struct _Timer  *next, *prev;
 } Timer;

  
typedef struct _Package{
	  Element 	 *element;             
	  Screen 	 *window;       
	  Dimension 	 *dimension[MaxDims];
	  Timer		 *timer;
	  Position 	 position, prev_position; 
	  int 		 ndims, ntimers;            
	  int 		 active, init_active, selected, home;
	  void		 (*on_open)(), (*on_close)();
          int            open_ptype, close_ptype;
	  char		 *open_param, *close_param;
	  char 		 name[Nchars], nextname[Nchars], screen_name[Nchars];  
	  DimRep         *reps;   /* temp storage */
	  struct _Package *prev, *next;
	  struct _Package *uprev, *unext;    /* user's chain */
} Package;
READFILE Package *first_package;


typedef struct _Packpos {
        Package		*p;		/* normally the TARGET package */
	Position	pos;
	char		*pname,*dimname;
	Element         *e;    		/* normally the CALLING element */
} Packpos;




