/*  Vdisc.h   		*/

#include "video_conf.h"
#include "rpd_driver.h"


typedef struct _Vdisc{
	int		port;
	int		operation;
	int		state;
	Element		*controlling_element;
} Vdisc;

VDISC Vdisc vdsc, *disc;  /* VDISC is currently set local in main.c */
VDISC VCONF_DEVTABLE vdt;  /* video device table  */
VDISC RPD_ptr		rpd;
VDISC int		rpd_index;

#define VDSC_STOPPED 0
#define NO_WAIT      0
#define WAIT         1

#define Vdisc_indexon			(*rpd->cmd)(rpd,INDEX_ON)
#define Vdisc_indexoff			(*rpd->cmd)(rpd,INDEX_OFF)
#define Vdisc_audio1on			(*rpd->cmd)(rpd,A1_ON)
#define Vdisc_audio1off			(*rpd->cmd)(rpd,A1_OFF)
#define Vdisc_audio2on			(*rpd->cmd)(rpd,A2_ON)
#define Vdisc_audio2off			(*rpd->cmd)(rpd,A2_OFF)
#define Vdisc_getframe			(*rpd->getframe)(rpd)
#define Vdisc_reset			(*rpd->reset)(rpd)
#define Vdisc_fveryfast			(*rpd->varspeed)(rpd,F_VERY_FAST)
#define Vdisc_ffast			(*rpd->varspeed)(rpd,F_FAST)
#define Vdisc_fplay			(*rpd->varspeed)(rpd,F_PLAY)
#define Vdisc_fslow			(*rpd->varspeed)(rpd,F_SLOW)
#define Vdisc_fveryslow			(*rpd->varspeed)(rpd,F_VERY_SLOW)
#define Vdisc_fstep			(*rpd->jog)(rpd,1)
#define Vdisc_rfast			(*rpd->varspeed)(rpd,R_VERY_FAST)
#define Vdisc_rveryfast			(*rpd->varspeed)(rpd,R_FAST)
#define Vdisc_rplay			(*rpd->varspeed)(rpd,R_PLAY)
#define Vdisc_rslow			(*rpd->varspeed)(rpd,R_SLOW)
#define Vdisc_rveryslow			(*rpd->varspeed)(rpd,R_VERY_SLOW)
#define Vdisc_rstep			(*rpd->jog)(rpd,-1)
#define Vdisc_still			(*rpd->varspeed)(rpd,STOP)
#define Vdisc_stop 			(*rpd->varspeed)(rpd,STOP)
#define Vdisc_setspeed(speed)		(*rpd->varspeed)(rpd,speed)
#define Vdisc_playseg(in,out,wait)	(*rpd->segplay)(rpd,in,out,wait)
#define Vdisc_search(f,wait)		(*rpd->search)(rpd,f,wait)
