/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "env.h"
#include "cont.h"
#include "stream.h"
#include "closure.h"

#define realloc_envm(env,newsize) \
  (env)->members = (LLEnvm *) realloc((env)->members, sizeof(LLEnvm) * \
				    ((env)->alloced_members = (newsize)))

LLEnv *tlge;
LLEnv *root;			/* Special root environment for garbage collector */
				/* (things in here are sacred) */

static LLEnvm *find_envm (env, symbol)
     LLEnv *env;
     LLSym *symbol;
{
  int n;
  LLEnvm *em;

  n = env->num_members;
  em = env->members;
  while (n--) {
    if (llsymcmp(symbol, em->name->text))
      return em;
    em++;
  }
  if (env->parent != (LLEnv *) NIL)
    return find_envm(env->parent, symbol);
  else
    return NULL;
}

LLEnv *llmake_child_env (parent)
     LLEnv *parent;
{
  LLEnv *new;

  new = (LLEnv *) llmake_obj(llenv_t);
  new->parent = parent;
  new->members = (LLEnvm *) malloc(0);
  realloc_envm(new, ENVM_CHUNK);
  new->num_members = 0;
  return new;
}

add_env (env, symbol, value)
     LLEnv *env;
     LLSym *symbol;
     LLObj *value;
{
  int n;
  LLEnvm *envm;

  n = env->num_members;
  envm = env->members;
  while (n--) {
    if (llsymcmp(symbol, envm->name->text)) {
      envm->value = value;
      return;
    }
    envm++;
  }

  if (env->num_members == env->alloced_members) 
    realloc_envm(env, env->alloced_members + ENVM_CHUNK);
  envm = env->members + env->num_members++;
  envm->name = symbol;
  envm->value = value;
}

set_env (env, symbol, value)
     LLEnv *env;
     LLSym *symbol;
     LLObj *value;
{
  LLEnvm *envm;

  if (envm = find_envm(env, symbol)) 
    envm->value = value;
  else
    add_env(env, symbol, value);
}

/* Scheme procedure. 
   Get symbol and optional environemtn 
   from the stack, and returns value onto the stack 
*/
LLObj *llget_env()
{
  LLEnv *env;
  LLSym *symbol; 
  LLObj *retval; 

  symbol = (LLSym *) llnextarg(); 
  if(llmoreargs()) {
    env = (LLEnv *) llnextarg();
  } else {
    env = tlge;
  }
  if (lltypecheck(symbol, llsym_t) && lltypecheck(env, llenv_t)) {
    retval = get_env(env,symbol);
    llpusharg(retval);
    return(retval);
  } else {
    llpusharg(NIL);
    return NIL;
  }
}

LLObj *get_env(env, symbol)
     LLEnv *env;
     LLSym *symbol;
{
  LLEnvm *em;
  
  if (em = find_envm(env, symbol))
    return em->value;
  else
    llperror(LLUNBOUND_SYMBOL, symbol->text);
}

void touch_env(env)
     LLEnv *env;
{
  LLEnvm *member;
  int n;
  
  n = env->num_members;
  member = env->members;
  while (n--) {
    lltouch_obj(member->name);
    lltouch_obj(member->value);
    member++;
  }
  lltouch_obj(env->parent);
}

void free_env(env)
     LLEnv *env;
{
  free(env->members);
}  

void llprocedure_environment()
{
  LLClosure *closure;
  closure = (LLClosure *)llnextcheckedarg(llclosure_t);
  lllastarg();
  llpusharg(closure->env);
}

void llenvironment_parent()
{
  LLEnv *env;
  env = (LLEnv *)llnextcheckedarg(llenv_t);
  lllastarg();
  llpusharg(env->parent);
}

void llenvironment_bindings()
{
  int i;
  LLEnv *env; 
  env = (LLEnv *)llnextcheckedarg(llenv_t); 
  lllastarg();
  i = env->num_members;
  while(i--) {
    llpusharg((LLObj *)llcmake_cons(env->members[i].name, env->members[i].value)); 
  }
  llargc = env->num_members;
  lllist();
}
void llinit_env()
{
  llenv_t = lladd_obj_td (sizeof(LLEnv), "Environment",
		      free_env, touch_env, 0, 0);
  /* Build the Limey global environment (TLGE) */
  tlge = llmake_child_env((LLEnv *)NIL);	/* No parent! */
  set_env(tlge, llcstring_to_sym("nil"), NIL);
  set_env(tlge, llcstring_to_sym("t"), T);
  root = llmake_child_env((LLEnv *)NIL);	/* Also no parent! */
  set_env(root, llcstring_to_sym("tlge"), (LLObj *)tlge);
				/* Put these here in case some wise guy 
				   redefines the ones in tlge -- we don't
				   want NIL to get garbage collected!!! */
  set_env(root, llcstring_to_sym("nil"), NIL);
  set_env(root, llcstring_to_sym("t"), T);
  llregister_cfunc(llprocedure_environment, "procedure-environment");
  llregister_cfunc(llenvironment_parent, "environment_parent");
  llregister_cfunc(llenvironment_bindings, "environment_bindings");
}

