/*
 * cstacka.c - An area which displays a cstack.
 */

#include <stdlib.h>

#include "fc.h"
#include "area.h"
#include "err.h"

#include "card.h"
#include "cpile.h"
#include "cpilea.h"

/* ---------- Method declarations ---------- */
void cpilea_term(struct area *);
int cpilea_mouse(struct area *, XButtonEvent *);
int cpilea_draw(struct area *, Region);
int cpilea_resize(struct area *, XConfigureEvent *);
int cpilea_key(struct area *, XKeyEvent *);
int cpilea_activate(struct area *, XMapEvent *);
int cpilea_deactivate(struct area *, XUnmapEvent *);

/* ---------- Ops structure ---------- */
struct area_ops cpilea_ops = {
     cpilea_term,
     cpilea_mouse,
     cpilea_draw,
     cpilea_resize,
     cpilea_key,
     cpilea_activate,
     cpilea_deactivate
};

/* ---------------------------------------------------------------------- */
struct area *
cpilea_create(struct cpile *clp, struct aop *aop)
{
     struct area *ret;
     struct cpilea_data *cldp;

     aop->aops = &cpilea_ops;

     ret = area_create(aop, sizeof(struct cpilea_data));
     if (!ret) return ret;
     
     cldp = ret->data;
     cldp->clp = clp;

     cpile_setarea(clp, ret);

     return ret;
}

/* ---------------------------------------------------------------------- */
void cpilea_term(struct area *ap)
{
     struct cpilea_data *cldp = ap->data;

     if (cldp->clp) cpile_destroy(cldp->clp);
}

/* ---------------------------------------------------------------------- */
int cpilea_mouse(struct area *ap, XButtonEvent *xevp)
{
     /* Ignore button up events for now. */
     if (xevp->type == ButtonRelease) return(0);

     return(0);
}

/* ---------------------------------------------------------------------- */
int cpilea_draw(struct area *ap, Region rgn)
{
     struct cpilea_data *cldp = ap->data;
     
     if (cldp->clp) {
	  cpile_draw(cldp->clp, ap->owner, 
		     area_getx(ap), area_gety(ap)); 
     }

     return(0);
}

/* ---------------------------------------------------------------------- */
int cpilea_resize(struct area *ap, XConfigureEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cpilea_key(struct area *ap, XKeyEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cpilea_activate(struct area *ap, XMapEvent *xevp)
{
     return(0);
}

/* ---------------------------------------------------------------------- */
int cpilea_deactivate(struct area *ap, XUnmapEvent *xevp)
{
     return(0);
}

