
/*****************************************************************************
 *
 * Main 
 *
 *****************************************************************************
 * FileName:        main.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This is a sample entry point for the DeviceNet Stack. Initialization and
 * message handling is demonstrated here.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/




#include	"dnet.def"				// Global definitions file
#include	"typedefs.h"
#include	"GoDNet.h"				// DeviceNet Functions
#include	"timer.h"				// Timer Functions

#include	"app.h"					// Demonstration loopback application





void main(void)
{
	// Initialize the timer
	TimerInit();
		
	// Init all appropriate DeviceNet parameters
	GoDNetInitializeAll();
	
	while (1)
	{
		// Process all DeviceNet Messaging events
		GoDNetProcessAllMsgEvents();

		// Process all DeviceNet timer events
		if (TimerIsOverflowEvent()) GoDNetProcessAllTickEvents();
		
		// Process my application object for any I/O
		AppClass1Process();
	}
}


