/*****************************************************************************
 *
 * Microchip DeviceNet Stack (User level DeviceNet Object events)
 *
 *****************************************************************************
 * FileName:        UsrConn.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains events generated from the DeviceNet Object that cannot
 * be handled internally.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/17/03	...	
 * 
 *****************************************************************************/


#include	"dnet.def"			// Global definitions file
#include 	"typedefs.h"

#include	"dnet.h"
#include	"route.h"



/*********************************************************************
 * Function:        void UsrDNetInitEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when the DeviceNet Object is 
 *					initialized. 
 *
 * Note:            The application programmer should utilize this event
 *					to initialize attributes for the application that 
 *					are defined within the DeviceNet Object, 5-5 in 
 *					the specification.
 ********************************************************************/
void UsrDNetInitEvent(void)
{
	mDNetSetMACID(04);					// Get the MAC from the app
	mDNetSetBaudRate(0);				// Get the baud from the app
	mDNetSetBOI(0);						// Get the BOI from the app
	mDNetSetMACSwChange(0);				// Get the sw change from the app
	mDNetSetBaudSwChange(0);			// Get the sw change from the app
	mDNetSetMACSwValue(0);				// Get the sw value from the app
	mDNetSetBaudSwValue(0);				// Get the sw value from the app
}



/*********************************************************************
 * Function:        void UsrDNetSetAttribEvent(void)
 *
 * PreCondition:    N/A
 *
 * Input:       	none
 *                  
 * Output:         	none
 *
 * Side Effects:    N/A
 *
 * Overview:        This event occures when a Set Attribute request has 
 *					been made to the DeviceNet Object that cannot be 
 *					handled internally because of an application specific
 *					dependency. 
 *
 * Note:            
 ********************************************************************/
void UsrDNetSetAttribEvent(void)
{
	switch (mRouteGetAttributeID())
	{
		case DNET_ATTRIB_MAC_ID:
			// Setting of the MAC must be handled by the application 
			// designer because the specifications identify hardware 
			// dependencies. Refer to 5-5.3.1 of the spec.
			break;
			
		case DNET_ATTRIB_BAUD_RATE:
			// Setting of the baud rate must be handled by the application 
			// designer because the specifications identify hardware 
			// dependencies. Refer to 5-5.3.1 of the spec.
			break;
			
		case DNET_ATTRIB_BOI:
			// Setting of the BOI must be handled by the application 
			// designer because the specifications identify application 
			// specific dependencies. Refer to 5-5.3.1 of the spec.
			break;
	}
}
























