/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Error Definitions)
 *
 *****************************************************************************
 * FileName:        error.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains DeviceNet Error Definitions.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/


#ifndef	__ERRORS__
#define __ERRORS__




#define	ERR_SUCCESS					0x00

#define	ERR_RESOURCE_UNAVAILABLE	0x02

#define	ERR_PATH_SEGMENT_ERROR		0x04
#define	ERR_PATH_DEST_UNKNOWN		0x05

#define	ERR_CONN_LOST				0x07
#define	ERR_SERVICE_NOT_SUPPORTED	0x08
#define	ERR_INVALID_ATTRIB_VALUE	0x09
#define	ERR_ATTRIB_LIST_ERROR		0x0A
#define	ERR_ALREADY_IN_MODE			0x0B
#define	ERR_OBJECT_STATE_CONFLICT	0x0C
#define	ERR_OBJECT_ALREADY_EXISTS	0x0D
#define	ERR_ATTRIB_NOT_SETTABLE		0x0E
#define	ERR_PRIVILEGE_VIOLATION		0x0F
#define	ERR_DEVICE_STATE_CONFLICT	0x10
#define	ERR_REPLY_TOO_LARGE			0x11

#define	ERR_NOT_ENOUGH_DATA			0x13
#define	ERR_ATTRIB_NOT_SUPPORTED	0x14
#define	ERR_TOO_MUCH_DATA			0x15
#define	ERR_OBJECT_DOES_NOT_EXIST	0x16

#define	ERR_NO_STORED_ATTRIB_DATA	0x18
#define	ERR_STORE_OPERATION_FAIL	0x19

#define	ERR_MISSING_ATTRIB_LIST		0x1C
#define	ERR_INVALID_ATTRIB_LIST		0x1D

#define	ERR_VENDOR_SPECIFIC_ERROR	0x1F
#define	ERR_INVALID_PARAM			0x20

#define	ERR_UNEXPECTED_ATTRIB		0x27
#define	ERR_INVALID_MEMBER_ID		0x28
#define	ERR_MEMBER_NOT_SETTABLE		0x29
#define	ERR_GROUP2_FAILURE			0x2A







#endif	//__ERRORS__
