
/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Identity Object Source)
 *
 *****************************************************************************
 * FileName:        ident.c
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.20.00 or higher
 * Linker:          MPLINK 03.40.00 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * This file contains Identity Object support.
 * Refer to Chapter 6 of Volume 2 for information about this object.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/03/03	...	
 * 
 *****************************************************************************/

#include	"dnet.def"			// Global definitions file
#include 	"typedefs.h"

#include	"ident.h"			// Internal prototypes
#include	"usrident.h"		// External prototypes

#include	"services.h"		// Service codes
#include	"errors.h"			// Error codes
#include	"class.h"			// Class codes
		
#include	"route.h"	 		// Global symbols defined by the router		


/*********************************************************************
 * Identity internal definitions
 ********************************************************************/
#define		_IDENTITY_REVISION	0x01



/*********************************************************************
 * DeviceNet global parameters
 ********************************************************************/
DNET_ID uIdentity; 
		
		

/*********************************************************************
 * Function:        unsigned char _IdentityExplMsgHandler(void)
 *
 * PreCondition:    
 *
 * Input:           
 *					
 *                  
 * Output:         
 *
 * Side Effects:    
 *
 * Overview:        Handler for explicit messaging 
 *
 * Note:            None
 ********************************************************************/
unsigned char _IdentityExplMsgHandler(void)
{
	switch (mRouteGetInstanceID())
	{
		case 0:
			switch(mRouteGetServiceID())
			{
				case SRVS_GET_ATTRIB_SINGLE:
					return(_IdentityInst0GetAttrib());
					
				default:
					mRoutePutError(ERR_SERVICE_NOT_SUPPORTED);
					break;
			}
			break;

		case 1:
			switch(mRouteGetServiceID())
			{
				case SRVS_GET_ATTRIB_SINGLE:
					return(_IdentityInst1GetAttrib());
							
				case SRVS_RESET:
					UsrIdentityReset();
					return(1);
					break;

				default:
					mRoutePutError(ERR_SERVICE_NOT_SUPPORTED);
					break;
			}
			break;

		default:
			mRoutePutError(ERR_OBJECT_DOES_NOT_EXIST);
			break;
	}
   
	return (1);
}








/*********************************************************************
 * Function:        unsigned char IdentityInst0GetAttrib(void)
 
 *					unsigned char DNetGetAttrib(Instance, Attribute, *length)
 *
 * PreCondition:    
 *
 * Input:           gInstance - contains the requested instance.
 *					gAttribute - contains the attribute number.
 *                  
 * Output:          gResponse - contains the response or error code
 *					and any bytes following gResponse may also contain
 *					data.
 *					Returns 1 for success or 0 for error.
 *
 * Side Effects:    Overwrites gInstance, gAttribute, gResponse, and more
 *
 * Overview:        Gets an attribute within this object (DeviceNet Object) 
 *
 * Note:            None
 ********************************************************************/
unsigned char _IdentityInst0GetAttrib(void)
{
	switch (mRouteGetAttributeID())
   	{
		case 1:
			mRoutePutByte(_IDENTITY_REVISION & 0xFF);
			mRoutePutByte((_IDENTITY_REVISION & 0xFF00) >> 8);
   			break;
   
   		default:
   			mRoutePutError(ERR_ATTRIB_NOT_SUPPORTED);
   			break;
   	}

	return (1);
}


/*********************************************************************
 * Function:        unsigned char IdentityInst1GetAttrib(void)
 
 *					unsigned char DNetGetAttrib(Instance, Attribute, *length)
 *
 * PreCondition:    
 *
 * Input:           gInstance - contains the requested instance.
 *					gAttribute - contains the attribute number.
 *                  
 * Output:          gResponse - contains the response or error code
 *					and any bytes following gResponse may also contain
 *					data.
 *					Returns 1 for success or 0 for error.
 *
 * Side Effects:    Overwrites gInstance, gAttribute, gResponse, and more
 *
 * Overview:        Gets an attribute within this object (DeviceNet Object) 
 *
 * Note:            None
 ********************************************************************/
unsigned char _IdentityInst1GetAttrib(void)
{
	unsigned char i;

	switch (mRouteGetAttributeID())
	{
		case 1:
			mRoutePutByte(uIdentity.vendorID.bytes.L);
			mRoutePutByte(uIdentity.vendorID.bytes.H);
			break;
			
		case 2:
			mRoutePutByte(uIdentity.deviceType.bytes.L);
			mRoutePutByte(uIdentity.deviceType.bytes.H);
			break;
			
		case 3:
			mRoutePutByte(uIdentity.productCode.bytes.L);
			mRoutePutByte(uIdentity.productCode.bytes.H);
			break;
			
		case 4:
			mRoutePutByte(uIdentity.revision.major);
			mRoutePutByte(uIdentity.revision.minor);
			break;
			
		case 5:
			mRoutePutByte(uIdentity.status.bits.lbyte.L);
			mRoutePutByte(uIdentity.status.bits.lbyte.L);
			break;
			
		case 6:
			mRoutePutByte(uIdentity.serial.bytes.L);
			mRoutePutByte(uIdentity.serial.bytes.H);
			mRoutePutByte(uIdentity.serial.bytes.UL);
			mRoutePutByte(uIdentity.serial.bytes.UH);
			break;
			
		case 7:
			if (mRouteOutLen() > uIdentity.name.len)  
			{
				for (i = 0; i < (uIdentity.name.len); i++)
				{
					mRoutePutByte(uIdentity.name.p[i]);
				}
			}
			else
			{
				mRoutePutError(ERR_REPLY_TOO_LARGE);
			}
			return (1);
		   			
		default:
			mRoutePutError(ERR_ATTRIB_NOT_SUPPORTED);
			break;
	}
	
   	return (1);	
}


