
/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Data types)
 *
 *****************************************************************************
 * FileName:        typedefs.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/



typedef enum _BOOL { FALSE = 0, TRUE } BOOL;		// Boolean
typedef signed char 			SINT;				// Signed 8-bit number
typedef	signed short int		INT;				// Signed 16-bit number
typedef signed long				DINT;				// Signed 32-bit number
typedef	unsigned char			USINT;				// Unsigned 8-bit number
typedef unsigned long			UDINT;				// Unsigned 32-bit number
typedef float					REAL;				// 32-bit floating point
typedef double					LREAL;				// 32-bit floating point

typedef INT						ITIME;				// Signed 16-bit time in milliseconds
typedef DINT					TIME;				// Signed 32-bit time in milliseconds
typedef DINT					FTIME;				// Signed 32-bit time in microseconds


typedef union _UINT									// Unsigned 16-bit number
{
	unsigned short int word;
	struct _BYTES
	{
		unsigned char LSB;
		unsigned char MSB;
	}bytes;
}UINT;


typedef union	_BYTE								// Array of 8 bits
{
	unsigned char byte;	
	struct _BITS
	{
		unsigned b0:1;
		unsigned b1:1;
		unsigned b2:1;
		unsigned b3:1;
		unsigned b4:1;
		unsigned b5:1;
		unsigned b6:1;
		unsigned b7:1;
	}bits;
}BYTE;

typedef union _WORD									// Array of 16 bits
{
	unsigned short int W;
	struct _BIT
	{
		union _BITS_L
		{
			unsigned char L;
			struct _BITS_L_
			{
				unsigned b0:1;
				unsigned b1:1;
				unsigned b2:1;
				unsigned b3:1;
				unsigned b4:1;
				unsigned b5:1;
				unsigned b6:1;
				unsigned b7:1;
			}bit;
		}lbyte;	

		union _BITS_H
		{
			unsigned char H;
			struct _BITS_H_
			{
				unsigned b8:1;
				unsigned b9:1;
				unsigned bA:1;
				unsigned bB:1;
				unsigned bC:1;
				unsigned bD:1;
				unsigned bE:1;
				unsigned bF:1;
			}bit;
		}hbyte;
	}bits;
}WORD;

typedef union S_EPATH
{
	unsigned char * path;
}EPATH;





	
#define	TRUE	1
#define	FALSE	0

#define	NULL	0


#if USE_ACCESS == TRUE	
	#define	NEAR	near
#else 
	#define	NEAR
#endif


#define	ROM		rom
//#define	ROM
