#ifndef __TEXTURE_H__
#define __TEXTURE_H__

struct TexCoord
{
	double u,v;
	TexCoord(double U, double V){u=U; v=V;}
	TexCoord(){u=v=0;}
};

struct TextureMapping
{
	virtual TexCoord GetCoords(const Vector3D<> & Point, const Vector3D<> & Normal) =0;
	virtual void Load(const XMLNode * n)=0;
};

struct PlanarMapping : public TextureMapping
{
	enum Axis
	{
		AxisX=0,
		AxisY,
		AxisZ
	};

	Axis MappedAxis;
	Vector3D<> Center;

	PlanarMapping(Axis a, const Vector3D<> c)
	{
		MappedAxis = a;
		Center = c;
	}

	PlanarMapping() : MappedAxis(AxisX) {}
	virtual ~PlanarMapping() {}

	virtual TexCoord GetCoords(const Vector3D<> & Point, const Vector3D<> & Normal);
	virtual void Load(const XMLNode * n);
};

struct Texture
{
	virtual Color4 ColorAt(const TexCoord Coord) =0;
	virtual void Load(const XMLNode * n)=0;
};

struct CheckerboardTexture : public Texture
{
	TexCoord Center;
	double uWidth, vWidth;
    Color4 Color1, Color2;

	CheckerboardTexture();

	virtual void Load(const XMLNode * n);
    virtual Color4 ColorAt(const TexCoord Coord);
};

#endif
