on posix_path(mac_path)
	set mac_path to (mac_path as text)
	set root to (offset of ":" in mac_path)
	set rootdisk to (characters 1 thru (root - 1) of mac_path)
	tell application "Finder"
		if (rootdisk as string is equal to the name of the startup disk) then
			set unixpath to "/" & (characters (root + 1) thru end of mac_path)
		else
			set unixpath to "/Volumes/" & mac_path
		end if
	end tell
	set chars to every character of unixpath
	repeat with i from 2 to length of chars
		if item i of chars as text is equal to "/" then
			set item i of chars to ":"
		else if item i of chars as text is equal to ":" then
			set item i of chars to "/"
		else if item i of chars as text is equal to "'" then
			set item i of chars to "'\"'\"'"
		end if
	end repeat
	return every item of chars as string
end posix_path

on sanitize(str)
	set chars to every character of str
	repeat with i from 1 to length of chars
		if item i of chars as text is equal to "/" then
			set item i of chars to ":"
		else if item i of chars as text is equal to "'" then
			set item i of chars to "'\"'\"'"
		end if
	end repeat
	return every item of chars as string
end sanitize

on run
	with timeout of (30 * 60) seconds
		set lst to {}
		tell application "iTunes"
			set ns to the name of every user playlist
		end tell
		set ps to choose from list ns with prompt "Choose playlists to serve with MixApp:" with multiple selections allowed
		if ps is false then
			return
		end if
		tell application "Finder"
			set current to the name of every item of folder "Music:MixApp" of home
		end tell
		set obsolete to {}
		repeat with c in current
			if c is not in ps then set obsolete's end to c
		end repeat
		if the length of obsolete is greater than 0 then
			set keep to choose from list obsolete with prompt "You have some playlists you were serving you did not select.  Select any of them that you want to keep (but leave as they are)." with multiple selections allowed and empty selection allowed
			if keep is false then
				return
			end if
		else
			set keep to {}
		end if
		set toremove to {}
		repeat with p in ps -- do this, because setting toremove to ps sets by reference
			set toremove's end to p
		end repeat
		repeat with o in obsolete
			if o is not in keep then set toremove's end to o
		end repeat
		tell application "iTunes"
			repeat with p in ps
				set pl to the user playlist p
				set plnam to my sanitize(the name of pl)
				repeat with s in every file track of pl
					if s is enabled then
						set l to the location of s
						set l to my posix_path(l)
						set nam to my sanitize(the name of s)
						set alb to my sanitize(the album of s)
						set art to my sanitize(the artist of s)
						if (l as text) ends with ".mp3" then
							set lst's end to {l, nam, alb, art, plnam}
						end if
					end if
				end repeat
			end repeat
		end tell
		
		do shell script "mkdir -p ~/Music/MixApp"
		repeat with tr in toremove
			do shell script "rm -Rf ~/'Music/MixApp/" & sanitize(tr) & "/'"
		end repeat
		
		set i to 1
		repeat with tuple in lst
			set pat to the first item of tuple
			set nam to the second item of tuple
			set alb to the third item of tuple
			set art to the fourth item of tuple
			set plnam to the fifth item of tuple
			do shell script "mkdir -p ~/'Music/MixApp/" & plnam & "/" & art & "/" & alb & "/'"
			do shell script "ln -s '" & pat & "' ~/'Music/MixApp/" & plnam & "/" & art & "/" & alb & "/" & (i as string) & "_" & nam & ".mp3'"
			set i to i + 1
		end repeat
		display dialog "Success!  Song links are in ~/Music/MixApp." buttons "Pianojuice!" default button 1
	end timeout
end run