
#include <pthread.h>

struct link_list_element {
	semaphore				lock;
	struct link_list_element  *	up;
	struct link_list_element  *	down;
	struct link_list		  * link_list;
	char 						data[0];
}

struct link_list {
	/* PRIVATE */
	semaphore				lock;
	enum link_list_type			type;
	struct link_list_element * 	top;
	struct link_list_element * 	bottom;
}

typedef link_list_element_t struct link_list_element *;
typedef link_list_attr_t 	void *;
typedef link_list_t			struct link_list *;

void * 		list_element_alloc(size_t);	
int			list_element_free(void *);

int 		link_list_alloc(link_list_t *);		
int 		link_list_free(link_list_t *);				

int			link_list_insert_top(link_list *, void *);
int			link_list_insert_next(link_list *, void *, void *);
#define link_list_insert_bottom(list, elem)	link_list_insert(list, elem, NULL);

void *		link_list_remove_top(link_list_t *);
void *		link_list_remove_next(link_list_t *, void *);
#define	link_list_remove_bottom(list)	link_list_remove(list, NULL)
	
void *		link_list_lock_top(struct link_list_t *);
void *		link_list_lock_bottom(struct link_list_t *);
void *		link_list_lock(struct link_list_t *, void *);

void *		link_list_lock_up(void *, int);
void *		link_list_lock_down(void *, int);
void		link_list_unlock(void *);

