/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *	  notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *	  notice, this list of conditions and the following disclaimer in the
 *	  documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *	  must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.	IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)getproto.c	5.6 (Berkeley) 6/1/90";*/
static char *rcsid = "$Id: getproto.c,v 1.3 1995/01/06 10:46:11 ghudson Exp $";
#endif /* LIBC_SCCS and not lint */

#include <stdio.h>
#include <netdb.h>
#include "proto_internal.h"

/* Old interface: search using thread-specific file and return pointer to
 * thread-specific data. */
struct protoent *getprotobynumber(int proto)
{
	struct proto_data *data = _proto_init();
	struct protoent *r;

	if (!data)
		return NULL;
	r = getprotobynumber_r_file(proto, &data->proto_answer, &data->protofp);
	if (!data->keep_protofp_open)
		endnetent_r(&data->protofp);
	return r;
}

/* Thread-safe interface, using internal file (closed at end). */
struct protoent *getprotobynumber_r(int proto,
									struct protoent_answer *result)
{
	FILE *fp = NULL;
	struct protoent *r;

	r = getprotobynumber_r_file(proto, result, &fp);
	endprotoent_r(&fp);
	return r;
}

/* Thread-safe interface with provided file, which remains open. */
struct protoent *getprotobynumber_r_file(int proto,
										 struct protoent_answer *result,
										 FILE **fp)
{
	struct protoent *p;

	setprotoent_r(fp);
	while (p = getprotoent_r(result, fp)) {
		if (p->p_proto == proto)
			return p;
	}
	return NULL;
}

