#ifdef IMPLEMENTATION_mit
#define PTHREAD_KERNEL
#endif /* IMPLEMENTATION_mit */
#include <pthread.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include "sock_lib.h"

#define MAX_INNER_LOOPS	1

void
puke()
{
  printf("dying a horrible death...\n");
  abort();
}

#ifdef IMPLEMENTATION_mit
char *
fd_type_string(enum fd_type type)
{
  char *result;

  switch (type) {
  case FD_NT:			/* Not tested */
    result = "NT"; break;
  case FD_NIU:		/* Known to be not in use */
    result = "NIU"; break;
  case FD_HALF_DUPLEX:	/* Files, and seeking devices */
    result = "HDX"; break;
  case FD_FULL_DUPLEX:	/* pipes, sockets, drivers, ... */
    result = "FDX"; break;
  case FD_TEST_HALF_DUPLEX:	/* Redo machdep_sys_fcntl */
    result = "THDX"; break;
  case FD_TEST_FULL_DUPLEX:	/* Redo machdep_sys_fcntl */
    result = "TFDX"; break;
  default:
    result = "????";
    break;
  }
  return result;
}

void
dump_file_table(int dump_all)
{
  extern struct fd_table_entry **fd_table;
  extern int dtablesize;
  int i;
  char *fd_type_string();

  printf("f# r_owner  w_owner  -next->  type rl wl ct fd flags    osflags\n");
  printf("-- -------- -------- -------- ---- -- -- -- -- -------- --------\n");
  for (i = 0; i < dtablesize; i++)
    if (fd_table[i] &&
	(dump_all ||
	 ((fd_table[i]->fd.i >= 0) || (fd_table[i]->type != FD_NT))))
      printf("%02d %08lx %08lx %08lx %-4s %02d %02d %02d %02d %08x %08x\n",
	     i, fd_table[i]->r_owner, fd_table[i]->w_owner,
	     fd_table[i]->next,
	     fd_type_string(fd_table[i]->type),
	     fd_table[i]->r_lockcount,
	     fd_table[i]->w_lockcount,
	     fd_table[i]->count,
	     fd_table[i]->fd.i,
	     fd_table[i]->flags,
	     ((fd_table[i]->fd.i>=0)?
	      machdep_sys_fcntl(fd_table[i]->fd.i, F_GETFL, 0): 0));
  printf("-----------------------------------------------------------------\n");
}
#endif /* IMPLEMENTATION_mit */

main(int argc, char **argv)
{
  int count = 0, test_count;
  char host_name[512];

  setbuf(stdout, NULL);
  test_count = 100;
  if (argc == 1) {
    if (gethostname(host_name, sizeof(host_name)) < 0) {
      perror("gethostname");
      puke();
    }
  } else {
    strcpy(host_name, argv[1]);
  }
  printf("will use echo service on host %s\n", host_name);
  while (test_count-- >= 0) {
    FILE *rfp, *wfp;
    int c, s, dup_s, inner_loop;

    printf("*** start %d ***\n", ++count);
    s = socket_to_service(host_name, "echo", "tcp");
    if (s < 0) {
      printf("socket_to_service => %d\n", s);
      puke();
    }
    rfp = fdopen(s, "r");
    if (!rfp) {
      printf("fdopen(rfp) died\n");
      puke();
    }
    dup_s = dup(s);
    if (dup_s < 0) {
      printf("dup(%d) failed\n", s);
      puke();
    }
    wfp = fdopen(dup_s, "w");
    if (!wfp) {
      printf("fdopen(wfp) died\n");
      puke();
    }
    for (inner_loop = 0; inner_loop < MAX_INNER_LOOPS; inner_loop++) {
      fprintf(wfp, "ugga bugga boo!\n");
      fflush(wfp);
      while ((c = getc(rfp)) != EOF) {
	putchar(c);
	if (c == '\n') break;
      }
    }
    fclose(rfp);
    fclose(wfp);
    printf("*** end %d ***\n\n", count);
  }
  exit(0);
}
