;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; $Header: /deneb/src0/johani/scix-0.96/src/RCS/replies.sc,v 1.3 90/04/01 13:51:10 johani Exp $

;;; SCIX Reply formats.

;;; type-or-zero -- Used only in ListFontsWithInfo (qv).
(define (type-or-zero func)
  (lambda (str dpy)
    (if (zero? (backtrack 'length-of-name))
	0
	(func str dpy) )))

;;; backtrack -- Used for getting a previously parsed value. Needed since
;;;              make-reply can't bind the symbols. See make-reply for an
;;;              explanation of *current-reply*.
(define (backtrack sym)
  (cdr (assq sym *current-reply*)) )

(define *reply-formats*
  `(
;;; utilities needed for initial connection reply.
    (format . ((depth ,d-card8)
	       (bits-per-pixel ,d-card8)
	       (scanline-pad ,d-card8)
	       (unused ,(gobble! 5)) ))
    (screen . ((root ,(d-object d-window))
	       (default-colormap ,(d-object d-colormap))
	       (white-pixel ,d-card32)
	       (black-pixel ,d-card32)
	       (current-input-masks ,(d-object d-setofevent))
	       (width-in-pixels ,d-card16)
	       (height-in-pixels ,d-card16)
	       (width-in-mm ,d-card16)
	       (height-in-mm ,d-card16)
	       (min-installed-maps ,d-card16)
	       (max-installed-maps ,d-card16)
	       (root-visual ,d-visualid)
	       (backing-stores ,(d-const #t d-card8 '((0 . Never)
						      (1 . WhenMapped)
						      (2 . Always) )))
	       (save-unders ,d-bool)
	       (root-depth ,d-card8)
	       (nr-of-depths ,d-card8)
	       (allowed-depths ,(lambda (str dpy)
				  ((d-list (lambda (str dpy)
					     (make-reply 'depth str dpy))
					   (backtrack 'nr-of-depths))
				   str dpy)))))
    (depth . ((depth ,d-card8)
	      (unused ,d-card8)
	      (nr-of-visualtypes ,d-card16)
	      (unused ,(gobble! 4))
	      (visuals ,(lambda (str dpy)
			  ((d-list (lambda (str dpy)
				    (make-reply 'visualtype str dpy))
				  (backtrack 'nr-of-visualtypes) )
			  str dpy)))))
    (visualtype . ((id ,d-visualid)	; [johani] Changed 'visual-id to 'id
		                        ; to conform with other objects.
		   (class ,(d-const #t d-card8 '((0 . StaticGray)
						 (1 . GrayScale)
						 (2 . StaticColor)
						 (3 . PseudoColor)
						 (4 . TrueColor)
						 (5 . DirectColor) )))
		   (bits-per-rgb-value ,d-card8)
		   (colormap-entries ,d-card16)
		   (red-mask ,d-card32)
		   (green-mask ,d-card32)
		   (blue-mask ,d-card32)
		   (unused ,(gobble! 4)) ))

;;; Initial reply: connection accepted
    (connectaccept . ((unused ,(gobble! 1))
		      (prot-major ,d-card16)
		      (prot-minor ,d-card16)
		      (add-data-len ,d-card16)
		      (release-number ,d-card32)
		      (resource-id-base ,d-card32)
		      (resource-id-mask ,d-card32)
		      (motion-buffer-size ,d-card32)
		      (vendor-len ,d-card16)
		      (max-request-len ,d-card16)
		      (nr-of-screens ,d-card8)
		      (nr-of-pixmap-formats ,d-card8)
		      (image-byte-order ,(d-const #t d-card8
						 '((0 . LSBFirst)
						   (1 . MSBFirst) )))
		      (bitmap-format-bit-order
		       ,(d-const #t
				d-card8
				'((0 . LeastSignificant)
				  (1 . MostSignificant) )))
		      (bitmap-format-scanline-unit ,d-card8)
		      (bitmap-format-scanline-pad ,d-card8)
		      (min-keycode ,d-keycode)
		      (max-keycode ,d-keycode)
		      (unused ,(gobble! 4))
		      (vendor ,(lambda (str dpy)
				(d-string8 (backtrack 'vendor-len) str dpy) ))
		      (pixmap-formats ,(lambda (str dpy)
					 ((d-list (lambda (str dpy)
						    (make-reply 'format
								str dpy))
						  (backtrack
						   'nr-of-pixmap-formats))
					  str dpy)))
		      (roots ,(lambda (str dpy)
				((d-list (lambda (str dpy)
					   (make-reply 'screen str dpy))
					 (backtrack 'nr-of-screens))
				 str dpy)))))

;;; Initial reply: connection refused
    (connectrefuse . ((reason-len ,d-card8)
		      (prot-major ,d-card16)
		      (prot-minor ,d-card16)
		      (add-data-len ,d-card16)
		      (reason ,(lambda (str dpy)
				(d-string8 (backtrack 'reason-len)
					   str
					   dpy) ))))

;;; Reply to request #3: GetWindowAttributes
    (getwindowattributes . ((reply ,(identity 'GetWindowAttributes))
			    (backing-store ,(d-const #t
						    d-card8
						    '((0 . NotUseful)
						      (1 . WhenMapped)
						      (2 . Always) )))
			    (seq-nr ,d-card16)
			    (unused ,(gobble! 4)) ; Reply length = 3
			    (visual ,d-visualid)
			    (class ,(d-const #t
					    d-card16
					    '((1 . InputOutput)
					      (2 . InputOnly) )))
			    (bit-gravity ,d-bitgravity)
			    (win-gravity ,d-wingravity)
			    (backing-planes ,d-card32)
			    (backing-pixel ,d-card32)
			    (save-under ,d-bool)
			    (map-is-installed ,d-bool)
			    (map-state ,(d-const #t
						d-card8
						'((0 . Unmapped)
						  (1 . Unviewable)
						  (2 . Viewable) )))
			    (override-redirect ,d-bool)
			    (colormap ,(d-const #f d-colormap '((0 . None))))
			    (all-event-masks ,d-setofevent)
			    (your-event-mask ,d-setofevent)
			    (do-not-propagate-mask ,d-setofdeviceevent)
			    (unused ,(gobble! 2)) ; 2 unused bytes
   ))
;;; Reply to request #14: GetGeometry
    (getgeometry . ((reply ,(identity 'GetGeometry))
		    (depth  ,d-card8)
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 4)) ; Reply length = 0
		    (root   ,d-window)
		    (x      ,d-int16)
		    (y      ,d-int16)
		    (width  ,d-card16)
		    (height ,d-card16)
		    (border-width ,d-card16)
		    (unused ,(gobble! 10)) ))
;;; Reply to request #15: QueryTree
    (querytree . ((reply ,(identity 'QueryTree))
		  (unused ,d-card8)
		  (seq-nr ,d-card16)
		  (unused ,(gobble! 4)) ; Reply length not used
		  (root   ,d-window)
		  (parent ,(d-const #f d-window '((0 . None))))
		  (nrofwins ,d-card16)
		  (unused ,(gobble! 14))
		  (children ,(lambda (str dpy)
			       ((d-list d-window (backtrack 'nrofwins) )
				str dpy)))))
;;; Reply to request #16: InternAtom
    (internatom . ((reply ,(identity 'InternAtom))
		   (unused  ,d-card8)
		   (seq-nr  ,d-card16)
		   (unused  ,(gobble! 4)) ; Reply length = 0
		   (atom    ,(d-const #f d-atom '((0 . None))))
		   (unused ,(gobble! 20)) ))
;;; Reply to request #17: GetAtomName
    (getatomname . ((reply ,(identity 'GetAtomName))
		    (unused   ,d-card8)
		    (seq-nr   ,d-card16)
		    (unused   ,(gobble! 4)) ; Reply length not used
		    (name-len ,d-card16)
		    (unused   ,(gobble! 22))
		    (name     ,(lambda (str dpy)
				(d-string8 (backtrack 'name-len) str dpy) ))))
;;; Reply to request #20: GetProperty
    (GetProperty . ((reply ,(identity 'GetProperty))
		    (format ,d-card8)
		    (seq-nr ,d-card16)
		    (reply-len ,d-card32)
		    (type ,(d-const #f d-atom '((0 . None))))
		    (bytes-after ,d-card32)
		    (len-in-format-units ,d-card32)
		    (unused ,(gobble! 12))
		    (value ,(lambda (str dpy)
			      ((d-list d-card8 (* 4 (backtrack 'reply-len)) )
			       str dpy)))))
;;; Reply to request #21: ListProperties
    (ListProperties . ((reply ,(identity 'ListProperties))
		       (unused ,(gobble! 1))
		       (seq-nr ,d-card16)
		       (unused ,(gobble! 4)) ; Reply length not used
		       (nr-of-atoms ,d-card16)
		       (unused ,(gobble! 22))
		       (atoms ,(lambda (str dpy)
				 ((d-list d-atom (backtrack 'nr-of-atoms) )
				  str dpy)))))
;;; Reply to request #23: GetSelectionOwner
    (GetSelectionOwner . ((reply ,(identity 'GetSelectionOwner))
			  (unused ,(gobble! 1))
			  (seq-nr ,d-card16)
			  (unused ,(gobble! 4))
			  (owner ,(d-const #f d-window '((0 . None))))
			  (unused ,(gobble! 20)) ))
;;; Reply to request #26: GrabPointer
    (GrabPointer . ((reply ,(identity 'GrabPointer))
		    (status ,(d-const #t d-card8 '((0 . Success)
						  (1 . AlreadyGrabbed)
						  (2 . InvalidTime)
						  (3 . NotViewable)
						  (4 . Frozen) )))
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 28)) )) ; Reply length = 0
;;; Reply to request #31: GrabKeyboard
    (GrabKeyboard . ((reply ,(identity 'GrabKeyboard))
		     (status ,(d-const #t d-card8 '((0 . Success)
						   (1 . AlreadyGrabbed)
						   (2 . InvalidTime)
						   (3 . NotViewable)
						   (4 . Frozen) )))
		     (seq-nr ,d-card16)
		     (unused ,(gobble! 28)) )) ; Reply length = 0
;;; Reply to request #38: QueryPointer
    (QueryPointer . ((reply ,(identity 'QueryPointer))
		     (same-screen ,d-bool)
		     (seq-nr ,d-card16)
		     (unused ,(gobble! 4)) ; Reply length = 0
		     (root ,d-window)
		     (child ,(d-const #f d-window '((0 . None))))
		     (root-x ,d-int16)
		     (root-y ,d-int16)
		     (win-x ,d-int16)
		     (win-y ,d-int16)
		     (mask ,d-setofkeybutmask)
		     (unused ,(gobble! 6)) ))
;;; Reply to request #39: GetMotionEvents
    (GetMotionEvents . ((reply ,(identity 'GetMotionEvents))
			(unused ,(gobble! 1))
			(seq-nr ,d-card16)
			(unused ,(gobble! 4)) ; Reply length not used
			(nr-of-timecoords ,d-card32)
			(unused ,(gobble! 20))
			(events ,(lambda (str dpy)
				   ((d-list (lambda (str dpy)
					      (let* ((time
						      (d-timestamp str
								   dpy))
						     (x (d-card16 str dpy))
						     (y (d-card16 str dpy)))
						(list time x y) ))
					    (backtrack 'nr-of-timecoords) )
				    str dpy)))))
;;; Reply to request #40: TranslateCoordinates
    (TranslateCoordinates . ((reply ,(identity 'TranslateCoordinates))
			     (same-screen ,d-bool)
			     (seq-nr ,d-card16)
			     (unused ,(gobble! 4)) ; Reply length = 0
			     (child ,(d-const #f d-window '((0 . None))))
			     (dst-x ,d-int16)
			     (dst-y ,d-int16)
			     (unused ,(gobble! 16)) ))
;;; Reply to request #43: GetInputFocus
    (GetInputFocus . ((reply ,(identity 'GetInputFocus))
		      (revert-to ,(d-const #t d-card8 '((0 . None)
						       (1 . PointerRoot)
						       (2 . Parent) )))
		      (seq-nr ,d-card16)
		      (unused ,(gobble! 4)) ; Reply length = 0
		      (focus ,(d-const #f d-window '((0 . None)
						    (1 . PointerRoot) )))
		      (unused ,(gobble! 20)) ))
;;; Reply to request #44: QueryKeymap
    (QueryKeymap . ((reply ,(identity 'QueryKeymap))
		    (unused ,(gobble! 1))
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 4)) ; Reply length = 2
		    (keys ,(d-list d-card8 32))))
;;; Reply to request #47: QueryFont
;;; Utility...
    (charinfo . ((left-side-bearing ,d-int16)
		 (right-side-bearing ,d-int16)
		 (character-width ,d-int16)
		 (ascent ,d-int16)
		 (descent ,d-int16)
		 (attributes ,d-card16) ))

    (QueryFont . ((reply ,(identity 'QueryFont))
		  (unused ,(gobble! 1))
		  (seq-nr ,d-card16)
		  (unused ,(gobble! 4)) ; Reply length not used
		  (min-bounds ,(lambda (str dpy)
				(make-reply 'charinfo str dpy) ))
		  (unused ,(gobble! 4))
		  (max-bounds ,(lambda (str dpy)
				(make-reply 'charinfo str dpy) ))
		  (unused ,(gobble! 4))
		  (min-char-or-byte2 ,d-card16)
		  (max-char-or-byte2 ,d-card16)
		  (default-char ,d-card16)
		  (nr-of-fontprops ,d-card16)
		  (draw-direction ,(d-const #t d-card8 '((0 . LeftToRight)
							(1 . RightToLeft) )))
		  (min-byte1 ,d-card8)
		  (max-byte1 ,d-card8)
		  (all-chars-exist ,d-bool)
		  (font-ascent ,d-int16)
		  (font-descent ,d-int16)
		  (nr-of-charinfos ,d-card32)
		  (properties ,(lambda (str dpy)
				 ((d-list (lambda (str dpy)
					    (let* ((name (d-atom str dpy))
						   (val (d-card32
							 str dpy)) )
					      (cons name val) ))
					  (backtrack 'nr-of-fontprops) )
				  str dpy)))
		  (charinfos ,(lambda (str dpy)
				((d-list (lambda (str dpy)
				       (make-reply 'charinfo str dpy))
				     (backtrack 'nr-of-charinfos) )
				 str dpy)))))
;;; Reply to request #48: QueryTextExtents
    (QueryTextExtents . ((reply ,(identity 'QueryTextExtents))
			 (draw-direction ,(d-const #t
						  d-card8
						  '((0 . LeftToRight)
						    (1 . RightToLeft) )))
			 (seq-nr ,d-card16)
			 (unused ,(gobble! 4)) ; Reply length = 0
			 (font-ascent ,d-int16)
			 (font-descent ,d-int16)
			 (overall-ascent ,d-int16)
			 (overall-descent ,d-int16)
			 (overall-width ,d-int32)
			 (overall-left ,d-int32)
			 (overall-right ,d-int32)
			 (unused ,(gobble! 4)) ))
;;; Reply to request #49: ListFonts
    (ListFonts . ((reply ,(identity 'ListFonts))
		  (unused ,(gobble! 1))
		  (seq-nr ,d-card16)
		  (unused ,(gobble! 4)) ; Reply length not used
		  (nr-of-strs ,d-card16)
		  (unused ,(gobble! 22))
		  (names ,(lambda (str dpy)
			   (let loop ((nr (backtrack 'nr-of-strs))
				      (total-length 0) (result '()))
			     (if (zero? nr)
				 (begin
				   ((gobble! (pad total-length)) str dpy)
				   result)
				 (let* ((this-str (list (d-str str dpy)))
					(this-len (+ 1
						     (string-length
						      (car this-str) ))))
				   (loop (- nr 1)
					 (+ total-length this-len)
					 (append result this-str) ))))))))
;;; Reply to request #50: ListFontsWithInfo
    (ListFontsWithInfo . ((reply ,(identity 'ListFontsWithInfo))
			  (length-of-name ,d-card8)
			  (seq-nr ,d-card16)
			  (unused ,(gobble! 4)) ; Reply length not used
			  (min-bounds ,(lambda (str dpy)
					 (make-reply 'charinfo str dpy) ))
			  (unused ,(gobble! 4))
			  (max-bounds ,(lambda (str dpy)
					 (make-reply 'charinfo str dpy) ))
			  (unused ,(gobble! 4))
			  (min-char-or-byte2 ,d-card16)
			  (max-char-or-byte2 ,d-card16)
			  (default-char ,d-card16)
			  (nr-of-fontprops ,d-card16)
			  (draw-direction ,(lambda (scr dpy)
					     ((d-const #t
						       d-card8
						       '((0 . LeftToRight)
							 (1 . RightToLeft) ))
					      scr dpy)))
			  (min-byte1 ,d-card8)
			  (max-byte1 ,d-card8)
			  (all-chars-exist ,d-bool)
			  (font-ascent ,d-int16)
			  (font-descent ,d-int16)
			  (replies-hint ,d-card32)
			  (properties ,(lambda (str dpy)
					 ((d-list (lambda (str dpy)
						    (let* ((name
							    (d-atom str dpy))
							   (val (d-card32
								 str dpy)))
						      (cons name val) ))
						  (backtrack
						   'nr-of-fontprops) )
					  str dpy)))
			  (name ,(lambda (str dpy)
				   (d-string8 (backtrack 'length-of-name)
					      str dpy) ))))
;;; Reply to request #52: GetFontPath
    (GetFontPath . ((reply ,(identity 'GetFontPath))
		    (unused ,(gobble! 1))
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 4)) ; Reply length not used
		    (nr-of-strs ,d-card16)
		    (unused ,(gobble! 22))
		    (path ,(lambda (str dpy)
			    (let loop ((nr (backtrack 'nr-of-strs))
				       (total-length 0)
				       (result '()) )
			      (if (zero? nr)
				  (begin
				    ((gobble! (pad total-length)) str dpy)
				    result)
				  (let* ((this-str (list (d-str str dpy)))
					 (this-len (+ 1
						      (string-length
						       (car this-str)))))
				    (loop (- nr 1)
					  (+ total-length this-len)
					  (append result this-str) ))))))))
;;; Reply to request #73: GetImage
;;; NOTE: Padding is not stripped from the data list returned, as we don't
;;; know how much is present. Does the caller know?
    (Getimage . ((reply ,(identity 'GetImage))
		 (depth ,d-card8)
		 (seq-nr ,d-card16)
		 (reply-len ,d-card32)
		 (visual ,(d-const #f d-visualid '((0 . None))))
		 (unused ,(gobble! 20))
		 (data ,(lambda (str dpy)
			  ((d-list d-card8 (* 4 (backtrack 'reply-len)) )
			   str dpy)))))
;;; Reply to request #83: ListInstalledColormaps
    (ListInstalledColormaps . ((reply ,(identity 'ListInstalledColormaps))
			       (unused ,(gobble! 1))
			       (seq-nr ,d-card16)
			       (unused ,(gobble! 4)) ; Reply length not used
			       (nr-of-cmaps ,d-card16)
			       (unused ,(gobble! 22))
			       (cmaps ,(lambda (str dpy)
					 ((d-list d-colormap
						 (backtrack 'nr-of-cmaps) )
					  str dpy)))))
;;; Reply to request #84: AllocColor
    (AllocColor . ((reply ,(identity 'AllocColor))
		   (unused ,(gobble! 1))
		   (seq-nr ,d-card16)
		   (unused ,(gobble! 4)) ; Reply length = 0
		   (red ,d-card16)
		   (green ,d-card16)
		   (blue ,d-card16)
		   (unused ,(gobble! 2))
		   (pixel ,d-card32)
		   (unused ,(gobble! 12)) ))
;;; Reply to request #85: AllocNamedColor
    (AllocNamedColor . ((reply ,(identity 'AllocNamedColor))
			(unused ,(gobble! 1))
			(seq-nr ,d-card16)
			(unused ,(gobble! 4)) ; Reply length = 0
			(pixel ,d-card32)
			(exact-red ,d-card16)
			(exact-green ,d-card16)
                        (exact-blue ,d-card16)
			(visual-red ,d-card16)
			(visual-green ,d-card16)
			(visual-blue ,d-card16)
			(unused ,(gobble! 8)) ))
;;; Reply to request #86: AllocColorCells
    (AllocColorCells . ((reply ,(identity 'AllocColorCells))
			(unused ,(gobble! 1))
			(seq-nr ,d-card16)
			(unused ,(gobble! 4)) ; Reply length not used
			(nr-of-cards-in-pix ,d-card16)
			(nr-of-cards-in-masks ,d-card16)
			(unused ,(gobble! 20))
			(pixels ,(lambda (str dpy)
				   ((d-list d-card32
					    (backtrack 'nr-of-cards-in-pix) )
				    str dpy)))
			(masks ,(lambda (str dpy)
				  ((d-list d-card32
					  (backtrack 'nr-of-cards-in-masks))
				   str dpy)))))
;;; Reply to request #87: AllocColorPlanes
    (AllocColorPlanes . ((reply ,(identity 'AllocColorPlanes))
			 (unused ,(gobble! 1))
			 (seq-nr ,d-card16)
			 (unused ,(gobble! 4)) ; Reply length not used
			 (nr-of-card32s ,d-card16)
			 (unused ,(gobble! 2))
			 (red-mask ,d-card32)
			 (green-mask ,d-card32)
			 (blue-mask ,d-card32)
			 (unused ,(gobble! 8))
			 (pixels ,(lambda (str dpy)
				    ((d-list d-card32
					     (backtrack 'nr-of-card32s) )
				     str dpy)))))
;;; Reply to request #91: QueryColors
    (QueryColors . ((reply ,(identity 'QueryColors))
		    (unused ,(gobble! 1))
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 4)) ; Reply length not used
		    (nr-of-RGBs ,d-card16)
		    (unused ,(gobble! 22))
		    (colors ,(lambda (str dpy)
			       ((d-list (lambda (str dpy)
					  (let* ((red (d-card16 str dpy))
						 (green (d-card16 str dpy))
						 (blue (d-card16 str dpy))
						 (this-RGB (list red
								 green
								 blue)))
					    ((gobble! 2) str dpy)
					    this-RGB))
					(backtrack 'nr-of-RGBs) )
				str dpy)))))
;;; Reply to request #92: LookupColor
    (LookupColor . ((reply ,(identity 'LookupColor))
		    (unused ,(gobble! 1))
		    (seq-nr ,d-card16)
		    (unused ,(gobble! 4)) ; Reply length = 0
		    (exact-red ,d-card16)
		    (exact-green ,d-card16)
		    (exact-blue ,d-card16)
		    (visual-red ,d-card16)
		    (visual-green ,d-card16)
		    (visual-blue ,d-card16)
		    (unused ,(gobble! 12)) ))
;;; Reply to request #97: QueryBestSize
    (QueryBestSize . ((reply ,(identity 'QueryBestSize))
		      (unused ,(gobble! 1))
		      (seq-nr ,d-card16)
		      (unused ,(gobble! 4)) ; Reply length = 0
		      (width ,d-card16)
		      (height ,d-card16)
		      (unused ,(gobble! 20)) ))
;;; Reply to request #98: QueryExtension
    (QueryExtension . ((reply ,(identity 'QueryExtension))
		       (unused ,(gobble! 1))
		       (seq-nr ,d-card16)
		       (unused ,(gobble! 4)) ; Reply length = 0
		       (present ,d-bool)
		       (major-opcode ,d-card8)
		       (first-event ,d-card8)
		       (first-error ,d-card8)
		       (unused ,(gobble! 20)) ))
;;; Reply to request #99: ListExtensions
    (ListExtensions . ((reply ,(identity 'ListExtensions))
		       (nr-of-strs ,d-card8)
		       (seq-nr ,d-card16)
		       (unused ,(gobble! 28)) ; Reply length not used
		       (names ,(lambda (str dpy)
				(let loop ((nr (backtrack 'nr-of-strs))
					   (total-length 0)
					   (result '()))
				  (if (zero? nr)
				      (begin
					((gobble! (pad total-length)) str dpy)
					result)
				      (let* ((this-str (list (d-str str dpy)))
					     (this-len
					      (string-length (car this-str))) )
					(loop (- nr 1)
					      (+ total-length this-len)
					      (append result this-str) ))))))))
;;; Reply to request #101: GetKeyboardMapping
    (GetKeyboardMapping . ((reply ,(identity 'GetKeyboardMapping))
			   (keysyms-per-keycode ,d-card8)
			   (seq-nr ,d-card16)
			   (reply-len ,d-card32)
			   (unused ,(gobble! 24))
			   (keysyms ,(lambda (str dpy)
				       ((d-list
					 (d-list d-keysym 
						 (backtrack
						  'keysyms-per-keycode))
					 (/ (backtrack 'reply-len)
					    (backtrack 'keysyms-per-keycode) ))
					str dpy)))))
;;; Reply to request #103: GetKeyboardControl
    (GetKeyboardControl . ((reply ,(identity 'GetKeyboardControl))
			   (global-auto-repeat ,(d-const #t
							d-card8
							'((0 . Off)
							  (1 . On) )))
			   (seq-nr ,d-card16)
			   (unused ,(gobble! 4)) ; Reply length = 5
			   (led-mask ,d-card32)
			   (key-click-percent ,d-card8)
			   (bell-percent ,d-card8)
			   (bell-pitch ,d-card16)
			   (bell-duration ,d-card16)
			   (unused ,(gobble! 2))
			   (auto-repeats ,(d-list d-card8 32)) ))
;;; Reply to request #106: GetPointerControl
    (GetPointerControl . ((reply ,(identity 'GetPointerControl))
			  (unused ,(gobble! 1))
			  (seq-nr ,d-card16)
			  (unused ,(gobble! 4)) ; Reply length = 0
			  (acceleration-numerator ,d-card16)
			  (acceleration-denominator ,d-card16)
			  (threshold ,d-card16)
			  (unused ,(gobble! 18)) ))
;;; Reply to request #108: GetScreenSaver
    (GetScreenSaver . ((reply ,(identity 'GetScreenSaver))
		       (unused ,(gobble! 1))
		       (seq-nr ,d-card16)
		       (unused ,(gobble! 4)) ; Reply length = 0
		       (timeout ,d-card16)
		       (interval ,d-card16)
		       (prefer-blanking ,(d-const #t d-card8 '((0 . No)
							      (1 . Yes) )))
		       (allow-exposures ,(d-const #t d-card8 '((0 . No)
							      (1 . Yes) )))
		       (unused ,(gobble! 18)) ))
;;; Reply to request #110: ListHosts
    (ListHosts . ((reply ,(identity 'ListHosts))
		  (mode ,(d-const #t d-card8 '((0 . Disabled)
					      (1 . Enabled) )))
		  (seq-nr ,d-card16)
		  (unused ,(gobble! 4))
		  (nr-of-hosts ,d-card16)
		  (unused ,(gobble! 22))
		  (hosts ,(lambda (str dpy)
			    ((d-list d-host (backtrack 'nr-of-hosts))
			     str dpy) ))))
;;; Reply to request #116: SetPointerMapping
    (SetPointerMapping . ((reply ,(identity 'SetPointerMapping))
			  (status ,(d-const #t d-card8 '((0 . Success)
							(1 . Busy) )))
			  (seq-nr ,d-card16)
			  (unused ,(gobble! 28)) )) ; Reply length = 0
;;; Reply to request #117: GetPointerMapping
    (GetPointerMapping . ((reply ,(identity 'GetPointerMapping))
			  (length-of-map ,d-card8)
			  (seq-nr ,d-card16)
			  (reply-len ,d-card32)
			  (unused ,(gobble! 24))
			  (pmap ,(lambda (str dpy)
				   ((d-list d-card8 (backtrack 'length-of-map))
				    str dpy)))
			  (unused ,(lambda (str dpy)
				     ((gobble! (pad (backtrack
						     'length-of-map)))
				      str dpy)))))
;;; Reply to request #118: SetModifierMapping
    (SetModifierMapping . ((reply ,(identity 'SetModifierMapping))
			   (status ,(d-const #t d-card8 '((0 . Success)
							 (1 . Busy)
							 (2 . Failed) )))
			   (seq-nr ,d-card16)
			   (unused ,(gobble! 28)) )) ; Reply length = 0
;;; Reply to request #119: GetModifierMapping
    (GetModifierMapping . ((reply ,(identity 'GetModifierMapping))
			   (keycodes-per-modifier ,d-card8)
			   (seq-nr ,d-card16)
			   (unused ,(gobble! 28)) ; Reply length not used
			   (keycodes ,(lambda (str dpy)
					((d-list d-keycode
						 (* 8
						    (backtrack
						     'keycodes-per-modifier)))
					 str dpy)))))


; (include "extreplies.sc") ; Reply formats for extensions.

    ))
