;;;
;;;              Copyright 1990 by Digital Equipment AB, Sweden
;;;
;;;                                  and
;;;
;;;                       Hakan Huss and Johan Ihren
;;;
;;;                           All Rights Reserved
;;;
;;;    Permission to use, copy, modify, and distribute this software and
;;;    its documentation for any purpose and without fee is hereby
;;;    granted, provided that the above copyright notice appear in all
;;;    copies and that both that copyright notice and this permis-
;;;    sion notice appear in supporting documentation, and that the
;;;    names of the copyright holders not be used in advertising in
;;;    publicity pertaining to distribution of the software without
;;;    specific, written prior permission. The copyright holders make no
;;;    representations about the suitability of this software for any
;;;    purpose. It is provided "as is" without express or implied warranty.
;;;
;;;    THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
;;;    THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANT-
;;;    ABILITY AND FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS
;;;    BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;;    ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
;;;    PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
;;;    TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
;;;    OR PERFORMANCE OF THIS SOFTWARE.
;;;
;;;    Authors: Hakan Huss, KTH and Johan Ihren, KTH
;;;

;;; $Header: /deneb/src0/johani/scix-0.96/src/RCS/view-object.sc,v 1.3 90/04/01 13:51:39 johani Exp $

;;; Views -- views are containers for graphic objects. They are used to keep
;;;          track of the window contents to facilitate both update (after
;;;          exposure etc.) and switching between several different, possibly
;;;          partially overlapping, layouts in the same window.
;;;          Any graphic object is either simple (a primitive object or a view)
;;;          or a pair P ((car P) is a graphic object and (cdr P) is a gc).
;;;          The object P is called a GC CLOSURE. The graphic object P is
;;;          always interpreted using the bound GC.

;;; Views should acknowledge the messages
;;; (view 'add! <list of graphics>)           -- add new objects to the list
;;; (view 'set! <list of graphics>)           -- set the display list
;;; (view 'contents)                          -- spew out the display list
;;;
(eval-when (compile eval load)
  (define-lw-class (view)
    (locals
     (display-list '()))
    (methods
     (contents (lambda () display-list)) ; Spew out the dpy-list.

     (add! (lambda (obj-list)		; add! just adds graphic-objects
	     (for-each (lambda (o)
			 (if (not (memq o display-list))
			     (begin
			       (set! display-list
				     (append display-list (list o)))
			       #t)
			     #f))
		       obj-list)))
     
     (set! (lambda (obj-list) (set! display-list obj-list)))
   ))
  ) ;; End of eval-when





