/* $Id: matherr.c,v 1.1 1995/06/20 17:10:31 bert Exp $
 *
 * Sun math error trapping...
 */

#include <stdio.h>
#include <stdlib.h>
#include "complex.h"

int matherr(struct exception *x)
{
  char *errtype = "(unknown)";

  switch (x->type) {
  case DOMAIN:    errtype = "argument domain exception"; break;
  case SING:      errtype = "argument singularity"; break;
  case OVERFLOW:  errtype = "overflow range exception"; break;
  case UNDERFLOW: errtype = "underflow range exception"; break;
  case TLOSS:     errtype = "total loss of significance"; break;
  case PLOSS:     errtype = "partial loss of significance"; break;
  }

  fprintf(stderr, "warning: math exception in %s -- %s\n",
	  x->name, errtype);
  return 0;
}
