#!/usr/athena/bin/perl
use warnings;
use strict;
use Text::Wrap;
use Text::Tabs;

$Text::Wrap::columns = 76;

sub pbrk (@) { print map "[$_]", @_; }
sub maplen ($) {
  my (@lines) = split /\n+/, $_[0];
  print map $_."\n", @lines;
  print map length($_)."\n", @lines;
}

sub try_diff ($) {
  my ($text) = @_;
  $text =~ s/\s*$//g;
  my ($wrap) = $text;
  $wrap =~ s/(?:\n|\s{3,})+/ /g;
  $wrap = expand wrap '', '', $wrap;

  $text =~ s/\n/|\n/g;  $text =~ s/\t/\\t/g;
  $wrap =~ s/\n/|\n/g;  $wrap =~ s/\t/\\t/g;

  $text eq $wrap and return;
  print $text;
  print "\$\n-----\n";
  print $wrap;
  print "\$\n=====\n";
}

local($/) = '';
scalar <>;
scalar <>;

while (1) {
  defined(my $head = scalar <>) or exit 0;
  $head =~ /^[A-Z]+:\s*$/s and redo;

  defined(my $body = scalar <>) or exit 0;

  try_diff $head;
  try_diff $body;
}
