/* limits.h standard header 
 * $Version: 1.8 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _LIMITS
#define _LIMITS

#include <yvals.h>

/*
 * [1]-STANDARD C DEFINITIONS
 */
#if (_model_rmx) || (_model_blue) || (_model_posix) || (_model_green)

#define CHAR_BIT    8               /* number of bits in a byte */
#define UCHAR_MAX   255u            /* maximum value of an unsigned char */
#define SCHAR_MAX   127             /* maximum value for a signed char */
#define SCHAR_MIN   (-128)          /* minimum value of a signed char
                                       (-SCHAR_MAX - 1) */

#if '\xFF' < 0
#define CHAR_MAX    SCHAR_MAX       /* maximum value of a 'plain' char */
#define CHAR_MIN    SCHAR_MIN       /* minimum value of a 'plain' char */
#else
#define CHAR_MAX    UCHAR_MAX       /* maximum value of a 'plain' char */
#define CHAR_MIN    0               /* minimum value of a 'plain' char */
#endif

#define USHRT_MAX   65535u          /* maximum value of an unsigned short */
#define SHRT_MAX    32767           /* maximum value of a short int */
#define SHRT_MIN    (-32768)        /* minimum value of a short int
                                       (-SHRT_MAX - 1) */
#define ULONG_MAX   4294967295u     /* maximum value of an unsigned long */
#define LONG_MAX    2147483647l     /* maximum value of a long int */
#define LONG_MIN    (-2147483647l-1)/* minimum value of a long int
                                       (-LONG_MAX - 1) */

#ifdef __INT16__
#define INT_MAX     SHRT_MAX        /* maximum value of an int */
#define INT_MIN     SHRT_MIN        /* minimum value of an int */
#define UINT_MAX    USHRT_MAX       /* maximum value of an unsigned int */
#else /* __INT32__ */
#define INT_MAX     LONG_MAX        /* maximum value of an int */
#define INT_MIN     LONG_MIN        /* minimum value of an int */
#define UINT_MAX    ULONG_MAX       /* maximum value of an unsigned int */
#endif /* __INT16__ */

#define MB_LEN_MAX     1

#endif /* rmx, blue, posix and green */

/*
 * [2]-COMMON DEFINITIONS THAT ARE NOT STANDARD C DEFINITIONS
 */
#if (_model_blue) || (_model_posix) || (_model_green)
#endif /* blue, posix and green */

/*
 * [3]-COMMON NETWORK DEFINITIONS (same as _UNIX_SOURCE)
 */
#if (_model_blue) || (_model_green)
#endif /* blue and green */

/*
 * [4]-COMMON NON-POSIX DEFINITIONS
 */
#if (_model_rmx) || (_model_blue)
#endif /* rmx and blue */

/*
 * [5]-POSIX SPECIFIC DEFINITIONS (same as _POSIX_SOURCE)
 */
#if (_model_posix) || (_model_green)

#define _POSIX_ARG_MAX          4096    /* length of arguments to exec including
                                           environment data */
#define _POSIX_CHILD_MAX        6       /* Number of simultaneous processes per
                                           user id */
#define _POSIX_OPEN_MAX         16      /* Number of files one process can 
                                           have open at a time */
#define _POSIX_TZNAME_MAX       3       /* maximum # of bytes supported for the
                                           name of a timezone */

#endif /* posix and green */

/*
 * [6]-RMX SPECIFIC DEFINITIONS
 */
#if (_model_rmx)
#endif /* rmx */

/*
 * [7]-NON-POSIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_blue)
#endif /* blue */

/*
 * [8]-UNIX/UNIX NETWORKING INTERFACE SPECIFIC DEFINITIONS
 */
#if (_model_green)
#endif /* green */


#endif /* _LIMITS */
