/* locale.h header
 * $Version: 1.5 $
 * Copyright (c) 1990, 93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _LOCALE 
#define _LOCALE

#include <yvals.h>
#include <_align.h>

/*
 * macro definitions
 */

#define LC_ALL		0
#define LC_COLLATE	1
#define LC_CTYPE	2
#define LC_MONETARY	3
#define LC_NUMERIC	4
#define LC_TIME		5
#define LC_MIN      LC_ALL
#define LC_MAX      LC_TIME


struct lconv {
    char *decimal_point;
    char *thousands_sep;
    char *grouping;
    char *int_curr_symbol;
    char *currency_symbol;
    char *mon_decimal_point;
    char *mon_thousands_sep;
    char *mon_grouping;
    char *positive_sign;
    char *negative_sign;
	char int_frac_digits;
	char frac_digits;
	char p_cs_precedes;
	char p_sep_by_space;
	char n_cs_precedes;
	char n_sep_by_space;
	char p_sign_posn;
	char n_sign_posn;
};


/*
 * function prototypes
 */

char          * _Pascal setlocale(int, const char *);
struct lconv  * _Pascal localeconv(void);

#include <_restore.h>

#endif /* _LOCALE */
