/* process.h non-standard header, process control function prototypes
 * $Version: 1.2 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _PROCESS
#define _PROCESS

#include <yvals.h>
#include <sys/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#define P_WAIT		0
#define P_NOWAIT	1
#define P_OVERLAY	2

/*
 * function prototypes
 */

int             _Pascal _doexec(int, int, int, int, int, int, char *, char *,
						   char *, char *, char *, char *);
int             _Pascal _exec(const char *, const char **, const char **, int);
int             _Cdecl execl(const char *, const char *, ...);
int             _Cdecl execle(const char *, const char *, ...);
int             _Cdecl execlp(const char *, const char *, ...);
int             _Cdecl execlpe(const char *, const char *,...);
int             _Pascal execv(const char *, const char **);
int             _Pascal execve(const char *, const char **, const char **);
int             _Pascal execvp(const char *, const char **);
int             _Pascal execvpe(const char *, const char **, const char **);
void            _Pascal _exit(int);
gid_t           _Pascal getgid(void);
gid_t           _Pascal getegid(void);
pid_t           _Pascal getpid(void);
uid_t           _Pascal getuid(void);
unsigned int    _Pascal sleep(unsigned int);
int             _Pascal _spawn(int, const char *, const char **, const char **,
						   int);
int             _Cdecl spawnl(int, const char *, const char *, ...);
int             _Cdecl spawnle(int, const char *, const char *,...);
int             _Cdecl spawnlp(int, const char *, const char *, ...);
int             _Cdecl spawnlpe(int, const char *, const char *, ...);
int             _Pascal spawnv(int, const char *, const char **);
int             _Pascal spawnve(int, const char *, const char **, const char **);
int             _Pascal spawnvp(int, const char *, const char **);
int             _Pascal spawnvpe(int, const char *, const char **, const char **);

#ifdef __cplusplus
}
#endif
#endif /* _PROCESS */

