/* Ethernet encoding/decoding - this version is written with clarity
   of implementation as the first priority; a number of optimizations
   are possible


#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "ethernet.h"


/* decode raw ethernet or 802.2/802.3 packet (just the data and the
   length) extracting useful fields. Shares data with teh raw packet
   it's decoded from. */

en_packet *decode_en_packet(en_raw_packet *raw)
{
  en_packet *result;
  int ieee802 = 0;
  
  result = (en_packet *) malloc(sizeof(en_packet));

  /* extract destination adress */
  memcpy ((void *) (result->dest_addr), (void *) (raw->data+0), 6);
  /*  swap_en_addr (result->dest_addr); */

  /* extract source adress */
  memcpy ((void *) (result->src_addr), (void *) (raw->data+6), 6);
  /*  swap_en_addr (result->src_addr); */

  /* extract type code */
  result->type = SWAP16(*((u16 *)(raw->data+12)));

  /* Is this ethernet or 802.3? */
  if (result->type < 1536) {
    /* IEEE 802.3 - so get the real type field and remember to skip
       the 802.2 header when copying the data. */
    result->type = SWAP16(*((u16 *)(raw->data+12)));
    ieee802 = 1;
  } else {
    /* True ethernet - don't try to skip an 802.2 header later. */
    ieee802 = 0;
  }

  /* Omit ethernet or 802.3 header and trailer. */
  result->length= raw.length - (18 + (ieee802 ? 8 : 0)); 

  /* Allocate space for the data. */
  result->data=(u8 *) malloc(sizeof(u8)*result->length);

  /* mark location of the real data - don't bother to byte-swap, as we will 
     never interpret most of the data, just pass it along. The IP
     and ARP layers can deal with swapping the relevant headers. */
  result->raw_data= raw->data;
  result->data = (result->raw_data + (14 + (ieee802 ? 8 : 0)));

  /* get the CRC from the trailer */
  result->crc = SWAP32 (*((u32 *)(raw->data+raw->length-4)));

  /* return the result */
  return result;
}


/* Forms a raw ethernet output packet - with luck, this will be the
   only place in the protocol stack where a copy will be necessary. */

en_raw_packet *encode_en_packet(en_packet *pkt) 
{
  en_raw_packet *result;

  result=(en_raw_packet *) malloc(sizeof(en_raw_packet));
  result->length = pkt->length+14;
  result->data = (u8 *) malloc(sizeof(u8)*result->length);

  /* Copy the adresses and type field */
  memcpy ((void *) (result->data+0), (void *) (pkt->dest_addr), 6);
  memcpy ((void *) (result->data+6), (void *) (pkt->src_addr), 6);
  *((u16 *)(raw->data+12)) = SWAP16(pkt->type);

  /* copy the actual data. */
  memcpy ((void *) (result->data+14), pkt->data, pkt->length);
  
  return result;
}


void free_en_packet(en_packet *pkt)
{
  free(pkt->raw_data);
  free(pkt);
}


void free_en_raw_packet(en_raw_packet *pkt)
{
  free (pkt->data);
  free (pkt);
}



