#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#include "router.h"

/* Convert network address string of form aa.bb.cc.dd to 32bit 
   ip address */
u32 my_aton(char *str) {
    u8 c, x;
    u8 parts[4];
    
    c = *str;
    for(x=0; x<4; x++) {
	parts[x] = 0;
	for(;;) {
	    if (isdigit(c)) {
		parts[x] = parts[x]*10 + (c - '0');
		c = *++str;
	    }
	    else
		break;
	}
	c = *++str;
    }
    return *(int*)parts;
}

/* Convert network address string of form aa:bb:cc:dd:ee:ff to 48bit 
   ethernet address */
void my_atoh(char *str, ether_addr *hw_addr) {
    u_int i[6];
    char *c = (char *)hw_addr;

    if (sscanf(str, " %x:%x:%x:%x:%x:%x ", &i[0], &i[1],
	       &i[2], &i[3], &i[4], &i[5]) == 6) {
	c[0] = (u_char)i[0];
	c[1] = (u_char)i[1];
	c[2] = (u_char)i[2];
	c[3] = (u_char)i[3];
	c[4] = (u_char)i[4];
	c[5] = (u_char)i[5];
    }
}
