#ifndef _ROUTER_H
#define _ROUTER_H

#include "types.h"
#include "ethernet.h"
#include "ether.h"
#include "memblock.h"
#include "arp.h"
#include "arpcache.h"
#include "ipv4.h"
#include "rt_table.h"
#include "iofuncs.h"
#include "fifo.h"
#include "int.h"
#include "monitor.h"
#include "hardware.h"
#include "my_aton.h"
#include "rtglue.h"

#ifdef TESTBED
#include "unix.h"
#endif

/* DEFINES */

#define ETH0 0
#define ETH1 1

#define UP 0
#define DOWN 1

#define ETH0_PATHNAME "/tmp/router_0"
#define ETH1_PATHNAME "/tmp/router_1"

#define ETH0_ETHER_ADDR "1:2:3:4:5:6"
#define ETH1_ETHER_ADDR "8:9:10:11:12:13"
#define ETH0_IP_ADDR "9.8.7.6"
#define ETH1_IP_ADDR "4.3.2.1"

/* <15,7> must be 0, <6,4> first digit of interrupt level, 
   <3> slave/master control, <2,0> are second digit of interrupt level 
   See page 9-9 of EMB OS System Concepts.  These are sorta guesses
   for now */
#define ETH0_INT_RECEIVE_LEVEL  0x0010 
#define ETH1_INT_RECEIVE_LEVEL  0x0011

#define RCVFIFO 0x0
#define XMTFIFO 0x2
#define XMTFC   0x4
#define XMTFS   0x6
#define XMTRC   0x8
#define RCVFC   0xA
#define RCVFS   0xC
#define FIFOFC  0xE
#define IR      0x10
#define IMR     0x12
#define PR      0x14
#define BIUCC   0x16
#define FIFOCC  0x18
#define MACCC   0x1A
#define PLSCC   0x1C
#define CHIPID  0x20
#define IAC     0x24
#define LADRF   0x28
#define PADR    0x2A
#define MPC     0x30
#define RNTPC   0x34
#define RCVCC   0x36
#define UTR     0x3A
#define RTR1    0x3C
#define RTR2    0x3E

#define BIT(n) (((unsigned long)1)<<n)

#define XMTSV   BIT(7)
#define TDTREQ  BIT(6)

/* MACROS */

#ifndef TESTBED
#define ERR(status) {if((status) != E_OK) \
                     err_handler(__LINE__, __FILE__, status);}
#else
#define ERR(status) {if((status) == -1) \
                     err_handler(__LINE__, __FILE__, status);}
#endif

#endif
