#ifndef RT_TABLE_H
#define RT_TABLE_H

#include "types.h"

typedef struct tag_rt_table_entry rt_table_entry;

struct tag_rt_table_entry {
  u32 dest;
  u32 net_mask;
  u32 next_hop_ip;
  int next_hop_if;
  int net_p;
  rt_table_entry *next;
};


void rt_add_host_route(u32 dest_ip, u32 next_hop_ip, int ifx);
void rt_add_net_route(u32 net_ip, u32 net_mask, u32 next_hop_ip, int ifx);
void rt_add_default_route(u32 next_hop_ip, int ifx);
rt_table_entry *rt_route(u32 dest_ip);


#endif /* RT_TABLE_H */
