// Copyright 1995 Barbara Liskov

#ifndef _DATABASE_H
#define _DATABASE_H

#include "6170.h"
#include "file.h"

class database {
    // Overview:
    //    A "database" represents a database of objects of type "file".
    //    It is either created from an ASCII stream describing the database,
    //    or by individual addition of "files".  Databases
    //    can report the files that satisfy a simple conjunctive
    //    query.
  public:
    database();
    // effects  Creates an empty database
    
    database(istream &input);
    // requires  "input" must be a readable stream containing
    //           an ASCII representation of a number of files,
    //           one line per file. The format of this stream
    //           is that generated by the Unix command "ls -lLd",
    //           and is specified in the problem set 3 handout.
    // modifies  input
    // effects   Create a database that contains "file" objects
    //           for each of the lines in the input stream.

    void add(file *insertion);
    // requires  insertion be a valid file pointer.
    // effects   Adds insertion to the database of "files".

    generator<file *> *satisfiers(string name,
                                  string owner,
                                  string times,
                                  int minsize,
                                  string &errmsg);
    // effects   If the arguments are valid, return a generator that
    //           yields the files in the database that satisfy the query.
    //           Otherwise, return 0 and put an error
    //           message describing which argument is invalid into
    //           "errmsg".
    //
    //           The "name" and "owner" arguments are valid if
    //           they are valid pattern specifiers. The "times" argument
    //           is valid if it is a valid date range. 
    //
    //           A file satisfies a query under the following
    //           conditions: The patterns described by "name" and "owner"
    //           must match the file's attribute of the same
    //           name. Also, the "size" attribute of the file
    //           must be at least as large as "minsize". Finally,
    //           the "time" of the file must fall within the
    //           range specified in "times".

  private:
    friend class file_generator;

    // The representation
    array<file *> rep;
};

#endif /* _DATABASE_H */
