#include <ctype.h>
#include <time.h>
#include <sys/time.h>
#include <stdlib.h>
#include "time.h"

int get_epoch_time(int year, int month, int day, int hours, int minutes) {
    struct tm time_val;
    time_val.tm_sec = 0;
    time_val.tm_isdst = 0; // ignore daylightsaving time
    time_val.tm_year = year-1900;
    time_val.tm_mon = month-1;
    time_val.tm_mday = day;
    time_val.tm_hour = hours;
    time_val.tm_min = minutes;
    return mktime(&time_val);
}

int get_year(int month, int day, int hours, int minutes) {
      // find current year
      struct timeval tp;
      check (gettimeofday(&tp, NULL)==0, "gettimeofday");
      time_t curtime = tp.tv_sec;
      int year = localtime(&curtime)->tm_year + 1900;
      int given_time = get_epoch_time(year, month, day, hours, minutes);
      if (given_time > curtime) year--;
      return year;
}    

bool query_time_to_int(string time, int &time_in_seconds, bool low_end) {

    int day, month, year, hours, minutes;
    int length = time.length();
    if ((length != 10) && (length != 11)) return FALSE;
    if (time[2] != '/' || time[5] != '/') return FALSE;

    bool digits = isdigit(time[0]) && isdigit(time[1]);
    if (!digits) return FALSE;
    month = atoi(time.substring(0, 2).get_chars());
    digits = isdigit(time[3]) && isdigit(time[4]);
    if (!digits) return FALSE;
    day = atoi(time.substring(3, 2).get_chars());

    digits = isdigit(time[6]) && isdigit(time[7]);
    if (!digits) return FALSE;
    if (length == 10) { // Form mm/dd/yyyy
	if (! (isdigit(time[8]) && isdigit(time[9]))) return FALSE;
	year = atoi(time.substring(6, 4).get_chars());
	if (low_end) {
	    hours = 0;
	    minutes = 0;
	} else {
	    hours = 23;
	    minutes = 59;
	}
    } else {  // form mm/dd/hh:mm
	if (!(time[8] == ':' && isdigit(time[9]) && isdigit(time[10])))
	    return FALSE;
	hours = atoi(time.substring(6, 2).get_chars());
	minutes = atoi(time.substring (9, 2).get_chars());
	year = get_year(month, day, hours, minutes);
    }
    time_in_seconds = get_epoch_time(year, month, day, hours, minutes);
    return TRUE;
}

bool get_query_times(string times, int min_allowed_time,
			   int max_allowed_time,
			   int& lowtime, int& hightime) {

    int length = times.length();
    if (length == 1 && times[0] == '*') {
	lowtime = min_allowed_time;
	hightime = max_allowed_time;
	return TRUE;
    }

    if (length < 12) return FALSE;

    // Range of the type ..x
    if (times[0] == '.') {
	if (times[1] != '.') return FALSE;
	if (!query_time_to_int(times.substring(2, length - 2), 
			       hightime,
			       false))
	    return FALSE;
	if (hightime > max_allowed_time) return FALSE;
	lowtime = min_allowed_time;
	return TRUE;
    }
	
    // Range of the type x..
    if (times[length-1] == '.') {
	if (times[length-2] != '.') return FALSE;
	if (!query_time_to_int(times.substring(0, length - 2),
			       lowtime, 
			       true))
	    return FALSE;
	if (lowtime < min_allowed_time) return FALSE;
	hightime = max_allowed_time;
	return TRUE;
    }
	
    // Range of type x..y
    int i;
    for (i = 0; i < length-1; i++) {
	if (times[i] == '.') {
	    if (times[i+1] == '.') break;
	    else return FALSE;
	}
    }
    if (i == length-1) return FALSE; // did not find ..
    if (!query_time_to_int(times.substring(0, i), 
			   lowtime, 
			   true)
	|| lowtime < min_allowed_time) 
	return FALSE;
    
    if (!query_time_to_int(times.substring(i+2, length-i-2),
			   hightime, 
			   false)
	|| hightime > max_allowed_time)
	return FALSE;
    if (lowtime > hightime) return FALSE;
    return TRUE;
}

char *months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
		   "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

inline int get_month (string s) {
    register int i;
        
    for (i = 0; i < 12; i++) {
	if (s == months[i]))
	    return i+1;
    }
    return 0;
}

static int year=0;

bool db_time_to_int(string time, int& time_in_seconds) {
    int month, day, hours, minutes;
    int next = 4;
    int length = time.length();

    if (length != 12) return FALSE;

    month = get_month(time.substring(0, 3));
    check (month, "invalid month in db time");

    if (time[next] == ' ') 
	next = 5;
    day = atoi(time.substring(next, 6-next).get_chars());
    if (time[length-3] == ':') { // Date of the format Mmm dd hh:mm
	hours = atoi(time.substring(7, 2).get_chars());
	minutes = atoi(time.substring(10, 2).get_chars());
	if (!year) {
	    year = get_year(month, day, hours, minutes);
	}
    } else { // Date of the format (1)
	year = atoi(time.substring(8, 4).get_chars());
	hours = minutes = 0;
    }
    time_in_seconds = get_epoch_time(year, month, day, hours, minutes);
    return TRUE;
}
    
