/*
 * tkz.h --
 *
 *  structures for zwish
 *
 * by Chris Shabsin <shabby@mit.edu>
 *
 * begun 11/19/93
 *
 */

#include <sys/types.h>
#include <tk.h>
#include <zephyr/zephyr.h>
#include <zephyr/zephyr_err.h>
#include <com_err.h>

/* Some zephyr functions that aren't prototyped in zephyr.h. */
Code_t ZOpenPort(unsigned short *port);
Code_t ZClosePort(void);
Code_t ZSubscribeTo(ZSubscription_t *sublist, int nitems, unsigned short port);
Code_t ZUnsubscribeTo(ZSubscription_t *sublist, int nitems, 
		      unsigned short port);
int ZPending (void);
Code_t ZReceiveNotice(ZNotice_t *, struct sockaddr_in *);


int Zep_Init(Tcl_Interp *interp);
int tkzZInitialize(ClientData clientData, Tcl_Interp *interp, int argc,
		   char *argv[]);
int tkzZOpenPort(ClientData clientData, Tcl_Interp *interp, int argc,
		 char *argv[]);
int tkzZClosePort(ClientData clientData, Tcl_Interp *interp, int argc,
		  char *argv[]);

typedef struct _tkzZNotice_t {
  ZNotice_t notice;
  int nfields;
  char **fields;
  struct sockaddr_in from;
} tkzZNotice_t;

int tkzZNotice_tCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		 char *argv[]);
int tkzZNoticeObjCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		     char *argv[]);
void tkzZNoticeObjFree(char *clientData);


int tkzZSubscribeCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		     char *argv[]);
int tkzZUnsubscribeCmd(ClientData clientData, Tcl_Interp *interp, int argc,
		       char *argv[]);
int tkzZPendingCmd(ClientData clientData, Tcl_Interp * interp, int argc, 
		   char *argv[]);
int tkzZReceiveCmd(ClientData clientData, Tcl_Interp * interp, int argc, 
		   char *argv[]);
int tkzZReceiveNotice(ClientData clientData, Tcl_Interp * interp, int argc, 
		      char *argv[]);
int tkzZReceiveStartCmd(ClientData clientData, Tcl_Interp *interp, 
			int argc, char *argv[]);
int tkzZReceiveStopCmd(ClientData clientData, Tcl_Interp *interp, 
		       int argc, char *argv[]);
int tkzZSetHandlerCmd(ClientData clientData, Tcl_Interp * interp,
		      int argc, char *argv[]);
