/* reent.h - header file for reentrancy hooks
 * $Version: 1.10 $
 * Copyright (c) 1988-93 Intel Corporation, ALL RIGHTS RESERVED.
 */

#ifndef _REENT 
#define _REENT 

#include <yvals.h>
#include <locale.h>
#include <time.h>
#include <_align.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * macro definitions
 */

#define INIT_OK             0
#define THREAD_INIT_ERROR   2

/*
 * type definitions
 */

#ifndef _SIZET
#define _SIZET
typedef _Sizet size_t;
#endif

/*
 * structure definitions
 */

#ifndef _free_list_item_t
#define _free_list_item_t
struct free_list_item {
    _ptrdef(struct free_list_item, next)
    _aligndef(unsigned int, length)
};
#endif

struct _heap {
    _ptrdef(void, _malloc_sem)
    _ptrdef(struct free_list_item, _primary_free_list)
    _ptrdef(struct free_list_item, _secondary_free_list)
    _aligndef(int, _secondary_list_count)
    _ptrdef(struct free_list_item, _allocated_list)
    _aligndef(int, _allocated_list_count)
    _aligndef(unsigned int, _last_fill)
    _aligndef(unsigned char, _fill_set)
};

struct _locale {
    struct lconv    _locale_conv;
    char          * _locale_array[LC_MAX+1];
};

struct _tzset {
    char          * _tzname[2];
    long32          _timezone;
    int             _daylight;
};

#ifndef _FILE
#define _FILE
struct _iobuf {
    _ptrdef(unsigned char, _ptr)
    _aligndef(int, _cnt)
    _ptrdef(unsigned char, _base)
    _aligndef(int, _flag)
    _aligndef(int, _fd)                     /* File descriptor number */
    _aligndef(int, _size)                   /* File buffer size */
    _ptrdef(char, _temp_name)               /* Temporary file name */
    _ptrdef(void, _sem)                     /* Semaphore */
    _ptrdef(struct _iobuf, _next_stream)    /* Pointer to the next stream */
};
typedef struct _iobuf FILE;
#endif /* _FILE */

struct _stdio {
    FILE    _stdin;     /* stdin stream */
    FILE    _stdout;    /* stdout stream */
    FILE    _stderr;    /* stderr stream */
};
struct _stdio  * _Pascal _stdio_create(size_t);
struct _stdio  * _Pascal _stdio_ptr(void);

struct _exit {
    _ptrdef(void, open_stream_sem)
    _ptrdef(struct _iobuf *, open_stream_list) /* list is maintained as a stack */
    _ptrdef(void, exit_handler_sem)
    _aligndef(int, exit_handler_count)
    void (_Pascal *exit_handler_list[32])();
};

struct _thread {
    _aligndef(int, _errno)
    _ptrdef(char, _strtok_buffer)
    _ptrdef(struct tm, _gmtime_buffer)
    unsigned long32 _rand_seed;
    _ptrdef(struct _heap, _heap_header)
    _ptrdef(struct _locale, _locale_data)
    _ptrdef(struct _tzset, _tzset_data)
    char            _asctime_buffer[26];
    _aligndef(int, __doserrno)
};

/*
 * function prototypes
 */

int                 _Pascal _exit_init(void);
int                 _Pascal _stdio_init(void);
int                 _Pascal _thread_init(void);
void                _Pascal _init_clib_data(struct _thread *);
struct _exit      * _Pascal _exit_create(size_t);
struct _thread    * _Pascal _thread_create(size_t);
struct _exit      * _Pascal _exit_ptr(void);
struct _thread    * _Pascal _thread_ptr(void);
struct _tzset     * _Pascal _tzset_ptr(void);
void              * _Pascal _tzset_ptrs(int);
void              * _Pascal _alias_ptr(void *);
void              * _Pascal _dealias_ptr(void *);
void                _Pascal _semaphore_delete(void **);
void                _Pascal _semaphore_init(void **);
void                _Pascal _semaphore_signal(void **);
void                _Pascal _semaphore_wait(void **);

#define _EXIT_PTR   _exit_ptr()
#define _STDIO_PTR  _stdio_ptr()
#define _THREAD_PTR _thread_ptr()

#ifdef __cplusplus
}
#endif

#include <_restore.h>

#endif /* _reenth */
