#ifndef _WEB_NODE_H
#define _WEB_NODE_H

#include "6170.h"

class http_response;
template <class KEY, class VALUE> class map;

typedef map<string, string> extensions;

class web_node {

public:

// abstract: A "web_node" represents a URL in the web and all URLs that
//      have it as a prefix. It may contain a set of other child web nodes.
//      A web node may be contained by more than one parent node.
//      "web_node" is a heap abstraction.

// methods:

    virtual http_response *get(string request, extensions *ext) = 0;
    // checks: whether "request" has the form "pathname" or "pathname?arg"
    // modifies: "this"
    // effects: Returns the appropriate information for the request. Additional
    //          information associated with the request is found in "ext",
    //          which may be zero if there is no additional information.
    //
    //          "ext" will likely contain an entry for "Accept", which contains
    //          a list of space-separated accepted output formats, and an
    //          entry for "User-Agent", which describes which browser is
    //          requesting the information.
    //
    // inherited: returns a simple default HTML message.

    virtual generator<web_node *> *descendants();
    // effects:  returns a generator that produces all web nodes that are
    //           contained within this web node.
    // inherited: yields no web nodes.

private:
    void operator= (web_node &);
};


#endif /* _WEB_NODE_H */
