// Copyright 1995 Barbara Liskov

#ifndef _BUCKETS_T
#define _BUCKETS_T

#include "bhash.h"

#define buckets_t buckets<KEY, VALUE>
#define buckets_rep_t buckets_rep<KEY, VALUE>

BK_TEMPLATE class buckets_generator : public hash_generator<KEY, VALUE> {
    // "buckets_generator" is a generator for the class "buckets"
public:
    buckets_generator(buckets<KEY,VALUE> &buckets) {
	pairs = 0;
	last = &buckets.pairs;
    }
    virtual bool get(KEY &k);
    virtual VALUE value() const;
    virtual void remove();
protected:
    buckets_rep_t *pairs;
      // points to the current mapping, or 0 if the current mapping is
      // invalid (i.e. we are at the beginning or the current elt has been
      // removed.
    buckets_rep<KEY,VALUE> **last;
      // points to the "next" field of the previous mapping
};

BK_TEMPLATE struct buckets_rep {
    buckets_rep(KEY k, VALUE v, buckets_rep<KEY,VALUE> *n)
      : key(k), value(v), next(n) {}
    KEY key;
    VALUE value;
    buckets_rep_t *next;
};

BK_TEMPLATE buckets_t::buckets() { pairs = 0; }
BK_TEMPLATE buckets_t::~buckets() {
    buckets_rep_t *b = pairs;
    while (b) {
	buckets_rep_t *n = b->next;
	delete b;
	b = n;
    }
}

BK_TEMPLATE bool buckets_t::full() const { return pairs ? TRUE : FALSE; }

BK_TEMPLATE bool buckets_t::find(KEY k, VALUE &v) const {
    buckets_rep_t *b = pairs;
    while (b) {
	if (b->key == k) {
	    v = b->value;
	    return TRUE;
	}
	b = b->next;
    }
    return FALSE;
}
	
BK_TEMPLATE VALUE buckets_t::fetch(KEY k) const {
    buckets_rep_t *b = pairs;
    while (!(b->key == k)) b = b->next;
    return b->value;
}

BK_TEMPLATE void buckets_t::add(KEY k, VALUE v) {
#ifndef NDEBUG
    VALUE v2;
    assert(false == find(k, v2));
#endif
    pairs = new buckets_rep_t(k, v, pairs);
}
	
BK_TEMPLATE bool buckets_t::store(KEY k, VALUE v) {
    buckets_rep_t *b = pairs;
    while (b) {
	if (b->key == k) {
	    b->value = v;
	    return TRUE;
	}
	b = b->next;
    }
    add(k, v);
    return FALSE;
}

BK_TEMPLATE bool buckets_t::remove(KEY k, VALUE &v) {
    buckets_rep_t **last = &pairs;
    buckets_rep_t *b = pairs;
    while (b) {
	if (b->key == k) {
	    *last = b->next;
	    v = b->value;
	    delete b;
	    return TRUE;
	}
	last = &b->next;
	b = *last;
    }
    return FALSE;
}

BK_TEMPLATE void buckets_t::operator=(buckets_t const &buckets) {
    buckets_rep_t **last = &pairs;
    buckets_rep_t *b = buckets.pairs;
    pairs = 0;
    while (b) {
	buckets_rep_t *copy = new buckets_rep_t(b->key, b->value, 0);
	*last = copy;
	last = &copy->next;
	b = b->next;
    }
}

BK_TEMPLATE bool buckets_generator<KEY, VALUE>::get(KEY &k) {
    buckets_rep_t *b = pairs;
    if (b) last = &b->next;
    b = pairs = *last;
    if (b) {
	k = b->key;
	return TRUE;
    } else {
	return FALSE;
    }
}

BK_TEMPLATE VALUE buckets_generator<KEY, VALUE>::value() const {
    return pairs->value;
}

BK_TEMPLATE void buckets_generator<KEY, VALUE>::remove() {
    buckets_rep_t *b = pairs->next;
    *last = b;
    pairs = 0;
}

BK_TEMPLATE hash_generator<KEY, VALUE> *buckets_t::mappings() {
    return new buckets_generator<KEY, VALUE>(*this);
}

#endif /* _BUCKETS_T */
