/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _CLOSURE_INC
#define _CLOSURE_INC

#include "obj.h"
#include "string.h"
#include "sym.h"
#include "cons.h"
#include "env.h"
#include "vector.h"

typedef struct llclosure_s {
  LLIS_OBJECT;
  LLString *bytecode;
  LLVector *objects;
  LLCons *arglist; 
  LLEnv *env;
} LLClosure;

typedef struct llcfunc_s {
  LLIS_OBJECT;
  void (*func)();
  char *name;
} LLCfunc;

extern LLTag llclosure_t;
extern LLTag llcfunc_t;

#define llis_closure(obj) (llobj_tag(obj)==llclosure_t)
#define llis_cfunc(obj) (llobj_tag(obj)==llcfunc_t)

LLClosure *llmake_closure();
void llinit_closure();
void llapply();			/* Apply a closure or C func */
void llregister_cfunc();	/* Add a C function to scheme */

#endif _CLOSURE_INC



