/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _DELAY_INC 
#define _DELAY_INC 

#include "obj.h"
#include "closure.h"

typedef enum lldelaystate_e {
  LLDELAYED, 
  LLFORCED
} LLDelayState;
 
typedef struct lldelay_s {
  LLIS_OBJECT;
  LLDelayState state; 
  union {
    LLClosure *delay; 
    LLObj *forced_value; 
  } value;
} LLDelay;

extern LLTag lldelay_t;

#define llis_delay(obj) (llobj_tag(obj) == lldelay_t)

#endif 
