/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#define GC

#include "obj.h"
#include "gc.h"
#include "mem.h"
#include "env.h"
#include "cont.h"
#include "stream.h"

#define GC_FLAG 0x8000
#define gc_is_useful(obj) ((obj)->_type & GC_FLAG)
#define unset_gc_flag(obj) (obj)->_type &= 0x7FFF
#define touch_root_env_pals()  lltouch_obj((LLObj *) root)

#define HEAP_WATCH_START 10000	/* Begin GCing after heap exceeds this size */
#define HEAP_WATCH_INCREMENT 500 /* Then push the ceiling up by this much */

/* This is a soft ceiling... it is raised as more space is needed */
static long heap_ceiling = HEAP_WATCH_START; 
static LLCons* protected_objs;

void llcctouch_obj(obj)		/* sets gc_flag */
     LLObj *obj;
{
  if (!gc_is_useful(obj)) {
    obj->_type |= GC_FLAG;	/* high bit of tag is gc flag */
    object_tds[llobj_tag((LLObj *)obj)]->touchfunc(obj);
  }
}

long llcheap_ceiling()
{
  return heap_ceiling;
}

static void gc()
{
  llstrprintf(s_stderr, "(Garbage Collecting..."); 
  llcstrflush(s_stderr);
  touch_root_pals();		/* mark */
  sweep_objs();
  while (heap_ceiling < llheap.objnext)
    heap_ceiling += HEAP_WATCH_INCREMENT;
  llstrprintf(s_stderr, "done)\n");
}

void llcmaybe_gc()
{
  if (llheap.objnext >= heap_ceiling)
    gc();
}

llgc() 
{
  lllastarg();
  gc();
  llpusharg(T);
}

void llinit_gc()
{
  protected_objs = (LLCons*)NIL;
  llregister_cfunc(llgc, "gc");
}


touch_root_pals()
{
  lltouch_obj((LLObj *) protected_objs);
  lltouch_obj((LLObj *) llcur_cont);
  touch_root_env_pals();
}

llfree_obj (obj)
     LLObj *obj;
{
  object_tds[llobj_tag((LLObj *)obj)]->freefunc(obj);
  free(obj);
}

llpush_protected_obj(obj)
     LLObj* obj;
{
  protected_objs = llcmake_cons(obj, protected_objs);
}

llpop_protected_obj(obj)
     LLObj* obj;
{
  if(protected_objs == (LLCons*)NIL || llccar(protected_objs) != obj)
    llperror(LLINTERNAL_ERROR, "inconsistent protected object list");
  else 
    protected_objs = (LLCons*)llccdr(protected_objs);
}

sweep_objs()
{
  long i;
  LLObj **cur, **store; 
  
  cur = store = llheap.objects;
  for (i = 0 ; i < llheap.objnext; cur++, i++) {
    if(gc_is_useful(*cur)) {
      unset_gc_flag(*cur);
      *(store++) = *cur; 
    } else 
      llfree_obj(*cur);
  }
  llheap.objnext = (long) (store - llheap.objects);
}
