/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#ifndef _NUM_INC
#define _NUM_INC

#include "obj.h"

typedef struct llnum_s {	/* Number structure... */
  LLIS_OBJECT;			/* Yes, a scheme object. */
  double value;			/* and its value ... */
} LLNum;

extern LLTag llnum_t;		/* Tag number for numbers ! */

void llinit_num();
LLNum *llread_num();
LLNum *lldouble_to_num();
#define llnum_to_double(num) (((LLNum*) num)->value)
#define llnum_to_long(num) ((long) llnum_to_double(num))
#define lllong_to_num(num) (lldouble_to_num((double) num))

typedef enum llmathtype_e {
  NUM_ADD,
  NUM_SUB,
  NUM_MUL,
  NUM_DIV,
} LLMathType ;

typedef enum llcomparetype_e { 
  NUM_EQ,
  NUM_LT, 
  NUM_GT, 
  NUM_LE,
  NUM_GE,
  NUM_NE
    
} LLCompareType ;
#endif
