/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include <ctype.h>
#include "obj.h"
#include "stream.h"
#include "cons.h"
#include "num.h"

static LLObj *read_number_thingy(stream)
     LLStream *stream;
{
  char c;
  
  c = llread_stream(stream);
  switch(c) {
  case 't': return T;
  case 'f': return LLFALSE;  /* under revised 4, this is the same as nil */
  default: llerror(LLREAD_ERROR);
  }
}

int llread_nonspace(stream)
     LLStream* stream;
{
  int c;
  int stop = 1;
  do {
    stop = 0;
    while ((c = llread_stream(stream)) != EOF && isspace(c));
    if (c  == ';') {
      while((llread_stream(stream) != '\n'));
      stop = 1;
    }

  } while(stop);
  return  c;
}

LLObj *llread_obj (stream)
     LLStream *stream;
{
  int c, c2;
  LLNum *num;

  c = llread_nonspace(stream);

  if (c == EOF) return NULL;
  if (c == '(') return((LLObj *)llread_cons(stream));
  if (c == '"') return((LLObj *)llread_string(stream));
  if (c == '\'') 
    return ((LLObj *) llcmake_cons(llcstring_to_sym("quote"), 
				   llcmake_cons(llread_obj(stream), NIL)));
  if (c == '-') {
    llunread_stream(stream, (unsigned char)(c2 = llread_stream(stream)));
    if (isdigit(c2)) {
      num = llread_num(stream);
      num->value = -num->value;
      return (LLObj *) num;
    } else
      return (LLObj *) llcstring_to_sym("-");
  }
  if (c == '#') 
    return read_number_thingy(stream);
  if (c == ')') 
    llerror(LLMISMATCHED_PAREN);
  llunread_stream(stream, (unsigned char)c);
  if (isdigit(c)) 
    return (LLObj *) llread_num(stream);
  return (LLObj *) llread_sym(stream); /* Hmmm.. must be a symbol */
}



llinit_read()
{
}
