(define (button-callback) (print "Text: "(invoke editor wm-get-text) nl))

(define main-window (make-main-window))  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; first make the main window

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; make a menubar.  menustructure essentially specifies the whole menu structure
(define (noop)
  (print "if you think this has been implemented, you're biffed" nl))

(define menustructure 
  (list 
   (list "File"
	 (list "Print" button-callback)
   	 wm-menu-blank
	 (list "Quit" exit)
	 )
   (list "Edit"
	 (list "Undo" noop)
	 wm-menu-line
	 (list "Cut" noop)
	 (list "Copy" noop)
	 (list "Paste" noop)
	 )
   ))

(define menubar (make-menubar main-window menustructure))  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; make the menubar

(define swindow (make-scrollingwindow main-window)) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; make everything else inside a scrolling window

(define box (make-tackboard swindow))  ;; swindow scrolls this tackboard which really holds everything else

(define label (make-label box))  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; add a label ;;;;;;;;;;;;;;;;;;;;
(invoke label wm-set-label "Resize Me") 
(invoke box wm-set-child-position label 180 180)

(define button1 (make-pushbutton box))  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;  add a couple buttons
(define button2 (make-pushbutton box))
(define button3 (make-pushbutton box))

(invoke button1 wm-set-label "print contents of editor")  ;; set the text of button1
(invoke button1 wm-set-callback button-callback)   ;; set what function will be invoked by button1

(invoke box wm-set-child-position button2 400 400 )  ;; move button2
(invoke button2 wm-set-label "scheme mode")  ;; set the text of button2
(invoke button2 wm-set-callback              ;; set what function will be invoked by button2
	(lambda () (whoopie-main-loop-return t)))

(invoke button3 wm-set-label "show dialog")  
(invoke button3 wm-set-callback 
	(lambda () (print (invoke dialog wm-popup) nl)))  ;; popup the dialog (blocking) then print what the user typed

(define dialog (make-dialogbox main-window)) ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; make the dialog box that button3 pops up
(invoke dialog wm-set-message "hello")  ;; set the message to be hello


(define editor (make-texteditor box))  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; and an editor ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(invoke editor wm-set-text "type in here") ;; set the initial string in the editor
(invoke box wm-set-keyboard-focus editor)

(define listwob (make-list box))   ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; finally, a list wob ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(invoke listwob wm-set-contents '(1 "test" 2 3 "test2"))  ;;;;;;;;;;;; make this the contents.
(invoke box wm-set-child-position listwob 10 100)

;; position the buttons and editor
(invoke box wm-vertical-tack menubar swindow)
(invoke box wm-vertical-tack button1 editor)
(invoke box wm-vertical-tack button2 button3)

(define go whoopie-main-loop)
(print "type (go) to start it" nl)

