#include <mit-copyright.h>
#include <krb.h>
#include <fxserver_err.h>
#include <sys/time.h>
#define PTRFILELEN 64
#define COURSE_NAME_LEN 32
#define MAX_BURST_SIZE 10240

enum PaperType {
	TYPE_WILDCARD = 0,
	TURNEDIN = 1,
	TAKEN = 2,
	GRADED = 3,
	PICKEDUP = 4,
	HANDOUT = 5,
	EXCHANGE = 6,
	TEACHERS_ARCHIVE = 7,
	TEACHERS_HANDOUT = 8
};
typedef enum PaperType PaperType;
bool_t xdr_PaperType();

#define ASSIGNMENT_WILDCARD 0
#define AUTHOR_WILDCARD "*"
#define OWNER_WILDCARD "*"
#define FILENAME_WILDCARD "*"
#define ID_WILDCARD "*"
#define PAPER_EXECUTABLE 1

struct fx_timeval {
	long tv_sec;
	long tv_usec;
};
typedef struct fx_timeval fx_timeval;
bool_t xdr_fx_timeval();


struct PaperID {
	char *host;
	struct fx_timeval time;
};
typedef struct PaperID PaperID;
bool_t xdr_PaperID();


struct Paper {
	PaperID location;
	PaperType type;
	int assignment;
	char *author;
	char *owner;
	char *filename;
	char *desc;
	struct fx_timeval created;
	struct fx_timeval modified;
	int size;
	int words;
	int lines;
	int flags;
};
typedef struct Paper Paper;
bool_t xdr_Paper();


struct Contents {
	Paper p;
	char ptrfile[64];
};
typedef struct Contents Contents;
bool_t xdr_Contents();


struct init_data {
	char *course;
	KTEXT_ST auth;
};
typedef struct init_data init_data;
bool_t xdr_init_data();


struct acl_maint {
	char *aclname;
	char *aclparam;
};
typedef struct acl_maint acl_maint;
bool_t xdr_acl_maint();


struct burst_data {
	int size;
	char data[10240];
};
typedef struct burst_data burst_data;
bool_t xdr_burst_data();


struct TwoPaper {
	Paper src;
	Paper dest;
};
typedef struct TwoPaper TwoPaper;
bool_t xdr_TwoPaper();


struct portionspec {
	Paper p;
	int start;
	int end;
};
typedef struct portionspec portionspec;
bool_t xdr_portionspec();


enum SyncStat {
	NO_SYNC = 0,
	WANT_SYNC = 1,
	AM_SYNC = 2
};
typedef enum SyncStat SyncStat;
bool_t xdr_SyncStat();


struct quorumstat {
	SyncStat sync;
};
typedef struct quorumstat quorumstat;
bool_t xdr_quorumstat();


struct DBVers {
	long synctime;
	long commit;
};
typedef struct DBVers DBVers;
bool_t xdr_DBVers();


struct init_res {
	long errno;
	union {
		char *sync;
	} init_res_u;
};
typedef struct init_res init_res;
bool_t xdr_init_res();


typedef struct stringnode *stringlist;
bool_t xdr_stringlist();


struct stringnode {
	char *s;
	stringlist next;
};
typedef struct stringnode stringnode;
bool_t xdr_stringnode();


struct stringlist_res {
	long errno;
	union {
		stringlist list;
	} stringlist_res_u;
};
typedef struct stringlist_res stringlist_res;
bool_t xdr_stringlist_res();


typedef struct PaperNode *Paperlist;
bool_t xdr_Paperlist();


struct PaperNode {
	Paper p;
	Paperlist next;
};
typedef struct PaperNode PaperNode;
bool_t xdr_PaperNode();


struct Paperlist_res {
	long errno;
	union {
		Paperlist list;
	} Paperlist_res_u;
};
typedef struct Paperlist_res Paperlist_res;
bool_t xdr_Paperlist_res();


struct retrieve_res {
	long errno;
	union {
		burst_data burst;
	} retrieve_res_u;
};
typedef struct retrieve_res retrieve_res;
bool_t xdr_retrieve_res();


struct krb_info {
	char *service;
	char *instance;
	char *realm;
};
typedef struct krb_info krb_info;
bool_t xdr_krb_info();


struct krb_info_res {
	long errno;
	union {
		krb_info info;
	} krb_info_res_u;
};
typedef struct krb_info_res krb_info_res;
bool_t xdr_krb_info_res();


struct quorum_res {
	int vote;
	DBVers vers;
};
typedef struct quorum_res quorum_res;
bool_t xdr_quorum_res();


struct server_stats {
	long start_time;
	long uptime;
	int num_requests;
	int bytes_sent;
	int bytes_recv;
	int n_init;
	int n_list_acl;
	int n_add_acl;
	int n_delete_acl;
	int n_create_course;
	int n_delete_course;
	int n_list_courses;
	int n_list;
	int n_send_file;
	int n_send_burst;
	int n_end_send;
	int n_retrieve_file;
	int n_retrieve_burst;
	int n_copy;
	int n_move;
	int n_delete;
	int n_portion;
	int n_krb_info;
	int n_kill_server;
	int n_server_stats;
	int n_server_quorum;
	int n_server_store;
	int n_server_delete;
	int n_server_commit;
	int n_server_end_course;
	int n_server_requpdate;
	int n_server_start_upd;
	int n_server_end_upd;
	DBVers vers;
};
typedef struct server_stats server_stats;
bool_t xdr_server_stats();


#define FXSERVER ((u_long)100)
#define FXVERS ((u_long)1)
#define INIT ((u_long)1)
extern init_res *init_1();
#define LIST_ACL ((u_long)2)
extern stringlist_res *list_acl_1();
#define ADD_ACL ((u_long)3)
extern long *add_acl_1();
#define DELETE_ACL ((u_long)4)
extern long *delete_acl_1();
#define CREATE_COURSE ((u_long)10)
extern long *create_course_1();
#define DELETE_COURSE ((u_long)11)
extern long *delete_course_1();
#define LIST_COURSES ((u_long)12)
extern stringlist_res *list_courses_1();
#define LIST ((u_long)15)
extern Paperlist_res *list_1();
#define SEND_FILE ((u_long)16)
extern long *send_file_1();
#define SEND_BURST ((u_long)17)
extern long *send_burst_1();
#define END_SEND ((u_long)18)
extern long *end_send_1();
#define RETRIEVE_FILE ((u_long)19)
extern long *retrieve_file_1();
#define RETRIEVE_BURST ((u_long)20)
extern retrieve_res *retrieve_burst_1();
#define COPY ((u_long)21)
extern long *copy_1();
#define MOVE ((u_long)22)
extern long *move_1();
#define DELETE ((u_long)23)
extern long *delete_1();
#define PORTION ((u_long)24)
extern long *portion_1();
#define KRB_INFO ((u_long)25)
extern krb_info_res *krb_info_1();
#define KILL_SERVER ((u_long)30)
extern long *kill_server_1();
#define SERVER_STATS ((u_long)31)
extern server_stats *server_stats_1();
#define SERVER_QUORUM ((u_long)50)
extern quorum_res *server_quorum_1();
#define SERVER_STORE ((u_long)51)
extern long *server_store_1();
#define SERVER_DELETE ((u_long)52)
extern long *server_delete_1();
#define SERVER_COMMIT ((u_long)53)
extern long *server_commit_1();
#define SERVER_END_COURSE ((u_long)54)
extern long *server_end_course_1();
#define SERVER_REQUPDATE ((u_long)55)
extern long *server_requpdate_1();
#define SERVER_START_UPD ((u_long)56)
extern long *server_start_upd_1();
#define SERVER_END_UPD ((u_long)57)
extern long *server_end_upd_1();

