"""Determine the lastest version of linux-athena."""

import string, glob
lists = glob.glob('/afs/athena/system/rhlinux/control/control-*[0-9]')

versions = []
for list_name in lists:
    prefix, version = string.split(list_name, '-')
    version_numbers = map(int, string.split(version, '.'))
    versions.append(version_numbers)

versions.sort()

latest_major_version = versions[-1]
version_numbers = map(str, latest_major_version)
latest_major_version_string = string.join(version_numbers, '.')

current_version = open('/afs/athena/system/rhlinux/control/control-'+\
                       latest_major_version_string).readlines()[-1]
# latest_version_string = string.split(current_version)[0]
latest_version_string = '9.0.24'
