/**
 ** cmdlineo.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 ** cmdlineo.h
 ** v3.0 Sat Aug 10 19:51:54 1991  Randy Sargent
 **                           put globals into the Cmdline data structure so
 **                           you can have more than one command line
 **/

#ifndef CMDLINEO_H
#define CMDLINEO_H

#include <iob.h>

#define MAXHISTORY 50
#define MAXLEN 1000

extern Int cmd_ansi;

typedef struct cmdline_str {
    IOStream *in;
    FILE     *out;
    char     *history[MAXHISTORY];
    Int      current;
    char     old_line[MAXLEN];
    char     *line;
    Int      pos;
    Int      old_pos;
    
    char     *prompt;
    Int      char_pos;
    Int      repeat, cmd_new;
    Int      meta, cursor, quote;
    Int      look_for_hangup;
    Int      carrier_detected;

} Cmdline;

#define CMDLINE_HANGUP -2

#include "cmdlineo.pro"

#endif   /* #ifndef CMDLINEO_H */


