/**
 ** listcore.h
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/

/**
 **  listcore.h
 **
 ** v1.0  Sun Jun  2 14:01:06 1991  Randy Sargent.  created
 ** v1.1  Mon Aug 12 11:53:04 1991  Randy Sargent.  added ListConstruct
 **/


#ifndef RUN_TIME_TYPING
/*#error Must define RUN_TIME_TYPING to be 0 or 1*/
#endif

typedef struct list_str {
#if RUN_TIME_TYPING
    Runtype runtype;
#endif
    void *car;
    void *cdr;
#ifdef LIST_BAGGAGE    
    LIST_BAGGAGE
#endif      
} List;

typedef List ListConstruct;

#define CAR(l) ((l)->car)
#define LCAR(l) ((List*)((l)->car))
#define CDR(l) ((l)->cdr)
#define LCDR(l) ((List*)((l)->cdr))

#define CADR(l) CAR(LCDR(l))
#define CADDR(l) CAR(LCDR(LCDR(l)))
#define CADDDR(l) CAR(LCDR(LCDR(LCDR(l))))
#define CADDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(l)))))
#define CADDDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(LCDR(l))))))
#define CADDDDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(l)))))))
#define CADDDDDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(l))))))))
#define CADDDDDDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(l)))))))))
#define CADDDDDDDDDR(l) CAR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(LCDR(l))))))))))

#define LIST_NULL(l) ((l) == Nil)

#include "listcore.pro"

#if RUN_TIME_TYPING
void list_display(void *l);
void list_print  (void *l);
char *list_sprint  (void *l);
void list_gc	 (void *o);
#else
void list_display(List *l, void (*displayfunc) (void*));
void list_print  (List *l, void (*printfunc) (void*));
#endif

extern List *Nil;
extern List *Eol;




