/*
 * FILE : pisock_wrap.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 5)
 * 
 * Portions Copyright (c) 1995-1998
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  result->ob_refcnt = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/*****************************************************************************
 * $Header:$
 *
 * swigptr.swg
 *
 * This file contains supporting code for the SWIG run-time type checking
 * mechanism.  The following functions are available :
 *
 * SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *));
 *
 *      Registers a new type-mapping with the type-checker.  origtype is the
 *      original datatype and newtype is an equivalent type.  cast is optional
 *      pointer to a function to cast pointer values between types (this
 *      is typically used to cast pointers from derived classes to base classes in C++)
 *      
 * SWIG_MakePtr(char *buffer, void *ptr, char *typestring);
 *     
 *      Makes a pointer string from a pointer and typestring.  The result is returned
 *      in buffer which is assumed to hold enough space for the result.
 *
 * char * SWIG_GetPtr(char *buffer, void **ptr, char *type)
 *
 *      Gets a pointer value from a string.  If there is a type-mismatch, returns
 *      a character string to the received type.  On success, returns NULL.
 *
 *
 * You can remap these functions by making a file called "swigptr.swg" in
 * your the same directory as the interface file you are wrapping.
 *
 * These functions are normally declared static, but this file can be
 * can be used in a multi-module environment by redefining the symbol
 * SWIGSTATIC.
 *****************************************************************************/

#include <stdlib.h>

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif


/* SWIG pointer structure */

typedef struct SwigPtrType {
  char               *name;               /* Datatype name                  */
  int                 len;                /* Length (used for optimization) */
  void               *(*cast)(void *);    /* Pointer casting function       */
  struct SwigPtrType *next;               /* Linked list pointer            */
} SwigPtrType;

/* Pointer cache structure */

typedef struct {
  int                 stat;               /* Status (valid) bit             */
  SwigPtrType        *tp;                 /* Pointer to type structure      */
  char                name[256];          /* Given datatype name            */
  char                mapped[256];        /* Equivalent name                */
} SwigCacheType;

/* Some variables  */

static int SwigPtrMax  = 64;           /* Max entries that can be currently held */
                                       /* This value may be adjusted dynamically */
static int SwigPtrN    = 0;            /* Current number of entries              */
static int SwigPtrSort = 0;            /* Status flag indicating sort            */
static int SwigStart[256];             /* Starting positions of types            */

/* Pointer table */
static SwigPtrType *SwigPtrTable = 0;  /* Table containing pointer equivalences  */

/* Cached values */

#define SWIG_CACHESIZE  8
#define SWIG_CACHEMASK  0x7
static SwigCacheType SwigCache[SWIG_CACHESIZE];  
static int SwigCacheIndex = 0;
static int SwigLastCache = 0;

/* Sort comparison function */
static int swigsort(const void *data1, const void *data2) {
	SwigPtrType *d1 = (SwigPtrType *) data1;
	SwigPtrType *d2 = (SwigPtrType *) data2;
	return strcmp(d1->name,d2->name);
}

/* Binary Search function */
static int swigcmp(const void *key, const void *data) {
  char *k = (char *) key;
  SwigPtrType *d = (SwigPtrType *) data;
  return strncmp(k,d->name,d->len);
}

/* Register a new datatype with the type-checker */

SWIGSTATIC 
void SWIG_RegisterMapping(char *origtype, char *newtype, void *(*cast)(void *)) {

  int i;
  SwigPtrType *t = 0,*t1;

  /* Allocate the pointer table if necessary */

  if (!SwigPtrTable) {     
    SwigPtrTable = (SwigPtrType *) malloc(SwigPtrMax*sizeof(SwigPtrType));
    SwigPtrN = 0;
  }
  /* Grow the table */
  if (SwigPtrN >= SwigPtrMax) {
    SwigPtrMax = 2*SwigPtrMax;
    SwigPtrTable = (SwigPtrType *) realloc((char *) SwigPtrTable,SwigPtrMax*sizeof(SwigPtrType));
  }
  for (i = 0; i < SwigPtrN; i++)
    if (strcmp(SwigPtrTable[i].name,origtype) == 0) {
      t = &SwigPtrTable[i];
      break;
    }
  if (!t) {
    t = &SwigPtrTable[SwigPtrN];
    t->name = origtype;
    t->len = strlen(t->name);
    t->cast = 0;
    t->next = 0;
    SwigPtrN++;
  }

  /* Check for existing entry */

  while (t->next) {
    if ((strcmp(t->name,newtype) == 0)) {
      if (cast) t->cast = cast;
      return;
    }
    t = t->next;
  }
  
  /* Now place entry (in sorted order) */

  t1 = (SwigPtrType *) malloc(sizeof(SwigPtrType));
  t1->name = newtype;
  t1->len = strlen(t1->name);
  t1->cast = cast;
  t1->next = 0;            
  t->next = t1;           
  SwigPtrSort = 0;
}

/* Make a pointer value string */

SWIGSTATIC 
void SWIG_MakePtr(char *_c, const void *_ptr, char *type) {
  static char _hex[16] =
  {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
   'a', 'b', 'c', 'd', 'e', 'f'};
  unsigned long _p, _s;
  char _result[20], *_r;    /* Note : a 64-bit hex number = 16 digits */
  _r = _result;
  _p = (unsigned long) _ptr;
  if (_p > 0) {
    while (_p > 0) {
      _s = _p & 0xf;
      *(_r++) = _hex[_s];
      _p = _p >> 4;
    }
    *_r = '_';
    while (_r >= _result)
      *(_c++) = *(_r--);
  } else {
    strcpy (_c, "NULL");
  }
  if (_ptr)
    strcpy (_c, type);
}

/* Define for backwards compatibility */

#define _swig_make_hex   SWIG_MakePtr 

/* Function for getting a pointer value */

SWIGSTATIC 
char *SWIG_GetPtr(char *_c, void **ptr, char *_t)
{
  unsigned long _p;
  char temp_type[256];
  char *name;
  int  i, len;
  SwigPtrType *sp,*tp;
  SwigCacheType *cache;
  int  start, end;
  _p = 0;

  /* Pointer values must start with leading underscore */
  if (*_c == '_') {
      _c++;
      /* Extract hex value from pointer */
      while (*_c) {
	  if ((*_c >= '0') && (*_c <= '9'))
	    _p = (_p << 4) + (*_c - '0');
	  else if ((*_c >= 'a') && (*_c <= 'f'))
	    _p = (_p << 4) + ((*_c - 'a') + 10);
	  else
	    break;
	  _c++;
      }

      if (_t) {
	if (strcmp(_t,_c)) { 
	  if (!SwigPtrSort) {
	    qsort((void *) SwigPtrTable, SwigPtrN, sizeof(SwigPtrType), swigsort); 
	    for (i = 0; i < 256; i++) {
	      SwigStart[i] = SwigPtrN;
	    }
	    for (i = SwigPtrN-1; i >= 0; i--) {
	      SwigStart[(int) (SwigPtrTable[i].name[1])] = i;
	    }
	    for (i = 255; i >= 1; i--) {
	      if (SwigStart[i-1] > SwigStart[i])
		SwigStart[i-1] = SwigStart[i];
	    }
	    SwigPtrSort = 1;
	    for (i = 0; i < SWIG_CACHESIZE; i++)  
	      SwigCache[i].stat = 0;
	  }
	  
	  /* First check cache for matches.  Uses last cache value as starting point */
	  cache = &SwigCache[SwigLastCache];
	  for (i = 0; i < SWIG_CACHESIZE; i++) {
	    if (cache->stat) {
	      if (strcmp(_t,cache->name) == 0) {
		if (strcmp(_c,cache->mapped) == 0) {
		  cache->stat++;
		  *ptr = (void *) _p;
		  if (cache->tp->cast) *ptr = (*(cache->tp->cast))(*ptr);
		  return (char *) 0;
		}
	      }
	    }
	    SwigLastCache = (SwigLastCache+1) & SWIG_CACHEMASK;
	    if (!SwigLastCache) cache = SwigCache;
	    else cache++;
	  }
	  /* We have a type mismatch.  Will have to look through our type
	     mapping table to figure out whether or not we can accept this datatype */

	  start = SwigStart[(int) _t[1]];
	  end = SwigStart[(int) _t[1]+1];
	  sp = &SwigPtrTable[start];
	  while (start < end) {
	    if (swigcmp(_t,sp) == 0) break;
	    sp++;
	    start++;
	  }
	  if (start >= end) sp = 0;
	  /* Try to find a match for this */
	  if (sp) {
	    while (swigcmp(_t,sp) == 0) {
	      name = sp->name;
	      len = sp->len;
	      tp = sp->next;
	      /* Try to find entry for our given datatype */
	      while(tp) {
		if (tp->len >= 255) {
		  return _c;
		}
		strcpy(temp_type,tp->name);
		strncat(temp_type,_t+len,255-tp->len);
		if (strcmp(_c,temp_type) == 0) {
		  
		  strcpy(SwigCache[SwigCacheIndex].mapped,_c);
		  strcpy(SwigCache[SwigCacheIndex].name,_t);
		  SwigCache[SwigCacheIndex].stat = 1;
		  SwigCache[SwigCacheIndex].tp = tp;
		  SwigCacheIndex = SwigCacheIndex & SWIG_CACHEMASK;
		  
		  /* Get pointer value */
		  *ptr = (void *) _p;
		  if (tp->cast) *ptr = (*(tp->cast))(*ptr);
		  return (char *) 0;
		}
		tp = tp->next;
	      }
	      sp++;
	      /* Hmmm. Didn't find it this time */
	    }
	  }
	  /* Didn't find any sort of match for this data.  
	     Get the pointer value and return the received type */
	  *ptr = (void *) _p;
	  return _c;
	} else {
	  /* Found a match on the first try.  Return pointer value */
	  *ptr = (void *) _p;
	  return (char *) 0;
	}
      } else {
	/* No type specified.  Good luck */
	*ptr = (void *) _p;
	return (char *) 0;
      }
  } else {
    if (strcmp (_c, "NULL") == 0) {
	*ptr = (void *) 0;
	return (char *) 0;
    }
    *ptr = (void *) 0;	
    return _c;
  }
}

/* Compatibility mode */

#define _swig_get_hex  SWIG_GetPtr

#define SWIG_init    initpisock

#define SWIG_name    "pisock"

#include <time.h>
#ifdef INCLUDE_LIBPISOCK
#include "libpisock/pi-socket.h"
#include "libpisock/pi-dlp.h"
#else
#include "pi-socket.h"
#include "pi-dlp.h"
#endif /* INCLUDE_LIBPISOCK */
    
extern char *printlong(unsigned long);
extern unsigned long makelong(char *c);

void *__dlp_buf;

#define DLPMAXBUF 0xFFFF 

#define DGETLONG(src,key,default) (PyDict_GetItemString(src,key) ? PyInt_AsLong(PyDict_GetItemString(src,key)) : default)
#define DGETSTR(src,key,default) (PyDict_GetItemString(src,key) ? PyString_AsString(PyDict_GetItemString(src,key)) : default)

typedef int DLPERROR;
typedef int DLPDBERROR;

static PyObject *Error;

static PyObject* l_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;
    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyList_Check(target)) {
            o2 = target;
            target = PyList_New(0);
            PyList_Append(target, o2);
	    Py_XDECREF(o2);
        }
        PyList_Append(target,o);
	Py_XDECREF(o);
    }
    return target;
}

static PyObject* t_output_helper(PyObject* target, PyObject* o) {
    PyObject*   o2;
    PyObject*   o3;

    if (!target) {                   
        target = o;
    } else if (target == Py_None) {  
        Py_DECREF(Py_None);
        target = o;
    } else {                         
        if (!PyTuple_Check(target)) {
            o2 = target;
            target = PyTuple_New(1);
            PyTuple_SetItem(target, 0, o2);
        }
        o3 = PyTuple_New(1);            
        PyTuple_SetItem(o3, 0, o);      

        o2 = target;
        target = PySequence_Concat(o2, o3); 
        Py_DECREF(o2);                      
        Py_DECREF(o3);
    }
    return target;
}
extern int pi_socket(int ,int ,int );
extern int pi_connect(int ,struct sockaddr *,int );
extern int pi_bind(int ,struct sockaddr *,int );
extern int pi_listen(int ,int );
extern int pi_accept(int ,struct sockaddr *,int *);
extern int pi_accept_to(int ,struct sockaddr *,int *,int );
extern int pi_send(int ,void *,int ,unsigned int );
extern int pi_recv(int ,void *,int ,unsigned int );
extern int pi_read(int ,void *,int );
extern int pi_write(int ,void *,int );
extern int pi_getsockname(int ,struct sockaddr *,int *);
extern int pi_getsockpeer(int ,struct sockaddr *,int *);
extern int pi_setmaxspeed(int ,int ,int );
extern int pi_getsockopt(int ,int ,int ,void *,int *);
extern int pi_version(int );
extern int pi_tickle(int );
extern int pi_watchdog(int ,int );
extern int pi_close(int );
extern char * dlp_errorlist[]; 
extern char *dlp_strerror(int );
extern DLPERROR dlp_GetSysDateTime(int ,time_t *);
extern DLPERROR dlp_SetSysDateTime(int ,time_t );
extern DLPERROR dlp_ReadStorageInfo(int ,int ,struct CardInfo *);
extern DLPERROR dlp_ReadSysInfo(int ,struct SysInfo *);
extern DLPERROR dlp_ReadDBList(int ,int ,int ,int ,struct DBInfo *);
extern DLPERROR dlp_FindDBInfo(int ,int ,int ,char *,unsigned long ,unsigned long ,struct DBInfo *);
extern DLPERROR dlp_OpenDB(int ,int ,int ,char *,int *);
extern DLPERROR dlp_CloseDB(int ,int );
extern DLPERROR dlp_CloseDB_All(int );
extern DLPERROR dlp_DeleteDB(int ,int ,const char *);
extern DLPERROR dlp_CreateDB(int ,long ,long ,int ,int ,int ,const char *,int *);
extern DLPERROR dlp_ResetSystem(int );
extern DLPERROR dlp_AddSyncLogEntry(int ,char *);
extern DLPERROR dlp_OpenConduit(int );
extern DLPERROR dlp_EndOfSync(int ,int );
extern DLPERROR dlp_AbortSync(int );
extern DLPERROR dlp_ReadOpenDBInfo(int ,int ,int *);
extern DLPERROR dlp_MoveCategory(int ,int ,int ,int );
extern DLPERROR dlp_WriteUserInfo(int ,struct PilotUser *);
extern DLPERROR dlp_ReadUserInfo(int ,struct PilotUser *);
extern DLPERROR dlp_ResetLastSyncPC(int );
extern DLPERROR dlp_WriteAppBlock(int ,int ,const void *,int );
extern DLPERROR dlp_WriteSortBlock(int ,int ,const void *,int );
extern DLPERROR dlp_ResetDBIndex(int ,int );
extern DLPDBERROR dlp_WriteRecord(int ,int ,int ,recordid_t ,int ,void *,int ,recordid_t *);
extern DLPERROR dlp_DeleteRecord(int ,int ,int ,recordid_t );
extern DLPERROR dlp_DeleteCategory(int ,int ,int );
extern DLPDBERROR dlp_ReadResourceByType(int ,int ,unsigned long ,int ,void *,int *,int *);
extern DLPDBERROR dlp_ReadResourceByIndex(int ,int ,int ,void *,unsigned long *,int *,int *);
extern DLPDBERROR dlp_WriteResource(int ,int ,unsigned long ,int ,const void *,int );
extern DLPERROR dlp_DeleteResource(int ,int ,int ,unsigned long ,int );
extern DLPDBERROR dlp_ReadNextModifiedRec(int ,int ,void *,recordid_t *,int *,int *,int *,int *);
extern DLPDBERROR dlp_ReadNextModifiedRecInCategory(int ,int ,int ,void *,recordid_t *,int *,int *,int *);
extern DLPDBERROR dlp_ReadNextRecInCategory(int ,int ,int ,void *,recordid_t *,int *,int *,int *);
extern DLPDBERROR dlp_ReadRecordById(int ,int ,recordid_t ,void *,int *,int *,int *,int *);
extern DLPDBERROR dlp_ReadRecordByIndex(int ,int ,int ,void *,recordid_t *,int *,int *,int *);
extern DLPERROR dlp_CleanUpDatabase(int ,int );
extern DLPERROR dlp_ResetSyncFlags(int ,int );
extern DLPERROR dlp_ReadFeature(int ,unsigned long ,unsigned int ,unsigned long *);
extern DLPERROR dlp_ReadNetSyncInfo(int ,struct NetSyncInfo *);
extern DLPERROR dlp_WriteNetSyncInfo(int ,struct NetSyncInfo *);
extern DLPERROR dlp_ReadAppPreference(int ,unsigned long ,int ,int ,int ,void *,int *,int *);
extern DLPERROR dlp_WriteAppPreference(int ,unsigned long ,int ,int ,int ,void *,int );


#define PYCFUNC(x) static PyObject *x (PyObject *self, PyObject *args)

PYCFUNC(_wrap_dlp_ReadAppBlock) {
    int a0, a1, a2;
    int ret;
    PyObject *o;
    
    if (!PyArg_ParseTuple(args,"iii", &a0, &a1, &a2))
	return NULL;

    ret = dlp_ReadAppBlock(a0, a1, a2, __dlp_buf, DLPMAXBUF);
    if (ret < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", ret, dlp_strerror(ret)));
	return NULL;
    } else if (ret > 0) {
	o = Py_BuildValue("s#", __dlp_buf, ret);
    } else {
	o = Py_None;
	Py_INCREF(Py_None);
    }
    return o;
}

PYCFUNC(_wrap_dlp_ReadSortBlock) {
    int a0, a1, a2;
    int ret;
    PyObject *o;
    
    if (!PyArg_ParseTuple(args,"iii", &a0, &a1, &a2))
	return NULL;

    ret = dlp_ReadSortBlock(a0, a1, a2, __dlp_buf, DLPMAXBUF);
    if (ret < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", ret, dlp_strerror(ret)));
	return NULL;
    } else if (ret > 0) {
	o = Py_BuildValue("s#", __dlp_buf, ret);
    } else {
	o = Py_None;
	Py_INCREF(Py_None);
    }
    return o;
}

/* sd, dbf, sort, start, max, recordid_t *IDS, int *count
 */
PYCFUNC(_wrap_dlp_ReadRecordIDList) {
    int sd, dbf, sort, start, max;
    int ret;
    recordid_t *buf;
    int count, i;
    PyObject *list;
    
    if (!PyArg_ParseTuple(args, "iiiii", &sd, &dbf, &sort, &start, &max))
	return NULL;

/* this is a rather simplistic wrapper.  if max is too big, we just
 * refuse to do it; we don't loop, figuring that that is the job of
 * the python wrapper.
 */
    if (max > (0xFFFF/sizeof(recordid_t))) {
	PyErr_SetString(PyExc_ValueError, "can only return about 64k worth of ids at once");
	return NULL;
    }

    buf = (recordid_t *)__dlp_buf;
    ret = dlp_ReadRecordIDList(sd, dbf, sort, start, max, buf, &count);

    if (ret < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", ret, dlp_strerror(ret)));
	return NULL;
    } else {
	list = PyList_New(0);
	for (i=0; i<count; i++)
	    PyList_Append(list, PyInt_FromLong((long)buf[i]));
	return list;
    }
}


static PyObject *_wrap_pi_socket(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:pi_socket",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (int )pi_socket(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_connect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    int  _arg2;
    PyObject * _obj1 = 0;

    self = self;
{
    _arg2 = sizeof(struct pi_sockaddr);
}
    if(!PyArg_ParseTuple(args,"iO:pi_connect",&_arg0,&_obj1)) 
        return NULL;
{
    static struct pi_sockaddr temp;
    char *dev;

    if (!PyArg_ParseTuple(_obj1, "is", &temp.pi_family, &dev)) {
	return NULL;
    }

    strncpy(temp.pi_device, dev, 13);
    temp.pi_device[13] = 0;

    _arg1 = (struct sockaddr *)&temp;
}
    _result = (int )pi_connect(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_bind(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    int  _arg2;
    PyObject * _obj1 = 0;

    self = self;
{
    _arg2 = sizeof(struct pi_sockaddr);
}
    if(!PyArg_ParseTuple(args,"iO:pi_bind",&_arg0,&_obj1)) 
        return NULL;
{
    static struct pi_sockaddr temp;
    char *dev;

    if (!PyArg_ParseTuple(_obj1, "is", &temp.pi_family, &dev)) {
	return NULL;
    }

    strncpy(temp.pi_device, dev, 13);
    temp.pi_device[13] = 0;

    _arg1 = (struct sockaddr *)&temp;
}
    _result = (int )pi_bind(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_listen(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:pi_listen",&_arg0,&_arg1)) 
        return NULL;
    _result = (int )pi_listen(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_accept(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    struct pi_sockaddr  temp;
    int * _arg2;
    int  temp0;

    self = self;
{
    _arg1 = (struct sockaddr *)&temp;
}
{
  _arg2 = &temp0;
}
    if(!PyArg_ParseTuple(args,"i:pi_accept",&_arg0)) 
        return NULL;
    _result = (int )pi_accept(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
{
    PyObject *o;

    if (_arg1) {
	o = Py_BuildValue("(is)", (int)((struct pi_sockaddr *)_arg1)->pi_family,
			  ((struct pi_sockaddr *)_arg1)->pi_device);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_pi_accept_to(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    struct pi_sockaddr  temp;
    int * _arg2;
    int  temp0;
    int  _arg3;

    self = self;
{
    _arg1 = (struct sockaddr *)&temp;
}
{
  _arg2 = &temp0;
}
    if(!PyArg_ParseTuple(args,"ii:pi_accept_to",&_arg0,&_arg3)) 
        return NULL;
    _result = (int )pi_accept_to(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
{
    PyObject *o;

    if (_arg1) {
	o = Py_BuildValue("(is)", (int)((struct pi_sockaddr *)_arg1)->pi_family,
			  ((struct pi_sockaddr *)_arg1)->pi_device);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_pi_send(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    void * _arg1;
    int  _arg2;
    unsigned int  _arg3;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isii:pi_send",&_arg0,&_argc1,&_arg2,&_arg3)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of pi_send. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )pi_send(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_recv(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    void * _arg1;
    int  _arg2;
    unsigned int  _arg3;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isii:pi_recv",&_arg0,&_argc1,&_arg2,&_arg3)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of pi_recv. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )pi_recv(_arg0,_arg1,_arg2,_arg3);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_read(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    void * _arg1;
    int  _arg2;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isi:pi_read",&_arg0,&_argc1,&_arg2)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of pi_read. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )pi_read(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_write(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    void * _arg1;
    int  _arg2;
    char * _argc1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"isi:pi_write",&_arg0,&_argc1,&_arg2)) 
        return NULL;
    if (_argc1) {
        if (SWIG_GetPtr(_argc1,(void **) &_arg1,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 2 of pi_write. Expected _void_p.");
        return NULL;
        }
    }
    _result = (int )pi_write(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_getsockname(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    struct pi_sockaddr  temp;
    int * _arg2;
    int  temp0;

    self = self;
{
    _arg1 = (struct sockaddr *)&temp;
}
{
  _arg2 = &temp0;
}
    if(!PyArg_ParseTuple(args,"i:pi_getsockname",&_arg0)) 
        return NULL;
    _result = (int )pi_getsockname(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
{
    PyObject *o;

    if (_arg1) {
	o = Py_BuildValue("(is)", (int)((struct pi_sockaddr *)_arg1)->pi_family,
			  ((struct pi_sockaddr *)_arg1)->pi_device);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_pi_getsockpeer(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    struct sockaddr * _arg1;
    struct pi_sockaddr  temp;
    int * _arg2;
    int  temp0;

    self = self;
{
    _arg1 = (struct sockaddr *)&temp;
}
{
  _arg2 = &temp0;
}
    if(!PyArg_ParseTuple(args,"i:pi_getsockpeer",&_arg0)) 
        return NULL;
    _result = (int )pi_getsockpeer(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
{
    PyObject *o;

    if (_arg1) {
	o = Py_BuildValue("(is)", (int)((struct pi_sockaddr *)_arg1)->pi_family,
			  ((struct pi_sockaddr *)_arg1)->pi_device);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_pi_setmaxspeed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:pi_setmaxspeed",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (int )pi_setmaxspeed(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_getsockopt(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    void * _arg3;
    int * _arg4;
    char * _argc3 = 0;
    char * _argc4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iiiss:pi_getsockopt",&_arg0,&_arg1,&_arg2,&_argc3,&_argc4)) 
        return NULL;
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of pi_getsockopt. Expected _void_p.");
        return NULL;
        }
    }
    if (_argc4) {
        if (SWIG_GetPtr(_argc4,(void **) &_arg4,"_int_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 5 of pi_getsockopt. Expected _int_p.");
        return NULL;
        }
    }
    _result = (int )pi_getsockopt(_arg0,_arg1,_arg2,_arg3,_arg4);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_version(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:pi_version",&_arg0)) 
        return NULL;
    _result = (int )pi_version(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_tickle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:pi_tickle",&_arg0)) 
        return NULL;
    _result = (int )pi_tickle(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_watchdog(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:pi_watchdog",&_arg0,&_arg1)) 
        return NULL;
    _result = (int )pi_watchdog(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_pi_close(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:pi_close",&_arg0)) 
        return NULL;
    _result = (int )pi_close(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static int _wrap_dlp_errorlist_set(PyObject *val) {

    PyErr_SetString(PyExc_TypeError,"Variable dlp_errorlist is read-only.");
    return 1;
}

static PyObject *_wrap_dlp_errorlist_get() {
    PyObject * pyobj;
    char ptemp[128];

    SWIG_MakePtr(ptemp, (char *) dlp_errorlist,"_char_pp");
    pyobj = PyString_FromString(ptemp);
    return pyobj;
}

static PyObject *_wrap_dlp_strerror(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_strerror",&_arg0)) 
        return NULL;
    _result = (char *)dlp_strerror(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_dlp_GetSysDateTime(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    time_t * _arg1;
    long  temp;

    self = self;
{
  _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"i:dlp_GetSysDateTime",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_GetSysDateTime(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg1));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_SetSysDateTime(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    time_t * _arg1;
    long  temp;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iO:dlp_SetSysDateTime",&_arg0,&_obj1)) 
        return NULL;
{
  temp = (long) PyInt_AsLong(_obj1);
  _arg1 = &temp;
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_SetSysDateTime(_arg0,*_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadStorageInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    struct CardInfo * _arg2;
    struct CardInfo  temp;

    self = self;
{
    _arg2 = &temp;
}
    if(!PyArg_ParseTuple(args,"ii:dlp_ReadStorageInfo",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadStorageInfo(_arg0,_arg1,_arg2);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;

    if (_arg2) {
	o = Py_BuildValue("{sisislslslslsssssi}",
			  "card", _arg2->card,
			  "version", _arg2->version,
			  "creation", _arg2->creation,
			  "romSize", _arg2->romSize,
			  "ramSize", _arg2->ramSize,
			  "ramFree", _arg2->ramFree,
			  "name", _arg2->name,
			  "manufacturer", _arg2->manufacturer,
			  "more", _arg2->more);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadSysInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    struct SysInfo * _arg1;
    struct SysInfo  temp;

    self = self;
{
    _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"i:dlp_ReadSysInfo",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadSysInfo(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    
    if (_arg1) {
	o = Py_BuildValue("{slslss#}",
			  "romVersion", _arg1->romVersion,
			  "locale", _arg1->locale,
			  "name", _arg1->name, _arg1->nameLength);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadDBList(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    struct DBInfo * _arg4;
    struct DBInfo  temp;

    self = self;
{
    _arg4 = &temp;
}
    if(!PyArg_ParseTuple(args,"iiii:dlp_ReadDBList",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadDBList(_arg0,_arg1,_arg2,_arg3,_arg4);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;

    if (_arg4) {
	o = Py_BuildValue("{sisisisOsOsislslslslsisssisisisisisisisi}",
			  "more", _arg4->more,
			  "flags", _arg4->flags,
			  "miscFlags", _arg4->miscFlags,
			  "type", PyString_FromStringAndSize(printlong(_arg4->type), 4),
			  "creator", PyString_FromStringAndSize(printlong(_arg4->creator), 4),
			  "version", _arg4->version,
			  "modnum", _arg4->modnum,
			  "createDate", _arg4->createDate,
			  "modifyDate", _arg4->modifyDate,
			  "backupDate", _arg4->backupDate,
			  "index", _arg4->index,
			  "name", _arg4->name,

			  "flagResource", !!(_arg4->flags & dlpDBFlagResource),
			  "flagReadOnly", !!(_arg4->flags & dlpDBFlagReadOnly),
			  "flagAppInfoDirty", !!(_arg4->flags & dlpDBFlagAppInfoDirty),
			  "flagBackup", !!(_arg4->flags & dlpDBFlagBackup),
			  "flagOpen", !!(_arg4->flags & dlpDBFlagOpen),
			  "flagNewer", !!(_arg4->flags & dlpDBFlagNewer),
			  "flagReset", !!(_arg4->flags & dlpDBFlagReset),
			  "flagExcludeFromSync", !!(_arg4->miscFlags & dlpDBMiscFlagExcludeFromSync));
	_resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_FindDBInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    unsigned long  _arg4;
    unsigned long  _arg5;
    struct DBInfo * _arg6;
    struct DBInfo  temp;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;
    PyObject * _obj5 = 0;

    self = self;
{
    _arg6 = &temp;
}
    if(!PyArg_ParseTuple(args,"iiiOOO:dlp_FindDBInfo",&_arg0,&_arg1,&_arg2,&_obj3,&_obj4,&_obj5)) 
        return NULL;
{
    if (!(_obj3) || (_obj3 == Py_None)) {
	_arg3 = NULL;
    } else {
	_arg3 = PyString_AsString(_obj3);
    }
}
{
    if (!(_obj4) || (_obj4 == Py_None)) {
	_arg4 = 0;
    } else {
	if (!PyString_Check(_obj4) || (PyString_Size(_obj4) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg4 = makelong(PyString_AsString(_obj4));
    }
}
{
    if (!(_obj5) || (_obj5 == Py_None)) {
	_arg5 = 0;
    } else {
	if (!PyString_Check(_obj5) || (PyString_Size(_obj5) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg5 = makelong(PyString_AsString(_obj5));
    }
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_FindDBInfo(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;

    if (_arg6) {
	o = Py_BuildValue("{sisisisOsOsislslslslsisssisisisisisisisi}",
			  "more", _arg6->more,
			  "flags", _arg6->flags,
			  "miscFlags", _arg6->miscFlags,
			  "type", PyString_FromStringAndSize(printlong(_arg6->type), 4),
			  "creator", PyString_FromStringAndSize(printlong(_arg6->creator), 4),
			  "version", _arg6->version,
			  "modnum", _arg6->modnum,
			  "createDate", _arg6->createDate,
			  "modifyDate", _arg6->modifyDate,
			  "backupDate", _arg6->backupDate,
			  "index", _arg6->index,
			  "name", _arg6->name,

			  "flagResource", !!(_arg6->flags & dlpDBFlagResource),
			  "flagReadOnly", !!(_arg6->flags & dlpDBFlagReadOnly),
			  "flagAppInfoDirty", !!(_arg6->flags & dlpDBFlagAppInfoDirty),
			  "flagBackup", !!(_arg6->flags & dlpDBFlagBackup),
			  "flagOpen", !!(_arg6->flags & dlpDBFlagOpen),
			  "flagNewer", !!(_arg6->flags & dlpDBFlagNewer),
			  "flagReset", !!(_arg6->flags & dlpDBFlagReset),
			  "flagExcludeFromSync", !!(_arg6->miscFlags & dlpDBMiscFlagExcludeFromSync));
	_resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_OpenDB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    int * _arg4;
    int  temp;

    self = self;
{
  _arg4 = &temp;
}
    if(!PyArg_ParseTuple(args,"iiis:dlp_OpenDB",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_OpenDB(_arg0,_arg1,_arg2,_arg3,_arg4);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_CloseDB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:dlp_CloseDB",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_CloseDB(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_CloseDB_All(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_CloseDB_All",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_CloseDB_All(_arg0);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_DeleteDB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    char * _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iis:dlp_DeleteDB",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_DeleteDB(_arg0,_arg1,_arg2);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_CreateDB(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    long  _arg1;
    long  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    char * _arg6;
    int * _arg7;
    int  temp;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
{
  _arg7 = &temp;
}
    if(!PyArg_ParseTuple(args,"iOOiiis:dlp_CreateDB",&_arg0,&_obj1,&_obj2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
{
    if (!(_obj1) || (_obj1 == Py_None)) {
	_arg1 = 0;
    } else {
	if (!PyString_Check(_obj1) || (PyString_Size(_obj1) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg1 = makelong(PyString_AsString(_obj1));
    }
}
{
    if (!(_obj2) || (_obj2 == Py_None)) {
	_arg2 = 0;
    } else {
	if (!PyString_Check(_obj2) || (PyString_Size(_obj2) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg2 = makelong(PyString_AsString(_obj2));
    }
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_CreateDB(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ResetSystem(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_ResetSystem",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ResetSystem(_arg0);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_AddSyncLogEntry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    char * _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"is:dlp_AddSyncLogEntry",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_AddSyncLogEntry(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_OpenConduit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_OpenConduit",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_OpenConduit(_arg0);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_EndOfSync(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:dlp_EndOfSync",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_EndOfSync(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_AbortSync(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_AbortSync",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_AbortSync(_arg0);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadOpenDBInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int * _arg2;
    int  temp;

    self = self;
{
  _arg2 = &temp;
}
    if(!PyArg_ParseTuple(args,"ii:dlp_ReadOpenDBInfo",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadOpenDBInfo(_arg0,_arg1,_arg2);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg2));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_MoveCategory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"iiii:dlp_MoveCategory",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_MoveCategory(_arg0,_arg1,_arg2,_arg3);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteUserInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    struct PilotUser * _arg1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iO:dlp_WriteUserInfo",&_arg0,&_obj1)) 
        return NULL;
{
    static struct PilotUser temp;
    int l;
    PyObject *foo;

    temp.userID = DGETLONG(_obj1,"userID",0);
    temp.viewerID = DGETLONG(_obj1,"viewerID",0);
    temp.lastSyncPC = DGETLONG(_obj1,"lastSyncPC",0);
    temp.successfulSyncDate = DGETLONG(_obj1,"successfulSyncDate",0);
    temp.lastSyncDate = DGETLONG(_obj1,"lastSyncDate",0);
    strncpy(temp.username, DGETSTR(_obj1,"name",""), 128);

    foo = PyDict_GetItemString(_obj1,"password");
    if (PyString_Check(foo)) {
	l = PyString_Size(foo);
	temp.passwordLength = l;
	memcpy(temp.password, PyString_AsString(foo), l);
    }
    
    _arg1 = &temp;    
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_WriteUserInfo(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadUserInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    struct PilotUser * _arg1;
    struct PilotUser  temp;

    self = self;
{
    _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"i:dlp_ReadUserInfo",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadUserInfo(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    
    if (_arg1) {
	o = Py_BuildValue("{slslslslslssss#}",
			  "userID", _arg1->userID,
			  "viewerID", _arg1->viewerID,
			  "lastSyncPC", _arg1->lastSyncPC,
			  "successfulSyncDate", _arg1->successfulSyncDate,
			  "lastSyncDate", _arg1->lastSyncDate,
			  "name", _arg1->username,
			  "password", _arg1->password, _arg1->passwordLength);
        _resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ResetLastSyncPC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:dlp_ResetLastSyncPC",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ResetLastSyncPC(_arg0);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteAppBlock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    void * _arg2;
    int  _arg3;
    int  __buflen;
    PyObject * _obj2 = 0;

    self = self;
{
}
    if(!PyArg_ParseTuple(args,"iiO:dlp_WriteAppBlock",&_arg0,&_arg1,&_obj2)) 
        return NULL;
{
    __buflen = PyString_Size(_obj2);
    _arg2 = (void *)PyString_AsString(_obj2);
}
{
    _arg3 = __buflen;
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_WriteAppBlock(_arg0,_arg1,_arg2,_arg3);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteSortBlock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    void * _arg2;
    int  _arg3;
    int  __buflen;
    PyObject * _obj2 = 0;

    self = self;
{
}
    if(!PyArg_ParseTuple(args,"iiO:dlp_WriteSortBlock",&_arg0,&_arg1,&_obj2)) 
        return NULL;
{
    __buflen = PyString_Size(_obj2);
    _arg2 = (void *)PyString_AsString(_obj2);
}
{
    _arg3 = __buflen;
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_WriteSortBlock(_arg0,_arg1,_arg2,_arg3);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ResetDBIndex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:dlp_ResetDBIndex",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ResetDBIndex(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteRecord(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    recordid_t * _arg3;
    int  _arg4;
    void * _arg5;
    int  _arg6;
    recordid_t * _arg7;
    unsigned long  temp;
    unsigned long  temp0;
    PyObject * _obj3 = 0;
    int  __buflen;
    PyObject * _obj5 = 0;

    self = self;
{
}
{
  _arg7 = &temp;
}
    if(!PyArg_ParseTuple(args,"iiiOiO:dlp_WriteRecord",&_arg0,&_arg1,&_arg2,&_obj3,&_arg4,&_obj5)) 
        return NULL;
{
  temp0 = (unsigned long) PyInt_AsLong(_obj3);
  _arg3 = &temp0;
}
{
    __buflen = PyString_Size(_obj5);
    _arg5 = (void *)PyString_AsString(_obj5);
}
{
    _arg6 = __buflen;
}
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_WriteRecord(_arg0,_arg1,_arg2,*_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_DeleteRecord(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    recordid_t * _arg3;
    char * _argc3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iiis:dlp_DeleteRecord",&_arg0,&_arg1,&_arg2,&_argc3)) 
        return NULL;
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,"_recordid_t_p")) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of dlp_DeleteRecord. Expected _recordid_t_p.");
        return NULL;
        }
    }
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_DeleteRecord(_arg0,_arg1,_arg2,*_arg3);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_DeleteCategory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:dlp_DeleteCategory",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_DeleteCategory(_arg0,_arg1,_arg2);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadResourceByType(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    unsigned long  _arg2;
    int  _arg3;
    void * _arg4;
    int * _arg5;
    int  temp;
    int * _arg6;
    int  __buflen;
    PyObject * _obj2 = 0;

    self = self;
{
    _arg4 = __dlp_buf;
}
{
  _arg5 = &temp;
}
{
    _arg6 = &__buflen;
}
    if(!PyArg_ParseTuple(args,"iiOi:dlp_ReadResourceByType",&_arg0,&_arg1,&_obj2,&_arg3)) 
        return NULL;
{
    if (!(_obj2) || (_obj2 == Py_None)) {
	_arg2 = 0;
    } else {
	if (!PyString_Check(_obj2) || (PyString_Size(_obj2) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg2 = makelong(PyString_AsString(_obj2));
    }
}
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadResourceByType(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg4) {
	o = Py_BuildValue("s#", _arg4, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg5));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadResourceByIndex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    void * _arg3;
    unsigned long * _arg4;
    unsigned long  temp;
    int * _arg5;
    int  temp0;
    int * _arg6;
    int  __buflen;

    self = self;
{
    _arg3 = __dlp_buf;
}
{
    _arg4 = &temp;
}
{
  _arg5 = &temp0;
}
{
    _arg6 = &__buflen;
}
    if(!PyArg_ParseTuple(args,"iii:dlp_ReadResourceByIndex",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadResourceByIndex(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg3) {
	o = Py_BuildValue("s#", _arg3, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    if (_arg4) {
	o = PyString_FromStringAndSize(printlong(*_arg4), 4);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg5));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteResource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    unsigned long  _arg2;
    int  _arg3;
    void * _arg4;
    int  _arg5;
    PyObject * _obj2 = 0;
    int  __buflen;
    PyObject * _obj4 = 0;

    self = self;
{
}
    if(!PyArg_ParseTuple(args,"iiOiO:dlp_WriteResource",&_arg0,&_arg1,&_obj2,&_arg3,&_obj4)) 
        return NULL;
{
    if (!(_obj2) || (_obj2 == Py_None)) {
	_arg2 = 0;
    } else {
	if (!PyString_Check(_obj2) || (PyString_Size(_obj2) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg2 = makelong(PyString_AsString(_obj2));
    }
}
{
    __buflen = PyString_Size(_obj4);
    _arg4 = (void *)PyString_AsString(_obj4);
}
{
    _arg5 = __buflen;
}
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_WriteResource(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_DeleteResource(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    unsigned long  _arg3;
    int  _arg4;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iiiOi:dlp_DeleteResource",&_arg0,&_arg1,&_arg2,&_obj3,&_arg4)) 
        return NULL;
{
    if (!(_obj3) || (_obj3 == Py_None)) {
	_arg3 = 0;
    } else {
	if (!PyString_Check(_obj3) || (PyString_Size(_obj3) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg3 = makelong(PyString_AsString(_obj3));
    }
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_DeleteResource(_arg0,_arg1,_arg2,_arg3,_arg4);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadNextModifiedRec(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    void * _arg2;
    recordid_t * _arg3;
    unsigned long  temp;
    int * _arg4;
    int  temp0;
    int * _arg5;
    int  __buflen;
    int * _arg6;
    int  temp1;
    int * _arg7;
    int  temp2;

    self = self;
{
    _arg2 = __dlp_buf;
}
{
  _arg3 = &temp;
}
{
  _arg4 = &temp0;
}
{
    _arg5 = &__buflen;
}
{
  _arg6 = &temp1;
}
{
  _arg7 = &temp2;
}
    if(!PyArg_ParseTuple(args,"ii:dlp_ReadNextModifiedRec",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadNextModifiedRec(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg2) {
	o = Py_BuildValue("s#", _arg2, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg3));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg6));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadNextModifiedRecInCategory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    void * _arg3;
    recordid_t * _arg4;
    unsigned long  temp;
    int * _arg5;
    int  temp0;
    int * _arg6;
    int  __buflen;
    int * _arg7;
    int  temp1;

    self = self;
{
    _arg3 = __dlp_buf;
}
{
  _arg4 = &temp;
}
{
  _arg5 = &temp0;
}
{
    _arg6 = &__buflen;
}
{
  _arg7 = &temp1;
}
    if(!PyArg_ParseTuple(args,"iii:dlp_ReadNextModifiedRecInCategory",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadNextModifiedRecInCategory(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg3) {
	o = Py_BuildValue("s#", _arg3, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg5));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadNextRecInCategory(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    void * _arg3;
    recordid_t * _arg4;
    unsigned long  temp;
    int * _arg5;
    int  temp0;
    int * _arg6;
    int  __buflen;
    int * _arg7;
    int  temp1;
    char * _argc3 = 0;

    self = self;
{
  _arg4 = &temp;
}
{
  _arg5 = &temp0;
}
{
    _arg6 = &__buflen;
}
{
  _arg7 = &temp1;
}
    if(!PyArg_ParseTuple(args,"iiis:dlp_ReadNextRecInCategory",&_arg0,&_arg1,&_arg2,&_argc3)) 
        return NULL;
    if (_argc3) {
        if (SWIG_GetPtr(_argc3,(void **) &_arg3,(char *) 0 )) {
            PyErr_SetString(PyExc_TypeError,"Type error in argument 4 of dlp_ReadNextRecInCategory. Expected _void_p.");
        return NULL;
        }
    }
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadNextRecInCategory(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg5));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadRecordById(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    recordid_t * _arg2;
    void * _arg3;
    int * _arg4;
    int  temp;
    int * _arg5;
    int  __buflen;
    int * _arg6;
    int  temp0;
    int * _arg7;
    int  temp1;
    unsigned long  temp2;
    PyObject * _obj2 = 0;

    self = self;
{
    _arg3 = __dlp_buf;
}
{
  _arg4 = &temp;
}
{
    _arg5 = &__buflen;
}
{
  _arg6 = &temp0;
}
{
  _arg7 = &temp1;
}
    if(!PyArg_ParseTuple(args,"iiO:dlp_ReadRecordById",&_arg0,&_arg1,&_obj2)) 
        return NULL;
{
  temp2 = (unsigned long) PyInt_AsLong(_obj2);
  _arg2 = &temp2;
}
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadRecordById(_arg0,_arg1,*_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg3) {
	o = Py_BuildValue("s#", _arg3, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg6));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadRecordByIndex(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPDBERROR * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;
    void * _arg3;
    recordid_t * _arg4;
    unsigned long  temp;
    int * _arg5;
    int  __buflen;
    int * _arg6;
    int  temp0;
    int * _arg7;
    int  temp1;

    self = self;
{
    _arg3 = __dlp_buf;
}
{
  _arg4 = &temp;
}
{
    _arg5 = &__buflen;
}
{
  _arg6 = &temp0;
}
{
  _arg7 = &temp1;
}
    if(!PyArg_ParseTuple(args,"iii:dlp_ReadRecordByIndex",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (DLPDBERROR *) malloc(sizeof(DLPDBERROR ));
    *(_result) = dlp_ReadRecordByIndex(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) == -5) {
	Py_INCREF(Py_None);
	return Py_None;
    } else if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg3) {
	o = Py_BuildValue("s#", _arg3, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg4));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg6));
    _resultobj = t_output_helper(_resultobj, o);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_CleanUpDatabase(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:dlp_CleanUpDatabase",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_CleanUpDatabase(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ResetSyncFlags(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:dlp_ResetSyncFlags",&_arg0,&_arg1)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ResetSyncFlags(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadFeature(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    unsigned long  _arg1;
    unsigned int  _arg2;
    unsigned long * _arg3;
    unsigned long  temp;
    PyObject * _obj1 = 0;

    self = self;
{
  _arg3 = &temp;
}
    if(!PyArg_ParseTuple(args,"iOi:dlp_ReadFeature",&_arg0,&_obj1,&_arg2)) 
        return NULL;
{
    if (!(_obj1) || (_obj1 == Py_None)) {
	_arg1 = 0;
    } else {
	if (!PyString_Check(_obj1) || (PyString_Size(_obj1) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg1 = makelong(PyString_AsString(_obj1));
    }
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadFeature(_arg0,_arg1,_arg2,_arg3);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg3));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadNetSyncInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    struct NetSyncInfo * _arg1;
    struct NetSyncInfo  temp;

    self = self;
{
    _arg1 = &temp;
}
    if(!PyArg_ParseTuple(args,"i:dlp_ReadNetSyncInfo",&_arg0)) 
        return NULL;
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadNetSyncInfo(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg1){
	o = Py_BuildValue("{sissssss}",
			  "lanSync", _arg1->lanSync,
			  "hostName", _arg1->hostName,
			  "hostAddress", _arg1->hostAddress,
			  "hostSubnetMask", _arg1->hostSubnetMask);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteNetSyncInfo(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    struct NetSyncInfo * _arg1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iO:dlp_WriteNetSyncInfo",&_arg0,&_obj1)) 
        return NULL;
{
    static struct NetSyncInfo temp;

    temp.lanSync = (int) DGETLONG(_obj1,"lanSync",0);
    strncpy(temp.hostName, DGETSTR(_obj1,"hostName",""), 256);
    strncpy(temp.hostAddress, DGETSTR(_obj1,"hostAddress",""), 40);
    strncpy(temp.hostSubnetMask, DGETSTR(_obj1,"hostSubnetMask",""), 40);

    _arg1 = &temp;
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_WriteNetSyncInfo(_arg0,_arg1);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_ReadAppPreference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    unsigned long  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    void * _arg5;
    int * _arg6;
    int  __buflen;
    int * _arg7;
    int  temp;
    PyObject * _obj1 = 0;

    self = self;
{
    _arg4 = DLPMAXBUF;
}
{
    _arg5 = __dlp_buf;
}
{
    _arg6 = &__buflen;
}
{
  _arg7 = &temp;
}
    if(!PyArg_ParseTuple(args,"iOii:dlp_ReadAppPreference",&_arg0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
    if (!(_obj1) || (_obj1 == Py_None)) {
	_arg1 = 0;
    } else {
	if (!PyString_Check(_obj1) || (PyString_Size(_obj1) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg1 = makelong(PyString_AsString(_obj1));
    }
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_ReadAppPreference(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
{
    PyObject *o;
    if (_arg5) {
	o = Py_BuildValue("s#", _arg5, __buflen);
	_resultobj = t_output_helper(_resultobj, o);
    }
}
{
    PyObject *o;
    o = PyInt_FromLong((long) (*_arg7));
    _resultobj = t_output_helper(_resultobj, o);
}
    return _resultobj;
}

static PyObject *_wrap_dlp_WriteAppPreference(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    DLPERROR * _result;
    int  _arg0;
    unsigned long  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    void * _arg5;
    int  _arg6;
    PyObject * _obj1 = 0;
    int  __buflen;
    PyObject * _obj5 = 0;

    self = self;
{
}
    if(!PyArg_ParseTuple(args,"iOiiiO:dlp_WriteAppPreference",&_arg0,&_obj1,&_arg2,&_arg3,&_arg4,&_obj5)) 
        return NULL;
{
    if (!(_obj1) || (_obj1 == Py_None)) {
	_arg1 = 0;
    } else {
	if (!PyString_Check(_obj1) || (PyString_Size(_obj1) != 4)) {
	    PyErr_SetString(PyExc_ValueError, "argument must be a 4-character string");
	    return 0;
	}
	_arg1 = makelong(PyString_AsString(_obj1));
    }
}
{
    __buflen = PyString_Size(_obj5);
    _arg5 = (void *)PyString_AsString(_obj5);
}
{
    _arg6 = __buflen;
}
    _result = (DLPERROR *) malloc(sizeof(DLPERROR ));
    *(_result) = dlp_WriteAppPreference(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
{
    if (*(_result) < 0) {
	PyErr_SetObject(Error, Py_BuildValue("(is)", *(_result),
					     dlp_strerror(*(_result))));
	return NULL;
    }
    _resultobj = Py_None;
    Py_INCREF(Py_None);
}
    return _resultobj;
}

static PyMethodDef pisockMethods[] = {
	 { "dlp_WriteAppPreference", _wrap_dlp_WriteAppPreference, 1 },
	 { "dlp_ReadAppPreference", _wrap_dlp_ReadAppPreference, 1 },
	 { "dlp_WriteNetSyncInfo", _wrap_dlp_WriteNetSyncInfo, 1 },
	 { "dlp_ReadNetSyncInfo", _wrap_dlp_ReadNetSyncInfo, 1 },
	 { "dlp_ReadFeature", _wrap_dlp_ReadFeature, 1 },
	 { "dlp_ResetSyncFlags", _wrap_dlp_ResetSyncFlags, 1 },
	 { "dlp_CleanUpDatabase", _wrap_dlp_CleanUpDatabase, 1 },
	 { "dlp_ReadRecordByIndex", _wrap_dlp_ReadRecordByIndex, 1 },
	 { "dlp_ReadRecordById", _wrap_dlp_ReadRecordById, 1 },
	 { "dlp_ReadNextRecInCategory", _wrap_dlp_ReadNextRecInCategory, 1 },
	 { "dlp_ReadNextModifiedRecInCategory", _wrap_dlp_ReadNextModifiedRecInCategory, 1 },
	 { "dlp_ReadNextModifiedRec", _wrap_dlp_ReadNextModifiedRec, 1 },
	 { "dlp_DeleteResource", _wrap_dlp_DeleteResource, 1 },
	 { "dlp_WriteResource", _wrap_dlp_WriteResource, 1 },
	 { "dlp_ReadResourceByIndex", _wrap_dlp_ReadResourceByIndex, 1 },
	 { "dlp_ReadResourceByType", _wrap_dlp_ReadResourceByType, 1 },
	 { "dlp_DeleteCategory", _wrap_dlp_DeleteCategory, 1 },
	 { "dlp_DeleteRecord", _wrap_dlp_DeleteRecord, 1 },
	 { "dlp_WriteRecord", _wrap_dlp_WriteRecord, 1 },
	 { "dlp_ReadRecordIDList", _wrap_dlp_ReadRecordIDList, 1 },
	 { "dlp_ResetDBIndex", _wrap_dlp_ResetDBIndex, 1 },
	 { "dlp_WriteSortBlock", _wrap_dlp_WriteSortBlock, 1 },
	 { "dlp_ReadSortBlock", _wrap_dlp_ReadSortBlock, 1 },
	 { "dlp_WriteAppBlock", _wrap_dlp_WriteAppBlock, 1 },
	 { "dlp_ReadAppBlock", _wrap_dlp_ReadAppBlock, 1 },
	 { "dlp_ResetLastSyncPC", _wrap_dlp_ResetLastSyncPC, 1 },
	 { "dlp_ReadUserInfo", _wrap_dlp_ReadUserInfo, 1 },
	 { "dlp_WriteUserInfo", _wrap_dlp_WriteUserInfo, 1 },
	 { "dlp_MoveCategory", _wrap_dlp_MoveCategory, 1 },
	 { "dlp_ReadOpenDBInfo", _wrap_dlp_ReadOpenDBInfo, 1 },
	 { "dlp_AbortSync", _wrap_dlp_AbortSync, 1 },
	 { "dlp_EndOfSync", _wrap_dlp_EndOfSync, 1 },
	 { "dlp_OpenConduit", _wrap_dlp_OpenConduit, 1 },
	 { "dlp_AddSyncLogEntry", _wrap_dlp_AddSyncLogEntry, 1 },
	 { "dlp_ResetSystem", _wrap_dlp_ResetSystem, 1 },
	 { "dlp_CreateDB", _wrap_dlp_CreateDB, 1 },
	 { "dlp_DeleteDB", _wrap_dlp_DeleteDB, 1 },
	 { "dlp_CloseDB_All", _wrap_dlp_CloseDB_All, 1 },
	 { "dlp_CloseDB", _wrap_dlp_CloseDB, 1 },
	 { "dlp_OpenDB", _wrap_dlp_OpenDB, 1 },
	 { "dlp_FindDBInfo", _wrap_dlp_FindDBInfo, 1 },
	 { "dlp_ReadDBList", _wrap_dlp_ReadDBList, 1 },
	 { "dlp_ReadSysInfo", _wrap_dlp_ReadSysInfo, 1 },
	 { "dlp_ReadStorageInfo", _wrap_dlp_ReadStorageInfo, 1 },
	 { "dlp_SetSysDateTime", _wrap_dlp_SetSysDateTime, 1 },
	 { "dlp_GetSysDateTime", _wrap_dlp_GetSysDateTime, 1 },
	 { "dlp_strerror", _wrap_dlp_strerror, 1 },
	 { "pi_close", _wrap_pi_close, 1 },
	 { "pi_watchdog", _wrap_pi_watchdog, 1 },
	 { "pi_tickle", _wrap_pi_tickle, 1 },
	 { "pi_version", _wrap_pi_version, 1 },
	 { "pi_getsockopt", _wrap_pi_getsockopt, 1 },
	 { "pi_setmaxspeed", _wrap_pi_setmaxspeed, 1 },
	 { "pi_getsockpeer", _wrap_pi_getsockpeer, 1 },
	 { "pi_getsockname", _wrap_pi_getsockname, 1 },
	 { "pi_write", _wrap_pi_write, 1 },
	 { "pi_read", _wrap_pi_read, 1 },
	 { "pi_recv", _wrap_pi_recv, 1 },
	 { "pi_send", _wrap_pi_send, 1 },
	 { "pi_accept_to", _wrap_pi_accept_to, 1 },
	 { "pi_accept", _wrap_pi_accept, 1 },
	 { "pi_listen", _wrap_pi_listen, 1 },
	 { "pi_bind", _wrap_pi_bind, 1 },
	 { "pi_connect", _wrap_pi_connect, 1 },
	 { "pi_socket", _wrap_pi_socket, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initpisock)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("pisock", pisockMethods);
	 d = PyModule_GetDict(m);

    __dlp_buf = (void *)Py_Malloc(DLPMAXBUF);
    Error = PyErr_NewException("pisock.error", NULL, NULL);
    PyDict_SetItemString(d, "error", Error);
	 PyDict_SetItemString(d,"PI_AF_SLP", PyInt_FromLong((long) 0x0051));
	 PyDict_SetItemString(d,"PI_AF_INETSLP", PyInt_FromLong((long) 0x0054));
	 PyDict_SetItemString(d,"PI_PF_SLP", PyInt_FromLong((long) (0x0051)));
	 PyDict_SetItemString(d,"PI_PF_PADP", PyInt_FromLong((long) 0x0052));
	 PyDict_SetItemString(d,"PI_PF_LOOP", PyInt_FromLong((long) 0x0053));
	 PyDict_SetItemString(d,"PI_SOCK_STREAM", PyInt_FromLong((long) 0x0010));
	 PyDict_SetItemString(d,"PI_SOCK_DGRAM", PyInt_FromLong((long) 0x0020));
	 PyDict_SetItemString(d,"PI_SOCK_RAW", PyInt_FromLong((long) 0x0030));
	 PyDict_SetItemString(d,"PI_SOCK_SEQPACKET", PyInt_FromLong((long) 0x0040));
	 PyDict_SetItemString(d,"PI_SLP_SPEED", PyInt_FromLong((long) 0x0001));
	 PyDict_SetItemString(d,"PI_PilotSocketDLP", PyInt_FromLong((long) 3));
	 PyDict_SetItemString(d,"PI_PilotSocketConsole", PyInt_FromLong((long) 1));
	 PyDict_SetItemString(d,"PI_PilotSocketDebugger", PyInt_FromLong((long) 0));
	 PyDict_SetItemString(d,"PI_PilotSocketRemoteUI", PyInt_FromLong((long) 2));
	 PyDict_SetItemString(d,"dlpDBFlagResource", PyInt_FromLong((long) dlpDBFlagResource));
	 PyDict_SetItemString(d,"dlpDBFlagReadOnly", PyInt_FromLong((long) dlpDBFlagReadOnly));
	 PyDict_SetItemString(d,"dlpDBFlagAppInfoDirty", PyInt_FromLong((long) dlpDBFlagAppInfoDirty));
	 PyDict_SetItemString(d,"dlpDBFlagBackup", PyInt_FromLong((long) dlpDBFlagBackup));
	 PyDict_SetItemString(d,"dlpDBFlagOpen", PyInt_FromLong((long) dlpDBFlagOpen));
	 PyDict_SetItemString(d,"dlpDBFlagNewer", PyInt_FromLong((long) dlpDBFlagNewer));
	 PyDict_SetItemString(d,"dlpDBFlagReset", PyInt_FromLong((long) dlpDBFlagReset));
	 PyDict_SetItemString(d,"dlpDBMiscFlagExcludeFromSync", PyInt_FromLong((long) dlpDBMiscFlagExcludeFromSync));
	 PyDict_SetItemString(d,"dlpRecAttrDeleted", PyInt_FromLong((long) dlpRecAttrDeleted));
	 PyDict_SetItemString(d,"dlpRecAttrDirty", PyInt_FromLong((long) dlpRecAttrDirty));
	 PyDict_SetItemString(d,"dlpRecAttrBusy", PyInt_FromLong((long) dlpRecAttrBusy));
	 PyDict_SetItemString(d,"dlpRecAttrSecret", PyInt_FromLong((long) dlpRecAttrSecret));
	 PyDict_SetItemString(d,"dlpRecAttrArchived", PyInt_FromLong((long) dlpRecAttrArchived));
	 PyDict_SetItemString(d,"dlpOpenRead", PyInt_FromLong((long) dlpOpenRead));
	 PyDict_SetItemString(d,"dlpOpenWrite", PyInt_FromLong((long) dlpOpenWrite));
	 PyDict_SetItemString(d,"dlpOpenExclusive", PyInt_FromLong((long) dlpOpenExclusive));
	 PyDict_SetItemString(d,"dlpOpenSecret", PyInt_FromLong((long) dlpOpenSecret));
	 PyDict_SetItemString(d,"dlpOpenReadWrite", PyInt_FromLong((long) dlpOpenReadWrite));
	 PyDict_SetItemString(d,"dlpEndCodeNormal", PyInt_FromLong((long) dlpEndCodeNormal));
	 PyDict_SetItemString(d,"dlpEndCodeOutOfMemory", PyInt_FromLong((long) dlpEndCodeOutOfMemory));
	 PyDict_SetItemString(d,"dlpEndCodeUserCan", PyInt_FromLong((long) dlpEndCodeUserCan));
	 PyDict_SetItemString(d,"dlpEndCodeOther", PyInt_FromLong((long) dlpEndCodeOther));
	 PyDict_SetItemString(d,"dlpDBListRAM", PyInt_FromLong((long) dlpDBListRAM));
	 PyDict_SetItemString(d,"dlpDBListROM", PyInt_FromLong((long) dlpDBListROM));
	 PyDict_SetItemString(d,"dlpErrNoError", PyInt_FromLong((long) dlpErrNoError));
	 PyDict_SetItemString(d,"dlpErrSystem", PyInt_FromLong((long) dlpErrSystem));
	 PyDict_SetItemString(d,"dlpErrMemory", PyInt_FromLong((long) dlpErrMemory));
	 PyDict_SetItemString(d,"dlpErrParam", PyInt_FromLong((long) dlpErrParam));
	 PyDict_SetItemString(d,"dlpErrNotFound", PyInt_FromLong((long) dlpErrNotFound));
	 PyDict_SetItemString(d,"dlpErrNoneOpen", PyInt_FromLong((long) dlpErrNoneOpen));
	 PyDict_SetItemString(d,"dlpErrAlreadyOpen", PyInt_FromLong((long) dlpErrAlreadyOpen));
	 PyDict_SetItemString(d,"dlpErrTooManyOpen", PyInt_FromLong((long) dlpErrTooManyOpen));
	 PyDict_SetItemString(d,"dlpErrExists", PyInt_FromLong((long) dlpErrExists));
	 PyDict_SetItemString(d,"dlpErrOpen", PyInt_FromLong((long) dlpErrOpen));
	 PyDict_SetItemString(d,"dlpErrDeleted", PyInt_FromLong((long) dlpErrDeleted));
	 PyDict_SetItemString(d,"dlpErrBusy", PyInt_FromLong((long) dlpErrBusy));
	 PyDict_SetItemString(d,"dlpErrNotSupp", PyInt_FromLong((long) dlpErrNotSupp));
	 PyDict_SetItemString(d,"dlpErrUnused1", PyInt_FromLong((long) dlpErrUnused1));
	 PyDict_SetItemString(d,"dlpErrReadOnly", PyInt_FromLong((long) dlpErrReadOnly));
	 PyDict_SetItemString(d,"dlpErrSpace", PyInt_FromLong((long) dlpErrSpace));
	 PyDict_SetItemString(d,"dlpErrLimit", PyInt_FromLong((long) dlpErrLimit));
	 PyDict_SetItemString(d,"dlpErrSync", PyInt_FromLong((long) dlpErrSync));
	 PyDict_SetItemString(d,"dlpErrWrapper", PyInt_FromLong((long) dlpErrWrapper));
	 PyDict_SetItemString(d,"dlpErrArgument", PyInt_FromLong((long) dlpErrArgument));
	 PyDict_SetItemString(d,"dlpErrSize", PyInt_FromLong((long) dlpErrSize));
	 PyDict_SetItemString(d,"dlpErrUnknown", PyInt_FromLong((long) dlpErrUnknown));
	 PyDict_SetItemString(d,"cvar", SWIG_globals);
	 SWIG_addvarlink(SWIG_globals,"dlp_errorlist",_wrap_dlp_errorlist_get, _wrap_dlp_errorlist_set);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
