#include <stdio.h>
#include "navstructs.h"

char *calloc();

/***************************************************************************
*
*   Load up the WORLD.
*
***************************************************************************/


load_arrays()
{
  FILE *fp;
  int i, j;
            
/*  Open the data file for reading
*/                       

  fp = fopen("world.dat","r");


/*   Set up a counter and allocate space for the first node
*/                 

  i = 0;
  world[i] = (Node *) calloc(1, sizeof(Node) );

/*   Read in the node data to world[i], then increment counter, allocate
 *   space for the next node, and reenter the loop.
*/

  while (fscanf (fp,"%d%d%d%d%d%d%d%d%d%d"
			,&world[i]->node_x
		       	,&world[i]->node_y
		        ,&world[i]->node_z
		        ,&world[i]->node_type
			,&world[i]->picture_ptr 
			,&world[i]->chart_ptr
			,&world[i]->object_ptr
			,&world[i]->current_ptr
			,&world[i]->geom
			,&world[i]->prox   )   != EOF ) {

           for(j=0;j<PIECUTS;++j)
	   fscanf (fp, "%d ", &world[i]->n_list[j]);

	    ++i;
            world[i] = (Node *) calloc(1, sizeof(Node) );
          }

/*  After all the nodes are in, set global total_node_count
*/

  total_node_count = i;
  free(world[i]);
  fclose(fp);


/*************************************************************
*
*   Load the picture set array.
*/

  fp = fopen("psets.dat","r");
  i = 0;
  picture_sets[i] = (Pictureset *) calloc(1, sizeof(Pictureset) );

/*   Read in the node data to picture_sets[i], then increment counter, allocate
 *   space for the next node, and reenter the loop.
*/

  while (fscanf (fp,"%d%d"
			,&picture_sets[i]->first
		       	,&picture_sets[i]->compass_error
                 )   != EOF ) 
	  {
	    ++i;
            picture_sets[i] = (Pictureset *) calloc(1, sizeof(Pictureset) );
           }

/*  After all the nodes are in, set global total_node_count
*/


  free(picture_sets[i]);
  fclose(fp);
}
