ty notestructs.c

#define MAXNOTES 1000
#define MAXDOBS 1000
#define MAXCOMMANDS 1000
#define MAXPARAMS 1000
#define MAXINSTANCES 1000
#define MAXTEXTS 500
#define MAXLABELS 500
#define MAXFUNCTIONS 100
#define LABELSIZE 30
#define TEXTSIZE 255

#define YES 1                      
#define NO 0
#define DEFINED 1
#define ACTIVE 1

#define INPUT_PARAM 1

#define BOX 1
#define RECTANGLE 1
#define CIRCLE 1 /* disabled */
#define POLYGON 1 /* currently disabled */
#define LINE 4
#define TEXT 5
#define LABEL 6

#define FILLBIT 2
#define FILL 2
#define MODEBITS 28
#define OVERLAY 4
#define CLEAR 8
#define COMPLEMENT 16
#define INVISIBLE -5

#define NOTES 0
#define DOBS 1
#define COMMANDS 2
#define PARAMS 3
#define INSTANCES 4
#define TEXTS 5
#define LABELS 6 

#define SCRX 959
#define SCRY 599
#define SPCX 1000
#define SPCY 750

#define INT 0
#define FLOAT 1
#define CHAR 2

#define DELETECHAR 127
#define RETURNCHAR 13
/*********************************************************************
*  COMMAND DEFINITIONS
*/

#define LOAD_NOTES	0
#define SAVE_NOTES	1
#define ACTIVATE_NOTE 	2
#define ER_DEAC_NOTE	3
#define DEACTIVATE_NOTE 4
#define SET_ATTRIBS	5         
#define FRECTANGLE	6
#define FCIRCLE		7
#define FPOLYGON	8
#define FLINE		9
#define FTEXT	       	10
#define FLABEL		11
#define ZONE_NOZONE	12
#define FILL_NOFILL	13
#define CTRL_PT		14
#define SETCOL		15

int load_notes();
int save_notes();
int activate_note();
int erase_and_deactivate();
int deactivate_note();
int set_attribs();
int frectangle();
int fcircle();
int fpolygon();
int fline();
int ftext();
int flabel();
int zone_nozone();
int fill_nofill();
int ctrl_pt();
int setcol();
                                
int (*function[MAXFUNCTIONS])();


/**********************************************************************
*  FILE MANAGEMENT DEFINITIONS
*/

#define BOF 0
#define HEADER 30



/************************************************************************
*   GLOBAL VARIABLES
*/

	int making_notes = NO;
	int making_dobs  = NO;
	int making_zone  = NO;
	int getting_params = NO;
	int dobend = HEAD;
	int notes_modified = NO;
	int sysnotes;

	static char spacechr[] = " ";
	static char *spacechar = &spacechr;

/************************************************************************
*   COUNT STRUCTURE
*/
    struct count {	int notes;
			int dobs;
			int commands;
			int params;
			int instances;
			int texts;
			int labels;
		 }  cnt;

    static struct count *count = &cnt;
                                  
/************************************************************************
*   NOTE STRUCTURE
*/

   struct note {  	int next;
			int children;
			int parent;
			int comlist;
			int zone;  /* note boundary */
		       	int born;
			int active;
			int deleted;
		};

/*  Declare an array of pointers to NOTE structures.
*/
static struct note *note[MAXNOTES];     







/************************************************************************
*  DOB STRUCTURE
*/                                                                        
struct dob {	int next;
		int prev;
		int children;
		int parent;
		int instances;  /* list of additional exact copies */
		int type; /* 1:TEXT;2:BOX;3:LINE;   */
		int zone;
		int attributes;  /* bit mask */
		int size; /* 0:UNSEEN;1:DISPLAY;2:FULLSCREEN  */
		int color;
		int space;
	       	float x;
		float y;
		float xdim;
		float ydim;
		float wx;  /* current position  */
		float wy;  /* current position  */
		int head;  /* 1 DEFINED, 0 NOT_DEFINED */
		int tail;     
       		int text;
		int label;
		int active;
		int deleted;
	       };                 

/*  Declare an array of pointers to DOB structures.
*/
static struct dob *dob[MAXDOBS];


/************************************************************************
*  INSTANCE STRUCTURE
*/

   struct instnce {	int next;
			int prev;
	      		int parent;    /* physical parent */
			int genotype;  /* points to genetic parent */
			int space;
			float x;
			float y;
			float wx;
			float wy;
			int active; 
			int deleted;
		    };
                                         
/*  Declare an array of pointers to INSTANCE structures.
*/
static struct instnce *instance[MAXINSTANCES];



/************************************************************************
*  COMMAND STRUCTURE
*/
                
   struct comnd {	int next;
			int function;
			int params;
			int deleted;
		};

/*  Declare an array of pointers to COMMAND structures.
*/
static struct comnd *command[MAXCOMMANDS];

/************************************************************************
*   PARAM STRUCTURE
*/
                     
   struct param {       int next;
			int type;
			int content;
		        float fcon;
			int deleted;

		  };

/*  Declare an array of pointers to PARAM structures.
*/
static struct param *param[MAXPARAMS];


	
/************************************************************************
*  TEXT STRUCTURE
*/
           
struct text {	int next;
		int deleted;
		char buffer[256];
	     };

static struct text *text[MAXTEXTS];

/************************************************************************
*  LABEL STRUCTURE
*/
struct label {  int next;
		int deleted;
		char buffer[30];
	      };

static struct label *label[MAXLABELS];

/************************************************************************
*  VIEWPORT STRUCTURE
*/


struct vport {	float x;
		float y;
	   	float wdth;
		float hght;
	       };

struct vport wndw;
struct vport *window = &wndw;



/************************************************************************
*   STATE STRUCTURE
*/
struct state {	int attributes;
		int color;
		int note;
	      	int dob;
		int context;
		float x;
	      	float y;
		struct pos *pos;
	      };
struct state crrnt;
struct state *current = &crrnt;




/************************************************************************
*  STRUCT ACTIVE
*/
struct active {  	struct active *next;
			struct active *prev;
			int note;
		};
static struct active *active_notes;

S>lo

  HODGES       logged out at  6-APR-1987 12:00:07.00
