
/*
*	Set_Position:
*
*	The following functions are used to update the display of 
*       a package when it gets a request to move to a certain position.
*/
#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#define FN_MISC extern
#define SETPOS extern
#include "functions.h"
#define VDISC extern
#include "vdisc.h"

#define FROZEN  0
#define MATCH 	0
#define OK_ON(i) ((p->position[i] + p->dimension[i]->range) >=        \
		      (m)->simple.pos[InPoint][i]  &&                 \
		  p->position[i] <=  (m)->simple.pos[OutPoint][i] )



  int
in_region(p,m)
  Package 	*p;
  Map		*m;
{
	int	i;
		if( !p || !p->ndims || !m )
		{
			return NULL;
		 }
Debug((stderr,"in_region, %d dims: ",p->ndims));
		for(i=0; i < p->ndims; ++i)
		{
Debug((stderr,"cur[%d] %d, in %d, out %d...",i,p->position[i],m->simple.pos[InPoint][i], m->simple.pos[OutPoint][i]));

			if(!OK_ON(i))
			{
Debug((stderr,"NOT OK\n"));
				return((int)NULL);
			 }
		 }
Debug((stderr,"OK\n"));
		return(1);
}

 
Map *
find_map(e)
  Element 	*e;
{
	Map *m = e->current ? e->current : e->map;
	Map *l, *n;

		if(e->p->position[0] < m->simple.pos[InPoint][0]){
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
			for(n = m->simple.next; n; n = n->simple.next){
				if( in_region(e->p, n)) return (Map *) n;
			 }
		 }
		else{
			for(n = m->simple.next; n; n = n->simple.next)

			{
				if( in_region(e->p, n)) return (Map *) n;
			 }
			for(l = m->simple.prev; l; l = m->simple.prev){
				if( in_region(e->p, l)) return (Map *) l;
			 }
		 }
        	if(m->simple.type > Unused_map)
		{
Debug((stderr,"find_map: map at %d\n",m));
			if( in_region(e->p, m)) return (Map *) m;
		 }
		return (Map *) NULL;
}


 char *
find_all_maps(e)
  Element 	*e;
{
  static char   *funcname = "find_all_maps";
  Map 		*m = e->map;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *tmp, *maplist = NULL;

	while(m != 0)
	{
		if(in_region(e->p, m))
		{
Debug((stderr," map in region: type `%d' at `%d'\n",m->simple.type,m));
			if((tmp = (struct maplist *) 
				calloc(1, sizeof(struct maplist))) == NULL)
			{
				printf("%s: failed calloc maplist\n",funcname);
				exit(1);
			 }
			tmp->map = m;
			tmp->next = maplist;
			maplist = tmp;
		  }
		 m = m->simple.next;
	 }
	return ((char *) maplist);
}

/*-----------------------------------------*/
position_and_scale(e)
  Element 	*e;
{
	static char   	*func = "pos_and_scale";
	WindowInfo    	info, pinfo;
	int		pw,ph; /* parent window width, height */
	int		x,y,w,h; /*element window */
	float		vx,vy; /* virtual x and y */
	float		vw,vh; /* virtual width and height */
	Map		*m = (e->current) ? e->current : e->map;
	Screenlist      *sl = e->screen;

Debug((stderr,"%s:\n",func));

	if(e->type == ACTION || e->type == AUDIO) return;

	while(sl)
	{
Debug((stderr,"  screen `%s' (%d): vx %d, vy %d " ,sl->s->name,sl->s->w,sl->s->x_key,sl->s->y_key));

		if( ! XQueryWindow((Window)sl->s->w,&info))
		{
			printf("%s: failed XQueryWindow\n",func);
			exit(1);
	 	 }
		x = (int)info.x;
		y = (int)info.y;
		w = (int)info.width;
		h = (int)info.height;

		if( ! XQueryWindow((Window)sl->s->parent,&pinfo))
		{
			printf("%s: failed XQueryWindow\n",func);
			exit(1);
	 	 }

		pw = pinfo.width;
		ph = pinfo.height;

		if(sl->s->x_key > -1)
		{
			vx = m->simple.pos[InPoint][sl->s->x_key];
			vx -= e->p->dimension[sl->s->x_key]->current;
			x = (vx / e->p->dimension[sl->s->x_key]->range) * pw;

			vw = (m->simple.pos[OutPoint][sl->s->x_key] 
			      - e->p->dimension[sl->s->x_key]->current) - vx;
			w = (vw / e->p->dimension[sl->s->x_key]->range) * pw;
Debug((stderr,"set x `%d',w `%d'..",x,w));
	 	 }

		if(sl->s->y_key > -1)
		{
    			vy = m->simple.pos[InPoint][sl->s->y_key];
			vy -= e->p->dimension[sl->s->y_key]->current;
			y = (vy / e->p->dimension[sl->s->y_key]->range) * ph;

			vh = (m->simple.pos[OutPoint][sl->s->y_key] -
			     e->p->dimension[sl->s->y_key]->current) - vy;
			h = (vh / e->p->dimension[sl->s->y_key]->range) * ph;
Debug((stderr,"set y `%d',h `%d'\n",y,h));
	 	 }
		if(w != info.width || h != info.height)
		{
Debug((stderr,"    scaling %dx%d..",w,h));
			if( ! XChangeWindow(sl->s->w,w,h))
			{
				printf("%s: failed XMoveWindow\n",func);
		 	 }
	 	 }
		if(x != info.x || y != info.y)
		{
Debug((stderr,"moving %d,%d..",x,y));
			if( ! XMoveWindow(sl->s->w,x,y))
			{
				printf("%s: failed XMoveWindow\n",func);
		 	 }
	 	 }
		sl = sl->next;
Debug((stderr,"  done\n"));
	 }
Debug((stderr,"  exit %s\n",func));
}
/*----------------------------------------*/
update_element(e)
  Element 	*e;
{
	Map 		*m;
	int		status;
	static char 	*funcname = "update_elements";
	Map *		find_map();
	Screenlist      *sl = e->screen;

	if(e->active == YES)
	{
        	if(!e->current) e->current = e->map;
		/* look at all screens for virtual coordinate activity */
		while(sl)
		{
		 	if(sl->s->x_key > -1 || sl->s->y_key > -1)
			{
				position_and_scale(e);
				break;
			 }
			sl = sl->next;
		 }
		(*e->display_fn)(e);
	 }
}


update_package_display(p)
  Package 	*p;
{
	char          *funcname = "updatepackage";
	int 	i;
	Element *e;

	for(e = p->element; e; e = e->next)
	{
		update_element(e);
	 }
}


update_dimension_representations(p)
     Package		*p;
{
  	DimRep		*d;
	int 		i;

	for(i = 0; i < p->ndims; ++i)
	{
/*printf(" pos[`%d'] `%d', prev `%d'\n",i,p->position[i],p->prev_position[i]);*/
		if( p->position[i] != p->prev_position[i] )
		{
 			d = p->dimension[i]->rep;	
			while( d != 0)
			{
					(*d->update_fn)(d);
					d = d->next;
			 }
		 }
	 }
}



void
set_position(packpos)
	Packpos		*packpos;
{
	char		*funcname = "set_position";
  	Package  	*p = packpos->p;
  	int	i;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		
	
	for(i=0; i < p->ndims; ++i)
	{
		p->dimension[i]->current = packpos->pos[i];
		p->prev_position[i] = p->position[i];
		p->position[i] = packpos->pos[i];
	 }
	update_dimension_representations(p);
	update_package_display(p);
}




boundary(d,x)
  Dimension	*d;
  int		x;
{
  int 		tmp = d->current;

  	switch(d->boundary)
  	{
		case WRAP:
			tmp = (tmp + x > d->max) ? d->min : d->max;
			break;
		case FREEZE:
			tmp = (tmp + x > d->max) ? d->max : d->min;
			d->change = FROZEN;
			break;
		case BOUNCE:
                        d->delta_sign *= -1;
Debug((stderr,"boundary: set dim %d delta_sign to %d\n",d,d->delta_sign));
			tmp += (x * d->delta_sign);
			break;
		case LIMIT:
			tmp = (tmp + x > d->max) ? d->max : d->min;
Debug((stderr,"boundary: limiting dim `%s'\n",d->name));
			break;
	 }
	return(tmp);
}

/*-------------------------------------*/
activate_package(p)
  Package 	*p;
{
	static char	*func = "activate";
	Element		*e;
	Dimension	*d;
	Screenlist 	*sl = e->screen;
	int		i, zero = 0;

/*	XMapWindow( (Window) p->window->w); */
Debug((stderr,"%s: activating package `%s'\n",func,p->name));

	for(i=0; i<p->ndims; ++i)
	{
		if(p->dimension[i]->timer_fn != NULL)
		{
		     d = p->dimension[i];
		     d->interval = d->rate = d->rate_setting = d->rate_default;

Debug((stderr,"%s: starting timer on `%s' at `%d' msec\n",func,
  d->name, d->rate));
			start_timer(d, &zero, 0);
		 }
	 }
						/* 2/23 */
        if(p->window->occupant != NULL)
	{
Debug((stderr,"%s: screen occupant found: `%s'\n",func,p->window->occupant->name));
		expire_package(p->window->occupant->p,p,DO_PACK);
	 }
	else
	{
		for(e = p->element; e; e = e->next)
		{
Debug((stderr,"%s: marking `%s' screens occupied..",func,e->name));
			if(e->init_active == YES) e->active = YES;
			sl = e->screen;
			while(sl)
			{
Debug((stderr,"`%s',",sl->name));
				sl->s->occupant = e;
				sl = sl->next;
			 }
Debug((stderr,"done\n"));
	 	}


		update_package_display(p);
		update_dimension_representations(p);

		/* only do the activate routine if not turned on yet */
Debug((stderr," on_open pointer `%d'\n",p->on_open));
		if(p->on_open && p->active == NO) (*p->on_open)(p->open_param);
		p->active = YES;
	 }


}
/*---------------------------------------*/
expire_package(p, next, code)
  Package	*p, *next;
  int		code;
{
  Mapped_items	*m;
  Packpos	pck, *pack = &pck;
  Screen	*s;
  Screenlist    *sl;
  Element	*e;
  Dimension	*d;
  int		unmap_screens = YES;
  char		*func = "expire_package";
  char 		cmd[Nchars];
  WindowInfo    info;
  int		i, status;

	switch(code)
	{
		case DO_NEXT:
			next = (p == p->unext) ? 0 : p->unext;
			break;
		case DO_PREV:
			next = p->uprev;
			break;
		case DO_PACK:
			break;
		case DO_STOP:
			next = 0;
			break;
	 }

Debug((stderr,"%s: `%s'; next `%s'\n",func,p->name, next ? next->name : 0));
	
	if(p->on_close && p->active == YES)
	{
Debug((stderr,"  on_close at %d\n",p->on_close));
		(*p->on_close)(p->close_param);
	 }
	p->active = NO;
	if(next)
	{
		next->active = YES;
		pack->p = next;
		pack->pname = newstr(next->name);
	        for(i = 0; i < MaxDims && next->dimension[i]; ++i)
	        {
Debug((stderr,"%s: pos[%d]: `%d'\n",func,i,next->dimension[i]->initial));
		        pack->pos[i] = next->dimension[i]->initial;
	         }
	 
		if(next->window == p->window)
		{
			unmap_screens = NO;
		 }
	 }
	if(unmap_screens == YES)
	{
Debug((stderr," unmapping screens.."));
		s = p->window;
		while (s != 0)
		{
/*			XUnmapSubwindows(s->w); */
			if( !XUnmapWindow( (Window) s->w))
			{
				printf("%s: failed XUnmapWindow\n", func);
				exit(1);
	 	 	 }
			s = s->next;
		 }
Debug((stderr,"done\n"));
	 }

 	e = p->element;
	while(e !=0)
	{
		sl = e->screen;
		while(sl)
		{
			sl->s->occupant = (Element *)NULL;
			sl = sl->next;
		 }
		if(e->type == TK_WIDGET)
		{
Debug((stderr," unmapping widgets.."));
			m = e->mapped_widgets;
			while(m != 0)
			{
	   			XUnmapWindow((Window)m->map->simple.w);
				m = m->next;
	 	 	 }
		        e->mapped_widgets = 0;
Debug((stderr,"done\n"));
	 	 }
		if(e->type == PACKAGE_ELE)
		{
Debug((stderr," unmapping package elements.."));
			m = e->mapped_packages;
			while(m != 0)
			{
			        expire_package(e->mapped_packages->map->simple.package,  
				(Package *) 0, DO_STOP);
				m = m->next;
	 	 	 }
		        e->mapped_packages = 0;
Debug((stderr,"done\n"));
	 	 }
		if(e->type == TEXT)
		{
			XUnmapWindow(e->screen->s->w);
		 }
		if(disc->controlling_element == e) 
		{
Debug((stderr,"  found ele `%s' controlling disc..",e->name));
		     	d = e->p->dimension[e->map->simple.key_dimension];
Debug((stderr,"dim `%s'\n",d->name));
			if((status = Vdisc_still) != 0)
			{
			    fprintf(stderr,"%s: Vdisc_still, status %d\n",
		    		 func,status);
			    exit(1);
	 		 }
			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n"
				    ,func);
				exit(1);
	 		  }

			if(unmap_screens == NO)
			{
			    if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			    {
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    func, e->screen->s->w);
				exit(1);
	 		     }
			 }
			disc->operation = VDSC_STOPPED;

		   	stop_timer(d); 
   			d->rate = 0;
			d->rate_setting = d->rate_default;
		 }
		e = e->next;
	 }
	XFlush();

	if(next)
	{
Debug((stderr,"  activating `%s'\n",next->name));
		activate_package(next);
	 }
Debug((stderr,"%s: done\n",func));

}


void
rset_position(packpos)
  Packpos  	*packpos;
{
	char		*funcname = "rset_position";
  	Package		*p = packpos->p;
	Dimension	*d;
  	int		i, tmp, position_changed = 0;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		


	for(i=0; i < p->ndims && (d = p->dimension[i]); ++i){
		if(d->change != FROZEN)
		{
			tmp = d->current + (packpos->pos[i] * d->delta_sign);
			if(tmp > d->max || tmp < d->min)
			{
				if(d->boundary == EXPIRE)
				{
					expire_package(p, p->unext, DO_NEXT);
					return;
				 }
				else
				{
			       	     d->current = boundary(d, packpos->pos[i]);
				 }
		 	 }
			else
			{
			       d->current += (packpos->pos[i] * d->delta_sign);
		         }
			p->prev_position[i] = p->position[i];
			p->position[i] = d->current;

			/* Set a flag if position on this dim has changed */
			if(p->prev_position[i] != p->position[i])
			{
				position_changed = 1;
			 }
		}
	 }

	if(position_changed) /* ...then update display, otherwise don't. */
	{
		update_package_display(p);
		update_dimension_representations(p);
	 }
}


/*-------------------------------*/
  void
pace(pack)
  Packpos	*pack;
{
	static char 	*func = "pace";
	int 		step_size;
	int		i,msec,tmp;
	float           x;
	Package		*p = pack->p;
	Dimension	*d;
        struct timeval        nw, *now = &nw;
        struct timezone       tmz, *timezone = &tmz;

	/* the idea of this routine is to synchronize events as closely as
	*  possible to real time video.  Video runs at 33 msec frame rate,
	*  normal speed.  A dimension paced to video should step along at
	*  the same rate.  Processing events makes dimensions fall behind.
	*  Solution is to take bigger steps less frequently, losing some
	*  `resolution' in the bigger step size, but keeping up better 
	*  overall.  This routine watches the time deficit (global) and adjusts
	*  step and interval sizes accordingly.
	*     Input is a packpos struct indicating in this case which dimension
	*  is to be paced.  pname holds the name, the `position' is used as
	*  a flag for which dimension(s) to pace, e.g. test,1,0,0 -> pace
	*  test->dimension[0].
	*/

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(pack->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, pack->pname);
	     		 }
      	 	 }
		pack->p = p = tpck;
	}		
	
	/* locate the dimension to pace */
	for(i = 0; i < p->ndims && pack->pos[i] == 0; ++i);
	if( i >= p->ndims)
	{
		printf("%s: error finding dimension to pace in package `%s'\n",
		    func, p->name);
		exit(1);
	 }
	d = p->dimension[i];


        gettimeofday(now,timezone);  		
        msec = ((now->tv_sec - d->start_time.tv_sec) * 1000);
	msec += (now->tv_usec / 1000);
	msec -= (d->start_time.tv_usec / 1000);
Debug((stderr,"now sec `%d', usec `%d';  start sec `%d',usec `%d'\n",now->tv_sec,now->tv_usec, d->start_time.tv_sec, d->start_time.tv_usec));

	tmp = (d->rate)? d->start_point + (msec/d->rate): d->max;
Debug((stderr,"elapsed `%d', tmp `%d'\n",msec,tmp));
	if(tmp > d->max || tmp < d->min)
	{
		if(d->boundary == EXPIRE)
		{
			expire_package(p, p->unext, DO_NEXT);
			return;
		 }
		else
		{
	       	     	d->current = boundary(d, tmp - d->current);
		 }
	 }
	else
	{
	       d->current = tmp;
	 }

	/* Find this dimension in the package array */
	for(i=0;p->dimension[i] != d && p->dimension[i]; ++i);
	if(!p->dimension[i])
	{
		printf("%s: couldn't match dimension `%d'\n",func,d);
		exit(1);
	 }
	p->prev_position[i] = p->position[i];
	p->position[i] = d->current;

	update_package_display(p);
	update_dimension_representations(p);
}
		
/*-------------------------------*/
  void
do_next(packpos)
    Packpos	*packpos;
{
    char        *func = "do_next";

printf("%s: expiring package %s\n",func,packpos->e->p->name);
	expire_package(packpos->e->p, (Package *) 0, DO_NEXT);
}

/*-------------------------------*/
  void
do_prev(packpos)
    Packpos	*packpos;
{
    char        *func = "do_prev";

printf("%s: expiring package %s\n",func,packpos->e->p->name);
	expire_package(packpos->e->p, (Package *) 0, DO_PREV);  
}

/*-------------------------------*/
  void
expire(packpos)
  Packpos	*packpos;
{
    char        *func = "expire";
    Package     *tpck;

        if(packpos->pname)
	{
		if(!packpos->p)
		{
			Package *tpck = first_package;
			while(strcmp(packpos->pname, tpck->name) != MATCH)
        		{
	    			if((tpck = tpck->next) == 0)
	    			{
					printf("%s: can't find package `%s'\n"
				         ,func, packpos->pname);
	     		 	 }
      	 	 	 }
			packpos->p = tpck;
		 }		
Debug((stderr,"%s: expiring package %s\n",func,packpos->p->name));
	         expire_package(packpos->p, (Package *) 0, DO_STOP);  
	 }
	else
	{
Debug((stderr,"%s: expiring package %s\n",func,packpos->e->p->name));
		expire_package(packpos->e->p, (Package *) 0, DO_STOP);  
	 }
}

/*-------------------------------*/
    void
switch_to(packpos)
    Packpos	*packpos;
{
    Package	*p = packpos->p;
    char	*func = "switch_to";
    int         i;

Debug((stderr,"%s\n",func));

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}

       	for(i=0; i < p->ndims; ++i)
	{
		p->dimension[i]->current = packpos->pos[i];
		p->prev_position[i] = p->position[i];
		p->position[i] = packpos->pos[i];
	 }


	expire_package(packpos->e->p, p, DO_PACK);
}

/*---------------------------------*/
     void
activate(packpos)
    Packpos	*packpos;
{
    Package	*p = packpos->p;
    char	*func = "activate";

Debug((stderr,"%s\n",func));

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		

	activate_package(p);
}


/*---------------------------------*/
     void
activate_reset(packpos)
    Packpos	*packpos;
{
    Package	*p = packpos->p;
    char	*func = "activate_reset";
    int 	i;
Debug((stderr,"%s\n",func));

	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,func, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}

        for (i = 0; i < p->ndims; ++i)
	{
		p->dimension[i]->current = p->dimension[i]->initial;
		p->prev_position[i] = p->position[i];
		p->position[i] = p->dimension[i]->initial;
	 }
		

	activate_package(p);
}




void
set_rate(packpos)
	Packpos		*packpos;
{
	char		*funcname = "set_rate";
  	Package  	*p = packpos->p;
  	int	i;


	if(!p)
	{
		Package *tpck = first_package;
		while(strcmp(packpos->pname, tpck->name) != MATCH)
        	{
	    		if((tpck = tpck->next) == 0)
	    		{
				printf("%s: can't find package `%s'\n"
				    ,funcname, packpos->pname);
	     		 }
      	 	 }
		packpos->p = p = tpck;
	}		
	
	for(i=0; i < p->ndims; ++i)
	{
		p->dimension[i]->rate_setting = packpos->pos[i];
		p->dimension[i]->rate = 0;
	 }
	update_dimension_representations(p);
	update_package_display(p);
}

